/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.particle.component.emitter.lifetime;

import java.io.IOException;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleBuilder;
import moe.plushie.armourers_workshop.core.skin.particle.SkinParticleComponent;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IInputStream;
import moe.plushie.armourers_workshop.core.skin.serializer.io.IOutputStream;
import moe.plushie.armourers_workshop.core.utils.OpenPrimitive;

public class EmitterLoopingLifetime
extends SkinParticleComponent {
    private final OpenPrimitive activeTime;
    private final OpenPrimitive sleepTime;

    public EmitterLoopingLifetime(OpenPrimitive activeTime, OpenPrimitive sleepTime) {
        this.activeTime = activeTime;
        this.sleepTime = sleepTime;
    }

    public EmitterLoopingLifetime(IInputStream stream) throws IOException {
        this.activeTime = stream.readPrimitiveObject();
        this.sleepTime = stream.readPrimitiveObject();
    }

    @Override
    public void writeToStream(IOutputStream stream) throws IOException {
        stream.writePrimitiveObject(this.activeTime);
        stream.writePrimitiveObject(this.sleepTime);
    }

    @Override
    public void applyToBuilder(SkinParticleBuilder builder) throws Exception {
        Expression activeTime = builder.compile(this.activeTime, 10.0);
        Expression sleepTime = builder.compile(this.sleepTime, 0.0);
        builder.updateEmitter((emitter, context) -> {
            double active = activeTime.compute(context);
            double sleep = sleepTime.compute(context);
            double time = emitter.getTime();
            emitter.setDuration(active);
            if (time >= active && emitter.isRunning()) {
                emitter.stop();
            }
            if (time >= sleep && !emitter.isRunning()) {
                emitter.start();
            }
        });
    }
}

