/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IMenuType;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.ABI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.SystemMessageProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.DataDomain;
import moe.plushie.armourers_workshop.core.data.UserNotifications;
import moe.plushie.armourers_workshop.core.data.slot.ItemOverrideType;
import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.network.UpdateAnimationPacket;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.serializer.exporter.SkinExportManager;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.core.utils.TypedRegistry;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModConfigSpec;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.init.ModItems;
import moe.plushie.armourers_workshop.init.ModMenuTypes;
import moe.plushie.armourers_workshop.init.command.ColorArgumentType;
import moe.plushie.armourers_workshop.init.command.ColorSchemeArgumentType;
import moe.plushie.armourers_workshop.init.command.FileArgumentType;
import moe.plushie.armourers_workshop.init.command.ListArgumentType;
import moe.plushie.armourers_workshop.init.command.ReflectArgumentBuilder;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import moe.plushie.armourers_workshop.init.event.common.RegisterCommandsEvent;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import moe.plushie.armourers_workshop.library.data.SkinLibraryManager;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.NBTCompoundTagArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;

public class ModCommands {
    private static final Map<String, SkinPaintType> DYE_TYPES = Collections.immutableMap(it -> {
        for (int i = 0; i < 8; ++i) {
            SkinPaintType paintType = SkinPaintTypes.byId(i + 1);
            String name = paintType.registryName().path();
            it.put((Object)name.replaceAll("_", ""), (Object)paintType);
        }
    });
    private static final DynamicCommandExceptionType ERROR_NOT_ENOUGH_SLOT = new DynamicCommandExceptionType(ob -> TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.armourers.error.notEnoughSlot", ob));
    private static final DynamicCommandExceptionType ERROR_NOT_RUNNING_IN_SERVER = new DynamicCommandExceptionType(ob -> TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.armourers.error.notRunningInServer", new Object[0]));
    private static final DynamicCommandExceptionType ERROR_MISSING_DYE_SLOT = new DynamicCommandExceptionType(ob -> TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.armourers.error.missingDyeSlot", ob));
    private static final DynamicCommandExceptionType ERROR_MISSING_SKIN = new DynamicCommandExceptionType(ob -> TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.armourers.error.missingSkin", ob));
    private static final DynamicCommandExceptionType ERROR_NOT_FOUND_SKIN = new DynamicCommandExceptionType(ob -> TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.armourers.error.notFoundSkin", ob));
    private static final DynamicCommandExceptionType ERROR_MISSING_ITEM_STACK = new DynamicCommandExceptionType(ob -> TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.armourers.error.missingItemSkinnable", ob));

    public static void init(RegisterCommandsEvent event) {
        event.register(ModCommands.commands());
    }

    public static LiteralArgumentBuilder<CommandSource> commands() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ModCommands.literal("armourers").then(ReflectArgumentBuilder.literal("config", ModConfig.Client.class))).then(ReflectArgumentBuilder.literal("debug", ModDebugger.class))).requires(source -> source.func_197034_c(2))).then(((LiteralArgumentBuilder)ModCommands.literal("library").then(ModCommands.literal("reload").executes(Executor::reloadLibrary))).then(ModCommands.literal("auth").executes(Executor::printPrivateKey)))).then(ModCommands.literal("setSkin").then(ModCommands.entities().then(ModCommands.slotNames().then(ModCommands.slots().then(ModCommands.skins().then(ModCommands.skinDying().executes(Executor::setSkin)).executes(Executor::setSkin))).then(ModCommands.skins().then(ModCommands.skinDying().executes(Executor::setSkin)).executes(Executor::setSkin)))))).then(ModCommands.literal("giveSkin").then(ModCommands.players().then(ModCommands.skins().then(ModCommands.skinDying().executes(Executor::giveSkin)).executes(Executor::giveSkin))))).then(ModCommands.literal("clearSkin").then(ModCommands.entities().then(ModCommands.slotNames().then(ModCommands.slots().executes(Executor::clearSkin))).executes(Executor::clearSkin)))).then(ModCommands.literal("exportSkin").then(ModCommands.skinFormats().then(ModCommands.name().then(ModCommands.scale().executes(Executor::exportSkin)).executes(Executor::exportSkin))))).then(ModCommands.literal("setColor").then(ModCommands.entities().then(ModCommands.dyesSlotNames().then(ModCommands.dyeColor().executes(Executor::setColor)))))).then(ModCommands.literal("rsyncWardrobe").then(ModCommands.players().executes(Executor::resyncWardrobe)))).then(ModCommands.literal("openWardrobe").then(ModCommands.entities().executes(Executor::openWardrobe)))).then(ModCommands.literal("itemSkinnable").then(ModCommands.addOrRemove().then(ModCommands.overrideTypes().executes(Executor::setItemSkinnable))))).then(ModCommands.literal("animation", "<entity_block_target>", ModCommands::animationCommands))).then(ModCommands.literal("setUnlockedSlots").then(ModCommands.entities().then(ModCommands.resizableSlotNames().then(ModCommands.resizableSlotAmounts().executes(Executor::setUnlockedWardrobeSlots)))));
    }

    static LiteralArgumentBuilder<CommandSource> literal(String name) {
        return Commands.func_197057_a((String)name);
    }

    static ArgumentBuilder<CommandSource, ?> literal(String name, String desc, Function<ArgumentBuilder<CommandSource, ?>, ArgumentBuilder<CommandSource, ?>> transformer) {
        return ((LiteralArgumentBuilder)ModCommands.literal(name).then(ModCommands.literal("entity").then(transformer.apply(ModCommands.entities())))).then(ModCommands.literal("block").then(transformer.apply(ModCommands.blockPos())));
    }

    static ArgumentBuilder<CommandSource, ?> animationCommands(ArgumentBuilder<CommandSource, ?> parent) {
        return parent.then(ModCommands.literal("play").then(ModCommands.name().then(ModCommands.properties().executes(Executor::playAnimation)).executes(Executor::playAnimation))).then(((LiteralArgumentBuilder)ModCommands.literal("stop").then(ModCommands.name().executes(Executor::stopAnimation))).executes(Executor::stopAnimation)).then(ModCommands.literal("map").then(ModCommands.string("from").then(ModCommands.string("to").executes(Executor::mappingAnimation))));
    }

    static ArgumentBuilder<CommandSource, ?> players() {
        return Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d());
    }

    static ArgumentBuilder<CommandSource, ?> entities() {
        return Commands.func_197056_a((String)"entities", (ArgumentType)EntityArgument.func_197093_b());
    }

    static ArgumentBuilder<CommandSource, ?> blockPos() {
        return Commands.func_197056_a((String)"block_pos", (ArgumentType)BlockPosArgument.func_197276_a());
    }

    static ArgumentBuilder<CommandSource, ?> string(String name) {
        return Commands.func_197056_a((String)name, (ArgumentType)StringArgumentType.string());
    }

    static ArgumentBuilder<CommandSource, ?> slots() {
        return Commands.func_197056_a((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)1));
    }

    static ArgumentBuilder<CommandSource, ?> skinFormats() {
        return Commands.func_197056_a((String)"format", (ArgumentType)ListArgumentType.list(SkinExportManager.allExporters()));
    }

    static ArgumentBuilder<CommandSource, ?> skinDying() {
        return Commands.func_197056_a((String)"dying", (ArgumentType)new ColorSchemeArgumentType());
    }

    static ArgumentBuilder<CommandSource, ?> dyesSlotNames() {
        return Commands.func_197056_a((String)"dye_slot", (ArgumentType)new ListArgumentType(DYE_TYPES.keySet()));
    }

    static ArgumentBuilder<CommandSource, ?> dyeColor() {
        return Commands.func_197056_a((String)"color", (ArgumentType)new ColorArgumentType());
    }

    static ArgumentBuilder<CommandSource, ?> scale() {
        return Commands.func_197056_a((String)"scale", (ArgumentType)FloatArgumentType.floatArg());
    }

    static ArgumentBuilder<CommandSource, ?> name() {
        return Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.string());
    }

    static ArgumentBuilder<CommandSource, ?> properties() {
        return Commands.func_197056_a((String)"properties", (ArgumentType)NBTCompoundTagArgument.func_218043_a());
    }

    static ArgumentBuilder<CommandSource, ?> resizableSlotAmounts() {
        return Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)10));
    }

    static ArgumentBuilder<CommandSource, ?> resizableSlotNames() {
        return Commands.func_197056_a((String)"slot_name", (ArgumentType)new ListArgumentType(Collections.compactMap(SkinSlotType.values(), slotType -> {
            if (slotType.isResizable()) {
                return slotType.serializedName();
            }
            return null;
        })));
    }

    static ArgumentBuilder<CommandSource, ?> slotNames() {
        return Commands.func_197056_a((String)"slot_name", (ArgumentType)new ListArgumentType(Collections.compactMap(SkinSlotType.values(), SkinSlotType::serializedName)));
    }

    static ArgumentBuilder<CommandSource, ?> overrideTypes() {
        return Commands.func_197056_a((String)"skin_type", (ArgumentType)new ListArgumentType(Collections.compactMap(ItemOverrideType.values(), ItemOverrideType::serializedName)));
    }

    static ArgumentBuilder<CommandSource, ?> skins() {
        return Commands.func_197056_a((String)"skin", (ArgumentType)new FileArgumentType(EnvironmentManager.getSkinLibraryDirectory()));
    }

    static ArgumentBuilder<CommandSource, ?> addOrRemove() {
        return Commands.func_197056_a((String)"operator", (ArgumentType)new ListArgumentType(Collections.newList("add", "remove")));
    }

    private static class Executor {
        private Executor() {
        }

        static int printPrivateKey(CommandContext<CommandSource> context) throws CommandSyntaxException {
            SkinLibraryManager.Server server = SkinLibraryManager.getServer();
            if (!server.isRunning()) {
                throw ERROR_NOT_RUNNING_IN_SERVER.create(null);
            }
            String token = server.privateKey();
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.armourers.library.printToken", token), true);
            return 0;
        }

        static int reloadLibrary(CommandContext<CommandSource> context) throws CommandSyntaxException {
            SkinLibraryManager.getServer().start();
            return 0;
        }

        static boolean containsNode(CommandContext<CommandSource> context, String name) {
            for (ParsedCommandNode node : context.getNodes()) {
                if (!name.equals(node.getNode().getName())) continue;
                return true;
            }
            return false;
        }

        static int setColor(CommandContext<CommandSource> context) throws CommandSyntaxException {
            SkinPaintType paintType = (SkinPaintType)DYE_TYPES.get(ListArgumentType.getString(context, "dye_slot"));
            if (paintType == null) {
                throw ERROR_MISSING_DYE_SLOT.create(null);
            }
            SkinPaintColor paintColor = ColorArgumentType.getColor(context, "color");
            for (Entity entity : EntityArgument.func_197097_b(context, (String)"entities")) {
                SkinWardrobe wardrobe = SkinWardrobe.of(entity);
                if (wardrobe == null) continue;
                int slot = SkinSlotType.getDyeSlotIndex(paintType);
                ItemStack itemStack = new ItemStack((IItemProvider)ModItems.BOTTLE.get());
                ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get(), paintColor);
                IInventory inventory = wardrobe.inventory();
                inventory.func_70299_a(slot, itemStack);
                wardrobe.broadcast();
            }
            return 0;
        }

        static int giveSkin(CommandContext<CommandSource> context) throws CommandSyntaxException {
            SkinDescriptor descriptor = Executor.loadSkinDescriptor(context);
            ItemStack itemStack = descriptor.asItemStack();
            for (PlayerEntity player : EntityArgument.func_197090_e(context, (String)"targets")) {
                ABI.giveItem(player, itemStack);
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "commands.give.success.single", 1, itemStack.func_151000_E(), player.func_145748_c_()), true);
            }
            return 1;
        }

        static int setSkin(CommandContext<CommandSource> context) throws CommandSyntaxException {
            SkinDescriptor descriptor = Executor.loadSkinDescriptor(context);
            ItemStack itemStack = descriptor.asItemStack();
            for (Entity entity : EntityArgument.func_197097_b(context, (String)"entities")) {
                SkinSlotType slotType;
                SkinWardrobe wardrobe = SkinWardrobe.of(entity);
                if (wardrobe == null || (slotType = SkinSlotType.byName(ListArgumentType.getString(context, "slot_name"))) == null) continue;
                int slot = wardrobe.getFreeSlot(slotType);
                if (Executor.containsNode(context, "slot")) {
                    slot = IntegerArgumentType.getInteger(context, (String)"slot") - 1;
                }
                if (slot > slotType.maxSize()) {
                    throw ERROR_NOT_ENOUGH_SLOT.create((Object)slotType.maxSize());
                }
                wardrobe.setItem(slotType, slot, itemStack);
                wardrobe.broadcast();
            }
            return 0;
        }

        static int clearSkin(CommandContext<CommandSource> context) throws CommandSyntaxException {
            for (Entity entity : EntityArgument.func_197097_b(context, (String)"entities")) {
                SkinWardrobe wardrobe = SkinWardrobe.of(entity);
                if (wardrobe == null) continue;
                if (!Executor.containsNode(context, "slot")) {
                    wardrobe.clear();
                    wardrobe.broadcast();
                    continue;
                }
                int slot = IntegerArgumentType.getInteger(context, (String)"slot");
                SkinSlotType slotType = SkinSlotType.byName(ListArgumentType.getString(context, "slot_name"));
                if (slotType == null) continue;
                if (slot > slotType.maxSize()) {
                    throw ERROR_NOT_ENOUGH_SLOT.create((Object)slotType.maxSize());
                }
                wardrobe.setItem(slotType, slot - 1, ItemStack.field_190927_a);
                wardrobe.broadcast();
            }
            return 0;
        }

        static int exportSkin(CommandContext<CommandSource> context) throws CommandSyntaxException {
            String format = ListArgumentType.getString(context, "format");
            String filename = StringArgumentType.getString(context, (String)"name");
            float scale = 1.0f;
            if (Executor.containsNode(context, "scale")) {
                scale = FloatArgumentType.getFloat(context, (String)"scale");
            }
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            ItemStack itemStack = player.func_184614_ca();
            String identifier = SkinDescriptor.of(itemStack).identifier();
            Skin skin = SkinLoader.getInstance().loadSkin(identifier);
            if (skin == null) {
                throw ERROR_MISSING_SKIN.create((Object)identifier);
            }
            float resolvedScale = scale;
            CompoundNBT tag = new CompoundNBT();
            tag.func_74778_a("Skin", identifier);
            if (!skin.settings().isExportable()) {
                SystemMessageProvider.sendSystemMessage((PlayerEntity)player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.armourers.error.notExportInServer", identifier));
                UserNotifications.sendSystemToast((ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.armourers.error.notExportInServer", identifier), tag, (PlayerEntity)player);
                return 0;
            }
            SystemMessageProvider.sendSystemMessage((PlayerEntity)player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.armourers.exportSkin.processing", filename));
            UserNotifications.sendSystemToast((ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.notify.exportSkin.processing", new Object[0]), tag, (PlayerEntity)player);
            EnvironmentExecutor.runOnBackground(() -> () -> {
                try {
                    SkinExportManager.exportSkin(skin, format, filename, resolvedScale);
                    SystemMessageProvider.sendSystemMessage((PlayerEntity)player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.armourers.exportSkin.success", filename));
                    UserNotifications.sendSystemToast((ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.notify.exportSkin.success", new Object[0]), tag, (PlayerEntity)player);
                }
                catch (Exception e) {
                    SystemMessageProvider.sendSystemMessage((PlayerEntity)player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.armourers.exportSkin.failure", filename));
                    UserNotifications.sendSystemToast((ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "commands.armourers_workshop.notify.exportSkin.failure", new Object[0]), tag, (PlayerEntity)player);
                    e.printStackTrace();
                }
            });
            return 0;
        }

        static int setItemSkinnable(CommandContext<CommandSource> context) throws CommandSyntaxException {
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            String operator = ListArgumentType.getString(context, "operator");
            ItemOverrideType overrideType = ItemOverrideType.of(ListArgumentType.getString(context, "skin_type"));
            ItemStack itemStack = player.func_184614_ca();
            if (overrideType == null || itemStack.func_190926_b()) {
                throw ERROR_MISSING_ITEM_STACK.create((Object)player.func_195047_I_());
            }
            IResourceLocation identifier = TypedRegistry.findKey(itemStack.func_77973_b());
            String key = String.format("%s:%s", overrideType.serializedName(), identifier);
            if (operator.equals("add")) {
                if (ModConfig.Common.overrides.contains(key)) {
                    return 1;
                }
                ModConfig.Common.overrides.add(key);
            } else {
                if (!ModConfig.Common.overrides.contains(key)) {
                    return 1;
                }
                ModConfig.Common.overrides.remove(key);
            }
            ModConfigSpec.COMMON.save();
            String messageKey = "commands.armourers_workshop.armourers.setItemSkinnable." + operator;
            IFormattableTextComponent overrideTypeName = TranslateUtils.Name.of(overrideType);
            SystemMessageProvider.sendSystemMessage((PlayerEntity)player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, messageKey, itemStack.func_151000_E(), overrideTypeName));
            return 1;
        }

        static int resyncWardrobe(CommandContext<CommandSource> context) throws CommandSyntaxException {
            for (ServerPlayerEntity player : EntityArgument.func_197090_e(context, (String)"targets")) {
                SkinWardrobe wardrobe = SkinWardrobe.of((Entity)player);
                if (wardrobe == null) continue;
                wardrobe.broadcast();
            }
            return 1;
        }

        static int openWardrobe(CommandContext<CommandSource> context) throws CommandSyntaxException {
            ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
            for (Entity entity : EntityArgument.func_197097_b(context, (String)"entities")) {
                SkinWardrobe wardrobe = SkinWardrobe.of(entity);
                if (wardrobe == null) continue;
                ((IMenuType)ModMenuTypes.WARDROBE_OP.get()).openMenu((PlayerEntity)player, wardrobe);
                break;
            }
            return 1;
        }

        static int setUnlockedWardrobeSlots(CommandContext<CommandSource> context) throws CommandSyntaxException {
            for (Entity entity : EntityArgument.func_197097_b(context, (String)"entities")) {
                SkinSlotType slotType;
                SkinWardrobe wardrobe = SkinWardrobe.of(entity);
                if (wardrobe == null || (slotType = SkinSlotType.byName(ListArgumentType.getString(context, "slot_name"))) == null) continue;
                int amount = IntegerArgumentType.getInteger(context, (String)"amount");
                wardrobe.setUnlockedSize(slotType, OpenMath.clamp(amount, 0, slotType.maxSize()));
                wardrobe.broadcast();
            }
            return 1;
        }

        static SkinDescriptor loadSkinDescriptor(CommandContext<CommandSource> context) throws CommandSyntaxException {
            String identifier = FileArgumentType.getString(context, "skin");
            if (identifier.isEmpty()) {
                throw ERROR_MISSING_SKIN.create((Object)identifier);
            }
            SkinPaintScheme scheme = SkinPaintScheme.EMPTY;
            if (Executor.containsNode(context, "dying")) {
                scheme = ColorSchemeArgumentType.getColorScheme(context, "dying");
            }
            boolean needCopy = false;
            if (identifier.startsWith("/")) {
                identifier = DataDomain.DEDICATED_SERVER.normalize(identifier);
                needCopy = true;
            }
            if (DataDomain.RESOURCE_PACK.matches(identifier)) {
                return new SkinDescriptor(identifier);
            }
            SkinDescriptor descriptor = SkinLoader.getInstance().loadSkinFromDB(identifier, scheme, needCopy);
            if (descriptor.isEmpty()) {
                throw ERROR_NOT_FOUND_SKIN.create((Object)identifier);
            }
            return descriptor;
        }

        public static int playAnimation(CommandContext<CommandSource> context) throws CommandSyntaxException {
            CompoundNBT properties = new CompoundNBT();
            if (Executor.containsNode(context, "properties")) {
                properties = NBTCompoundTagArgument.func_218042_a(context, (String)"properties");
            }
            String animationName = StringArgumentType.getString(context, (String)"name");
            for (UpdateAnimationPacket.Selector selector : Executor.getAnimationSelector(context)) {
                NetworkManager.sendToAll(UpdateAnimationPacket.play(selector, animationName, properties));
            }
            return 0;
        }

        public static int stopAnimation(CommandContext<CommandSource> context) throws CommandSyntaxException {
            String animationName = "";
            if (Executor.containsNode(context, "name")) {
                animationName = StringArgumentType.getString(context, (String)"name");
            }
            for (UpdateAnimationPacket.Selector selector : Executor.getAnimationSelector(context)) {
                NetworkManager.sendToAll(UpdateAnimationPacket.stop(selector, animationName));
            }
            return 0;
        }

        public static int mappingAnimation(CommandContext<CommandSource> context) throws CommandSyntaxException {
            String from = StringArgumentType.getString(context, (String)"from");
            String to = StringArgumentType.getString(context, (String)"to");
            for (UpdateAnimationPacket.Selector selector : Executor.getAnimationSelector(context)) {
                NetworkManager.sendToAll(UpdateAnimationPacket.rewrite(selector, from, to));
            }
            return 0;
        }

        private static List<UpdateAnimationPacket.Selector> getAnimationSelector(CommandContext<CommandSource> context) throws CommandSyntaxException {
            ArrayList<UpdateAnimationPacket.Selector> selectors = new ArrayList<UpdateAnimationPacket.Selector>();
            if (Executor.containsNode(context, "entities")) {
                for (Entity entity : EntityArgument.func_197097_b(context, (String)"entities")) {
                    selectors.add(new UpdateAnimationPacket.Selector(entity));
                }
            }
            if (Executor.containsNode(context, "block_pos")) {
                BlockPos blockPos = moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.commands.arguments.coordinates.BlockPosArgument.ABI.getBlockPos(BlockPosArgument.class, context, "block_pos");
                selectors.add(new UpdateAnimationPacket.Selector(blockPos));
            }
            return selectors;
        }
    }
}

