/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform;

import java.util.Map;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.server.packs.resources.ResourceManager.Converter;
import moe.plushie.armourers_workshop.core.data.DataPackBuilder;
import moe.plushie.armourers_workshop.core.data.DataPackLoader;
import moe.plushie.armourers_workshop.core.data.DataPackType;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.event.common.DataPackEvent;
import moe.plushie.armourers_workshop.init.platform.EventManager;
import net.minecraft.resources.IResourceManager;

public class DataPackManager {
    private static final Map<DataPackType, DataPackLoader> INSTANCES = Collections.immutableMap(it -> {
        it.put((Object)DataPackType.SERVER_DATA, (Object)new Data());
        it.put((Object)DataPackType.CLIENT_RESOURCES, (Object)new Resources());
        it.put((Object)DataPackType.BUNDLED_DATA, (Object)new Bundle());
    });

    public static DataPackLoader byType(DataPackType packType) {
        return INSTANCES.get((Object)packType);
    }

    public static void register(DataPackType packType, String path, Function<IResourceLocation, DataPackBuilder> provider, Runnable willLoadHandler, Runnable didLoadHandler, int order) {
        DataPackLoader loader = DataPackManager.byType(packType);
        if (loader != null) {
            loader.add(new DataPackLoader.Entry(path, provider, willLoadHandler, didLoadHandler, order));
        }
    }

    protected static class Data
    extends DataPackLoader {
        protected Data() {
        }

        @Override
        public void build(DataPackLoader.TaskQueue taskQueue, IResourceManager resourceManager) {
            DataPackLoader loader = DataPackManager.byType(DataPackType.BUNDLED_DATA);
            if (loader != null && !loader.isEmpty()) {
                loader.build(taskQueue, Converter.asBundleManager(resourceManager));
            }
            super.build(taskQueue, resourceManager);
            EventManager.post(DataPackEvent.Reloading.class, () -> DataPackType.SERVER_DATA);
        }
    }

    protected static class Resources
    extends DataPackLoader {
        protected Resources() {
        }

        @Override
        public void build(DataPackLoader.TaskQueue taskQueue, IResourceManager resourceManager) {
            DataPackLoader loader = DataPackManager.byType(DataPackType.BUNDLED_DATA);
            if (loader != null && !loader.isEmpty()) {
                loader.build(taskQueue, Converter.asBundleManager(resourceManager));
            }
            super.build(taskQueue, resourceManager);
            EventManager.post(DataPackEvent.Reloading.class, () -> DataPackType.CLIENT_RESOURCES);
        }
    }

    protected static class Bundle
    extends DataPackLoader {
        protected Bundle() {
        }

        @Override
        public void build(DataPackLoader.TaskQueue taskQueue, IResourceManager resourceManager) {
            super.build(taskQueue, resourceManager);
            this.entries.clear();
            EventManager.post(DataPackEvent.Reloading.class, () -> DataPackType.BUNDLED_DATA);
        }
    }
}

