/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.init.platform;

import java.io.File;
import java.util.ArrayList;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.core.data.DataManager;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.utils.OpenDistributionType;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.network.ServerReplayPacket;
import moe.plushie.armourers_workshop.init.platform.EnvironmentManager;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;

public class ReplayManager {
    private static boolean IS_REPLAYING = false;
    private static ArrayList<Runnable> REPLAY_CLEANER = new ArrayList();

    public static void init() {
    }

    public static void accept(ServerReplayPacket packet) {
        if (!IS_REPLAYING) {
            return;
        }
        switch (packet.event()) {
            case START_RECORDING: {
                ReplayManager.clean();
                IFriendlyByteBuf param = IFriendlyByteBuf.wrap(packet.parameters());
                OpenDistributionType distType = param.readEnum(OpenDistributionType.class);
                if (distType.isIntegratedServer()) {
                    File dbPath = new File(param.readUtf());
                    if (dbPath.exists()) {
                        DataManager.getInstance().connect(dbPath);
                        REPLAY_CLEANER.add(DataManager.getInstance()::disconnect);
                    } else {
                        ModLog.warn("replay skin-database missing", new Object[0]);
                    }
                }
                SkinLoader.getInstance().prepare(distType);
                SkinLoader.getInstance().start();
                REPLAY_CLEANER.add(() -> SkinLoader.getInstance().stop());
                break;
            }
            case STOP_RECORDING: {
                ReplayManager.clean();
            }
        }
    }

    public static void startReplay() {
        IS_REPLAYING = true;
    }

    public static void stopReplay() {
        IS_REPLAYING = false;
        ReplayManager.clean();
    }

    public static void startRecording(MinecraftServer server, PlayerEntity player) {
        ReplayManager.sendTo(player, ServerReplayPacket.Event.START_RECORDING, buf -> {
            if (server.func_71264_H() && server.func_213199_b(player.func_146103_bH())) {
                buf.writeEnum(OpenDistributionType.INTEGRATED_SERVER);
                buf.writeUtf(EnvironmentManager.getSkinDatabaseDirectory().getPath());
                return;
            }
            buf.writeEnum(OpenDistributionType.CLIENT);
        });
    }

    public static void stopRecording(MinecraftServer server, PlayerEntity player) {
        ReplayManager.sendTo(player, ServerReplayPacket.Event.STOP_RECORDING, null);
    }

    private static void sendTo(PlayerEntity player, ServerReplayPacket.Event event, Consumer<IFriendlyByteBuf> consumer) {
        NetworkManager.sendTo(new ServerReplayPacket(event, consumer), (ServerPlayerEntity)player);
    }

    private static void clean() {
        REPLAY_CLEANER.forEach(Runnable::run);
        REPLAY_CLEANER.clear();
    }
}

