/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.asm;

import com.teamderpy.shouldersurfing.config.Config;
import com.teamderpy.shouldersurfing.config.Perspective;
import com.teamderpy.shouldersurfing.util.ShoulderState;
import com.teamderpy.shouldersurfing.util.ShoulderSurfingHelper;
import java.util.AbstractMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class InjectionDelegation {
    public static void cameraSetup(float x, float y, float z) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (ShoulderState.doShoulderSurfing() && world != null) {
            Vec3d offset = new Vec3d(Config.CLIENT.getOffsetX(), -Config.CLIENT.getOffsetY(), -Config.CLIENT.getOffsetZ());
            double distance = ShoulderSurfingHelper.cameraDistance((World)world, offset.func_72433_c());
            Vec3d scaled = offset.func_72432_b().func_186678_a(distance);
            ShoulderState.setCameraDistance(distance);
            GlStateManager.func_179137_b((double)scaled.field_72450_a, (double)scaled.field_72448_b, (double)scaled.field_72449_c);
        } else {
            GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        }
    }

    public static int doRenderCrosshair() {
        return Config.CLIENT.getCrosshairVisibility(Perspective.current()).doRender(ShoulderState.isAiming()) ? 0 : 1;
    }

    public static RayTraceResult getRayTraceResult(World world, Vec3d vec1, Vec3d vec2) {
        return world.func_147447_a(vec1, vec2, false, true, false);
    }

    public static RayTraceResult rayTrace(Entity entity, double blockReachDistance, float partialTicks) {
        if (ShoulderState.doShoulderSurfing() && !Config.CLIENT.getCrosshairType().isDynamic()) {
            Map.Entry<Vec3d, Vec3d> look = ShoulderSurfingHelper.shoulderSurfingLook(entity, partialTicks, blockReachDistance * blockReachDistance);
            return entity.field_70170_p.func_147447_a(look.getKey(), look.getValue(), false, false, true);
        }
        Vec3d eyes = entity.func_174824_e(partialTicks);
        Vec3d look = entity.func_70676_i(partialTicks);
        Vec3d end = eyes.func_72441_c(look.field_72450_a * blockReachDistance, look.field_72448_b * blockReachDistance, look.field_72449_c * blockReachDistance);
        return entity.field_70170_p.func_147447_a(eyes, end, false, false, true);
    }

    public static Map.Entry<Vec3d, Vec3d> shoulderSurfingLook(double blockReach) {
        if (ShoulderState.doShoulderSurfing() && !Config.CLIENT.getCrosshairType().isDynamic()) {
            return ShoulderSurfingHelper.shoulderSurfingLook(Minecraft.func_71410_x().func_175606_aa(), Minecraft.func_71410_x().func_184121_ak(), blockReach * blockReach);
        }
        Entity renderView = Minecraft.func_71410_x().func_175606_aa();
        Vec3d look = renderView.func_70676_i(1.0f);
        Vec3d start = renderView.func_174824_e(Minecraft.func_71410_x().func_184121_ak());
        Vec3d end = start.func_72441_c(look.field_72450_a * blockReach, look.field_72448_b * blockReach, look.field_72449_c * blockReach);
        return new AbstractMap.SimpleEntry<Vec3d, Vec3d>(start, end);
    }
}

