/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.proxy;

import com.teamderpy.shouldersurfing.compatibility.EnumShaderCompatibility;
import com.teamderpy.shouldersurfing.config.Config;
import com.teamderpy.shouldersurfing.event.ClientEventHandler;
import com.teamderpy.shouldersurfing.event.KeyHandler;
import com.teamderpy.shouldersurfing.proxy.CommonProxy;
import com.teamderpy.shouldersurfing.util.ShoulderState;
import com.teamderpy.shouldersurfing.util.ShoulderSurfingHelper;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        Config.CLIENT = new Config.ClientConfig(new Configuration(event.getSuggestedConfigurationFile()));
        ShoulderSurfingHelper.setPerspective(Config.CLIENT.getDefaultPerspective());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new KeyHandler());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        ClientRegistry.registerKeyBinding((KeyBinding)KeyHandler.KEYBIND_CAMERA_LEFT);
        ClientRegistry.registerKeyBinding((KeyBinding)KeyHandler.KEYBIND_CAMERA_RIGHT);
        ClientRegistry.registerKeyBinding((KeyBinding)KeyHandler.KEYBIND_CAMERA_IN);
        ClientRegistry.registerKeyBinding((KeyBinding)KeyHandler.KEYBIND_CAMERA_OUT);
        ClientRegistry.registerKeyBinding((KeyBinding)KeyHandler.KEYBIND_CAMERA_UP);
        ClientRegistry.registerKeyBinding((KeyBinding)KeyHandler.KEYBIND_CAMERA_DOWN);
        ClientRegistry.registerKeyBinding((KeyBinding)KeyHandler.KEYBIND_SWAP_SHOULDER);
        ClientRegistry.registerKeyBinding((KeyBinding)KeyHandler.KEYBIND_TOGGLE_SHOULDER_SURFING);
    }

    @Override
    public void loadComplete(FMLLoadCompleteEvent event) {
        if (ClientProxy.isClassLoaded("shadersmod.client.Shaders")) {
            ShoulderState.setShaderType(EnumShaderCompatibility.OLD);
        } else if (ClientProxy.isClassLoaded("net.optifine.shaders.Shaders")) {
            ShoulderState.setShaderType(EnumShaderCompatibility.NEW);
        }
    }

    private static boolean isClassLoaded(String className) {
        try {
            return Class.forName(className) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

