/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.wardrobe;

import java.awt.Color;
import java.io.IOException;
import java.nio.FloatBuffer;
import moe.plushie.armourers_workshop.api.common.capability.IPlayerWardrobeCap;
import moe.plushie.armourers_workshop.api.common.capability.IWardrobeCap;
import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.controls.GuiTab;
import moe.plushie.armourers_workshop.client.gui.controls.GuiTabPanel;
import moe.plushie.armourers_workshop.client.gui.controls.GuiTabbed;
import moe.plushie.armourers_workshop.client.gui.style.GuiResourceManager;
import moe.plushie.armourers_workshop.client.gui.style.GuiStyle;
import moe.plushie.armourers_workshop.client.gui.wardrobe.tab.GuiTabWardrobeColourSettings;
import moe.plushie.armourers_workshop.client.gui.wardrobe.tab.GuiTabWardrobeContributor;
import moe.plushie.armourers_workshop.client.gui.wardrobe.tab.GuiTabWardrobeDisplaySettings;
import moe.plushie.armourers_workshop.client.gui.wardrobe.tab.GuiTabWardrobeDyes;
import moe.plushie.armourers_workshop.client.gui.wardrobe.tab.GuiTabWardrobeManExtras;
import moe.plushie.armourers_workshop.client.gui.wardrobe.tab.GuiTabWardrobeManOffset;
import moe.plushie.armourers_workshop.client.gui.wardrobe.tab.GuiTabWardrobeManRotations;
import moe.plushie.armourers_workshop.client.gui.wardrobe.tab.GuiTabWardrobeManTextureData;
import moe.plushie.armourers_workshop.client.gui.wardrobe.tab.GuiTabWardrobeOutfits;
import moe.plushie.armourers_workshop.client.gui.wardrobe.tab.GuiTabWardrobeSkins;
import moe.plushie.armourers_workshop.client.render.ModRenderHelper;
import moe.plushie.armourers_workshop.common.Contributors;
import moe.plushie.armourers_workshop.common.capability.entityskin.EntitySkinCapability;
import moe.plushie.armourers_workshop.common.config.ConfigHandler;
import moe.plushie.armourers_workshop.common.init.entities.EntityMannequin;
import moe.plushie.armourers_workshop.common.inventory.ContainerSkinWardrobe;
import moe.plushie.armourers_workshop.common.inventory.slot.SlotHidable;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.BufferUtils;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiWardrobe
extends GuiTabbed<ContainerSkinWardrobe> {
    private static final ResourceLocation TEXTURE_1 = new ResourceLocation("armourers_workshop:textures/gui/wardrobe/wardrobe-1.png");
    private static final ResourceLocation TEXTURE_2 = new ResourceLocation("armourers_workshop:textures/gui/wardrobe/wardrobe-2.png");
    private static final ResourceLocation GUI_JSON = new ResourceLocation("armourers_workshop:gui/wardrobe.json");
    private static final String GUI_NAME = "wardrobe";
    private final GuiStyle guiStyle = GuiResourceManager.getGuiJsonInfo(GUI_JSON);
    private static int activeTab;
    private final GuiTabWardrobeSkins tabSkins;
    private final GuiTabWardrobeOutfits tabOutfits;
    private final GuiTabWardrobeDisplaySettings tabDisplaySetting;
    private final GuiTabWardrobeColourSettings tabColourSettings;
    private final GuiTabWardrobeDyes tabDyes;
    private final GuiTabWardrobeContributor tabContributor;
    private final GuiTabWardrobeManTextureData tabManTextureData;
    private final GuiTabWardrobeManRotations tabManRotations;
    private final GuiTabWardrobeManExtras tabManExtras;
    private final GuiTabWardrobeManOffset tabManOffset;
    private EntitySkinCapability skinCapability;
    private EntityPlayer player;
    private boolean rotatingPlayer = false;
    private float playerRotation = 45.0f;
    private final boolean isPlayer;
    private final boolean isMannequin;
    private int lastMouseX;
    private int lastMouseY;

    public GuiWardrobe(InventoryPlayer inventory, EntitySkinCapability skinCapability, IWardrobeCap wardrobeCapability) {
        super(new ContainerSkinWardrobe(inventory, skinCapability, wardrobeCapability), false, TEXTURE_TAB_ICONS);
        this.field_146999_f = 278;
        this.field_147000_g = 250;
        this.player = inventory.field_70458_d;
        this.skinCapability = skinCapability;
        this.isPlayer = wardrobeCapability instanceof IPlayerWardrobeCap;
        this.isMannequin = skinCapability.getEntity() instanceof EntityMannequin;
        boolean isCreative = this.player.field_71075_bZ.field_75098_d;
        this.tabController.setTabsPerSide(5);
        this.tabSkins = new GuiTabWardrobeSkins(this.tabList.size(), (GuiScreen)this);
        this.tabList.add(this.tabSkins);
        GuiTab tabListItemSkins = new GuiTab(this.tabController, GuiHelper.getLocalizedControlName(GUI_NAME, "tab.skins", new Object[0]));
        tabListItemSkins.setIconLocation(192, 0);
        tabListItemSkins.setTabTextureSize(26, 30);
        tabListItemSkins.setPadding(0, 4, 3, 3);
        tabListItemSkins.setVisable(!this.isPlayer | this.isPlayer & (ConfigHandler.wardrobeTabSkins | isCreative));
        this.tabController.addTab(tabListItemSkins);
        this.tabOutfits = new GuiTabWardrobeOutfits(this.tabList.size(), (GuiScreen)this, this.player, skinCapability, wardrobeCapability);
        if (skinCapability.getSlotCountForSkinType(SkinTypeRegistry.skinOutfit) > 0) {
            this.tabList.add(this.tabOutfits);
            GuiTab tabListItemOutfits = new GuiTab(this.tabController, GuiHelper.getLocalizedControlName(GUI_NAME, "tab.outfits", new Object[0]));
            tabListItemOutfits.setIconLocation(0, 128);
            tabListItemOutfits.setTabTextureSize(26, 30);
            tabListItemOutfits.setPadding(0, 4, 3, 3);
            tabListItemOutfits.setVisable(!this.isPlayer | this.isPlayer & (ConfigHandler.wardrobeTabOutfits | isCreative));
            this.tabController.addTab(tabListItemOutfits);
        }
        if (this.isPlayer) {
            this.tabDisplaySetting = new GuiTabWardrobeDisplaySettings(this.tabList.size(), (GuiScreen)this, this.player, skinCapability, (IPlayerWardrobeCap)wardrobeCapability);
            this.tabList.add(this.tabDisplaySetting);
            this.tabController.addTab(new GuiTab(this.tabController, GuiHelper.getLocalizedControlName(GUI_NAME, "tab.displaySettings", new Object[0])).setIconLocation(208, 0).setTabTextureSize(26, 30).setPadding(0, 4, 3, 3).setVisable(!this.isPlayer | this.isPlayer & (ConfigHandler.wardrobeTabDisplaySettings | isCreative)));
        } else {
            this.tabDisplaySetting = null;
        }
        this.tabColourSettings = new GuiTabWardrobeColourSettings(this.tabList.size(), (GuiScreen)this, this.player, skinCapability, wardrobeCapability);
        this.tabList.add(this.tabColourSettings);
        this.tabController.addTab(new GuiTab(this.tabController, GuiHelper.getLocalizedControlName(GUI_NAME, "tab.colourSettings", new Object[0])).setIconLocation(224, 0).setTabTextureSize(26, 30).setPadding(0, 4, 3, 3).setVisable(!this.isPlayer | this.isPlayer & (ConfigHandler.wardrobeTabColourSettings | isCreative)));
        this.tabDyes = new GuiTabWardrobeDyes(this.tabList.size(), (GuiScreen)this, this.player, skinCapability, wardrobeCapability);
        this.tabList.add(this.tabDyes);
        this.tabController.addTab(new GuiTab(this.tabController, GuiHelper.getLocalizedControlName(GUI_NAME, "tab.dyes", new Object[0])).setIconLocation(240, 0).setTabTextureSize(26, 30).setPadding(0, 4, 3, 3).setVisable(!this.isPlayer | this.isPlayer & (ConfigHandler.wardrobeTabDyes | isCreative)));
        Contributors.Contributor contributor = Contributors.INSTANCE.getContributor(this.player.func_146103_bH());
        this.tabContributor = new GuiTabWardrobeContributor(this.tabList.size(), (GuiScreen)this);
        this.tabList.add(this.tabContributor);
        this.tabController.addTab(new GuiTab(this.tabController, GuiHelper.getLocalizedControlName(GUI_NAME, "tab.contributor", new Object[0])).setIconLocation(32, 128).setTabTextureSize(26, 30).setPadding(0, 4, 3, 3).setVisable(this.isPlayer & contributor != null));
        if (this.isMannequin) {
            EntityMannequin entityMannequin = (EntityMannequin)skinCapability.getEntity();
            this.tabController.setTabsPerSide(4);
            this.tabManRotations = new GuiTabWardrobeManRotations(this.tabList.size(), (GuiScreen)this, entityMannequin);
            this.tabList.add(this.tabManRotations);
            GuiTab tabListItemManRotations = new GuiTab(this.tabController, GuiHelper.getLocalizedControlName(GUI_NAME, "tab.man_rotations", new Object[0]));
            tabListItemManRotations.setIconLocation(80, 0);
            tabListItemManRotations.setAnimation(8, 150);
            tabListItemManRotations.setVisable(this.isMannequin);
            tabListItemManRotations.setPadding(0, 0, 3, 3);
            this.tabController.addTab(tabListItemManRotations);
            this.tabManTextureData = new GuiTabWardrobeManTextureData(this.tabList.size(), (GuiScreen)this, entityMannequin);
            this.tabList.add(this.tabManTextureData);
            GuiTab tabListItemManTextureData = new GuiTab(this.tabController, GuiHelper.getLocalizedControlName(GUI_NAME, "tab.man_texture", new Object[0]));
            tabListItemManTextureData.setIconLocation(128, 0);
            tabListItemManTextureData.setAnimation(8, 150);
            tabListItemManTextureData.setVisable(this.isMannequin);
            tabListItemManTextureData.setPadding(0, 0, 3, 3);
            this.tabController.addTab(tabListItemManTextureData);
            this.tabManExtras = new GuiTabWardrobeManExtras(this.tabList.size(), (GuiScreen)this, entityMannequin);
            this.tabList.add(this.tabManExtras);
            GuiTab tabListItemManExtras = new GuiTab(this.tabController, GuiHelper.getLocalizedControlName(GUI_NAME, "tab.man_extras", new Object[0]));
            tabListItemManExtras.setIconLocation(144, 0);
            tabListItemManExtras.setAnimation(8, 150);
            tabListItemManExtras.setVisable(this.isMannequin);
            tabListItemManExtras.setPadding(0, 0, 3, 3);
            this.tabController.addTab(tabListItemManExtras);
            this.tabManOffset = new GuiTabWardrobeManOffset(this.tabList.size(), (GuiScreen)this, entityMannequin);
            this.tabList.add(this.tabManOffset);
            GuiTab tabListItemManOffset = new GuiTab(this.tabController, GuiHelper.getLocalizedControlName(GUI_NAME, "tab.man_offsets", new Object[0]));
            tabListItemManOffset.setIconLocation(96, 0);
            tabListItemManOffset.setAnimation(8, 150);
            tabListItemManOffset.setVisable(this.isMannequin);
            tabListItemManOffset.setPadding(0, 0, 3, 3);
            this.tabController.addTab(tabListItemManOffset);
        } else {
            this.tabManRotations = null;
            this.tabManTextureData = null;
            this.tabManExtras = null;
            this.tabManOffset = null;
        }
        this.tabController.setActiveTabIndex(this.getActiveTab());
        this.tabChanged();
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.tabController.initGui(this.getGuiLeft() - 17, this.field_147009_r, this.field_146999_f + 42, this.field_147000_g);
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (int i = 0; i < this.tabList.size(); ++i) {
            GuiTabPanel tab = (GuiTabPanel)((Object)this.tabList.get(i));
            if (tab.getTabId() != this.getActiveTab()) continue;
            tab.update();
        }
    }

    @Override
    protected int getActiveTab() {
        return activeTab;
    }

    @Override
    protected void setActiveTab(int value) {
        activeTab = value;
    }

    @Override
    public ContainerSkinWardrobe getContainer() {
        return (ContainerSkinWardrobe)this.field_147002_h;
    }

    private void setSlotVisibilityPlayerInv(boolean visible) {
        this.setSlotVisibility(this.getContainer().getPlayerInvStartIndex(), this.getContainer().getPlayerInvEndIndex(), visible);
    }

    private void setSlotVisibilitySkins(boolean visible) {
        this.setSlotVisibility(this.getContainer().getIndexSkinsStart(), this.getContainer().getIndexSkinsEnd(), visible);
    }

    private void setSlotVisibilityMannequinHands(boolean visible) {
        this.setSlotVisibility(this.getContainer().getIndexMannequinHandsStart(), this.getContainer().getIndexMannequinHandsEnd(), visible);
    }

    private void setSlotVisibilityDyes(boolean visible) {
        this.setSlotVisibility(this.getContainer().getIndexDyeStart(), this.getContainer().getIndexDyeEnd(), visible);
    }

    private void setSlotVisibilityOutfits(boolean visible) {
        this.setSlotVisibility(this.getContainer().getIndexOutfitStart(), this.getContainer().getIndexOutfitEnd(), visible);
    }

    private void setSlotVisibility(int start, int end, boolean visible) {
        for (int i = start; i < end; ++i) {
            Object slot = this.field_147002_h.field_75151_b.get(i);
            if (slot == null || !(slot instanceof SlotHidable)) continue;
            ((SlotHidable)((Object)slot)).setVisible(visible);
        }
    }

    private boolean tabNeedsPlayerSlots(int tabId) {
        return tabId == this.tabSkins.getTabId() | tabId == this.tabOutfits.getTabId() | tabId == this.tabDyes.getTabId();
    }

    @Override
    protected void tabChanged() {
        super.tabChanged();
        this.setSlotVisibilityPlayerInv(this.tabNeedsPlayerSlots(this.getActiveTab()));
        this.setSlotVisibilitySkins(this.getActiveTab() == this.tabSkins.getTabId());
        this.setSlotVisibilityMannequinHands(this.getActiveTab() == this.tabSkins.getTabId());
        this.setSlotVisibilityDyes(this.getActiveTab() == this.tabDyes.getTabId());
        this.setSlotVisibilityOutfits(this.getActiveTab() == this.tabOutfits.getTabId());
    }

    protected void func_146976_a(float partialTickTime, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE_1);
        this.func_73729_b(this.getGuiLeft(), this.getGuiTop(), 0, 0, 256, 151);
        this.field_146297_k.field_71446_o.func_110577_a(TEXTURE_2);
        this.func_73729_b(this.getGuiLeft() + 256, this.getGuiTop(), 0, 0, 22, 151);
        for (int i = 0; i < this.tabList.size(); ++i) {
            GuiTabPanel tab = (GuiTabPanel)((Object)this.tabList.get(i));
            if (tab.getTabId() != this.getActiveTab()) continue;
            tab.drawBackgroundLayer(partialTickTime, mouseX, mouseY);
        }
        if (this.tabNeedsPlayerSlots(this.getActiveTab())) {
            GuiHelper.renderPlayerInvTexture(this.getGuiLeft() + 51, this.getGuiTop() + 152);
        }
        if (this.rotatingPlayer) {
            this.playerRotation += (float)(mouseX - this.lastMouseX);
            if (this.playerRotation < 0.0f) {
                this.playerRotation += 360.0f;
            }
            if (this.playerRotation > 360.0f) {
                this.playerRotation -= 360.0f;
            }
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        GuiHelper.renderLocalizedGuiName(this.field_146289_q, this.field_146999_f, GUI_NAME, this.guiStyle.getColour("text"));
        for (int i = 0; i < this.tabList.size(); ++i) {
            GuiTabPanel tab = (GuiTabPanel)((Object)this.tabList.get(i));
            if (tab.getTabId() != this.getActiveTab()) continue;
            tab.drawForegroundLayer(mouseX, mouseY, 0.0f);
        }
        if (this.tabNeedsPlayerSlots(this.getActiveTab())) {
            GuiHelper.renderPlayerInvlabel(51, 152, this.field_146289_q, this.guiStyle.getColour("text"));
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(-this.field_147003_i), (float)(-this.field_147009_r), (float)0.0f);
        this.tabController.drawHoverText(this.field_146297_k, mouseX, mouseY);
        GL11.glPopMatrix();
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        if (button == 1) {
            this.rotatingPlayer = true;
        }
        super.func_73864_a(mouseX, mouseY, button);
    }

    @Override
    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (state == 1) {
            this.rotatingPlayer = false;
        }
    }

    public void drawPlayerPreview(int x, int y, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawPlayerPreview(x, y, mouseX, mouseY, false);
    }

    public Color drawPlayerPreview(int x, int y, int mouseX, int mouseY, boolean selectingColour) {
        Color colour = new Color(255, 255, 255);
        float boxX = (float)x + 42.5f;
        float boxY = (float)y + 125.0f;
        float lookX = boxX - (float)mouseX;
        float lookY = boxY - 50.0f - (float)mouseY;
        boolean overPlayerBox = false;
        if (mouseX >= x + 8 & mouseX < x + 8 + 71 && mouseY >= y + 27 & mouseY < y + 27 + 111) {
            overPlayerBox = true;
        }
        if (!overPlayerBox) {
            ModRenderHelper.enableScissor(x + 8, y + 27, 71, 111, true);
        }
        if (this.skinCapability.getEntity() instanceof EntityLivingBase) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179123_a();
            GL11.glTranslatef((float)boxX, (float)boxY, (float)50.0f);
            GL11.glRotatef((float)-20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)this.playerRotation, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-50.0f);
            if (selectingColour) {
                this.renderEntityWithoutLighting(0, 0, 45, 0.0f, 0.0f, (EntityLivingBase)this.skinCapability.getEntity());
                colour = this.getColourAtPos(Mouse.getX(), Mouse.getY());
            }
            GuiInventory.func_147046_a((int)0, (int)0, (int)45, (float)0.0f, (float)0.0f, (EntityLivingBase)((EntityLivingBase)this.skinCapability.getEntity()));
            GlStateManager.func_179099_b();
            GlStateManager.func_179121_F();
            GlStateManager.func_179147_l();
        } else {
            GlStateManager.func_179123_a();
            GlStateManager.func_179142_g();
            GlStateManager.func_179094_E();
            GL11.glTranslatef((float)boxX, (float)boxY, (float)50.0f);
            GL11.glRotatef((float)-20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)this.playerRotation, (float)0.0f, (float)1.0f, (float)0.0f);
            if (this.isMannequin) {
                EntityMannequin mannequin = (EntityMannequin)this.skinCapability.getEntity();
                float rot = mannequin.getRotation();
                GL11.glRotatef((float)rot, (float)0.0f, (float)1.0f, (float)0.0f);
                float manScale = mannequin.getScale();
                GL11.glScalef((float)(1.0f / manScale), (float)(1.0f / manScale), (float)(1.0f / manScale));
            }
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-50.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)50.0f);
            GlStateManager.func_179152_a((float)-45.0f, (float)45.0f, (float)45.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
            rendermanager.func_178631_a(180.0f);
            rendermanager.func_178633_a(false);
            rendermanager.func_188391_a(this.skinCapability.getEntity(), 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
            rendermanager.func_178633_a(true);
            GlStateManager.func_179121_F();
            RenderHelper.func_74518_a();
            GlStateManager.func_179101_C();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
            GlStateManager.func_179090_x();
            GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
            GlStateManager.func_179099_b();
            GlStateManager.func_179147_l();
            if (selectingColour) {
                colour = this.getColourAtPos(Mouse.getX(), Mouse.getY());
            }
        }
        if (!overPlayerBox) {
            ModRenderHelper.disableScissor();
        }
        return colour;
    }

    private void renderEntityWithoutLighting(int posX, int posY, int scale, float mouseX, float mouseY, EntityLivingBase ent) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = ent.field_70761_aq;
        float f1 = ent.field_70177_z;
        float f2 = ent.field_70125_A;
        float f3 = ent.field_70758_at;
        float f4 = ent.field_70759_as;
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74518_a();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(mouseY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        ent.field_70761_aq = (float)Math.atan(mouseX / 40.0f) * 20.0f;
        ent.field_70177_z = (float)Math.atan(mouseX / 40.0f) * 40.0f;
        ent.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        ent.field_70761_aq = f;
        ent.field_70177_z = f1;
        ent.field_70125_A = f2;
        ent.field_70758_at = f3;
        ent.field_70759_as = f4;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    private Color getColourAtPos(int x, int y) {
        FloatBuffer buffer = BufferUtils.createFloatBuffer((int)3);
        GL11.glReadPixels((int)x, (int)y, (int)1, (int)1, (int)6407, (int)5126, (FloatBuffer)buffer);
        GL11.glFinish();
        int r = Math.round(buffer.get() * 255.0f);
        int g = Math.round(buffer.get() * 255.0f);
        int b = Math.round(buffer.get() * 255.0f);
        return new Color(r, g, b);
    }

    @Override
    public String getName() {
        return GUI_NAME;
    }
}

