/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.render;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.client.config.ConfigHandlerClient;
import moe.plushie.armourers_workshop.client.handler.ModClientFMLEventHandler;
import moe.plushie.armourers_workshop.client.model.SkinModel;
import moe.plushie.armourers_workshop.client.model.bake.ColouredFace;
import moe.plushie.armourers_workshop.client.render.IRenderBuffer;
import moe.plushie.armourers_workshop.client.render.ModRenderHelper;
import moe.plushie.armourers_workshop.client.render.RenderBridge;
import moe.plushie.armourers_workshop.client.render.SkinPartRenderData;
import moe.plushie.armourers_workshop.client.skin.ClientSkinPartData;
import moe.plushie.armourers_workshop.common.painting.PaintingHelper;
import moe.plushie.armourers_workshop.proxies.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class SkinPartRenderer
extends ModelBase {
    private static final ResourceLocation texture = new ResourceLocation("armourers_workshop".toLowerCase(), "textures/armour/cube.png");
    public static final SkinPartRenderer INSTANCE = new SkinPartRenderer();
    private final Minecraft mc = Minecraft.func_71410_x();

    public void renderPart(SkinPartRenderData renderData) {
        ++ModClientFMLEventHandler.skinRendersThisTick;
        ClientSkinPartData cspd = renderData.getSkinPart().getClientSkinPartData();
        SkinModel skinModel = cspd.getModelForDye(renderData);
        boolean multipassSkinRendering = ClientProxy.useMultipassSkinRendering();
        for (int i = 0; i < skinModel.displayList.length; ++i) {
            if (!skinModel.haveList[i] || skinModel.displayList[i].isCompiled()) continue;
            skinModel.displayList[i].begin();
            this.renderVertexList(cspd.vertexLists[i], renderData, cspd);
            skinModel.displayList[i].end();
            skinModel.setLoaded();
        }
        this.mc.field_71446_o.func_110577_a(texture);
        int startIndex = 0;
        int endIndex = 0;
        int loadingLod = skinModel.getLoadingLod();
        int lod = renderData.getLod();
        if (!renderData.isDoLodLoading()) {
            loadingLod = 0;
        }
        if (loadingLod > lod) {
            lod = loadingLod;
        }
        if (lod != 0) {
            startIndex = multipassSkinRendering ? lod * 4 : lod * 2;
        }
        endIndex = multipassSkinRendering ? startIndex + 4 : startIndex + 2;
        GlStateManager.func_179123_a();
        GL11.glEnable((int)2884);
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179094_E();
        double f = PaintingHelper.getPaintTextureOffset();
        GlStateManager.func_179137_b((double)0.0, (double)(f / 256.0), (double)0.0);
        int listCount = skinModel.displayList.length;
        for (int i = startIndex; i < endIndex; ++i) {
            if (!(i >= startIndex & i < endIndex)) continue;
            boolean glowing = false;
            if (i % 2 == 1) {
                glowing = true;
            }
            if (!(i >= 0 & i < skinModel.displayList.length) || !skinModel.haveList[i] || !skinModel.displayList[i].isCompiled()) continue;
            if (glowing) {
                GlStateManager.func_179123_a();
                GlStateManager.func_179140_f();
                ModRenderHelper.disableLighting();
            }
            if (ConfigHandlerClient.wireframeRender) {
                GL11.glPolygonMode((int)1032, (int)6913);
                GL11.glLineWidth((float)1.0f);
            }
            skinModel.displayList[i].render();
            if (ConfigHandlerClient.wireframeRender) {
                GL11.glPolygonMode((int)1032, (int)6914);
            }
            if (!glowing) continue;
            ModRenderHelper.enableLighting();
            GlStateManager.func_179145_e();
            GlStateManager.func_179099_b();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179117_G();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179099_b();
    }

    private void renderVertexList(ArrayList<ColouredFace> vertexList, SkinPartRenderData renderData, ClientSkinPartData cspd) {
        IRenderBuffer renderBuffer = RenderBridge.INSTANCE;
        renderBuffer.startDrawingQuads(DefaultVertexFormats.field_181712_l);
        for (int i = 0; i < vertexList.size(); ++i) {
            ColouredFace cVert = vertexList.get(i);
            cVert.renderVertex(renderBuffer, renderData, cspd);
        }
        renderBuffer.draw();
    }
}

