/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.init.items;

import moe.plushie.armourers_workshop.common.init.blocks.BlockSkinnable;
import moe.plushie.armourers_workshop.common.init.items.AbstractModItem;
import moe.plushie.armourers_workshop.common.tileentities.TileEntitySkinnable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemLinkingTool
extends AbstractModItem {
    private static final String TAG_LINK_LOCATION = "linkLocation";

    public ItemLinkingTool() {
        super("linking-tool");
        this.setSortPriority(7);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (!world.field_72995_K) {
            TileEntity te;
            ItemStack stack = player.func_184586_b(hand);
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (!this.hasLinkLocation(stack)) {
                if (!(block instanceof BlockSkinnable)) {
                    this.setLinkLocation(stack, new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.armourers_workshop:linkingTool.start", new Object[]{null}));
                    return EnumActionResult.SUCCESS;
                }
                player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.armourers_workshop:linkingTool.linkedToSkinnable", new Object[]{null}));
                return EnumActionResult.FAIL;
            }
            BlockPos loc = this.getLinkLocation(stack);
            if (block instanceof BlockSkinnable && (te = world.func_175625_s(pos)) != null && te instanceof TileEntitySkinnable) {
                ((TileEntitySkinnable)te).getParent().setLinkedBlock(loc);
                player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.armourers_workshop:linkingTool.finish", new Object[]{null}));
                this.removeLinkLocation(stack);
                return EnumActionResult.SUCCESS;
            }
            this.removeLinkLocation(stack);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("chat.armourers_workshop:linkingTool.fail", new Object[]{null}));
        }
        return EnumActionResult.PASS;
    }

    private void setLinkLocation(ItemStack stack, BlockPos loc) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74783_a(TAG_LINK_LOCATION, new int[]{loc.func_177958_n(), loc.func_177956_o(), loc.func_177952_p()});
    }

    private void removeLinkLocation(ItemStack stack) {
        if (stack.func_77942_o()) {
            stack.func_77978_p().func_82580_o(TAG_LINK_LOCATION);
        }
    }

    private boolean hasLinkLocation(ItemStack stack) {
        if (stack.func_77942_o()) {
            return stack.func_77978_p().func_150297_b(TAG_LINK_LOCATION, 11);
        }
        return false;
    }

    private BlockPos getLinkLocation(ItemStack stack) {
        if (this.hasLinkLocation(stack)) {
            int[] loc = stack.func_77978_p().func_74759_k(TAG_LINK_LOCATION);
            return new BlockPos(loc[0], loc[1], loc[2]);
        }
        return new BlockPos(0, 0, 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                if (!ItemLinkingTool.this.hasLinkLocation(stack)) {
                    return new ModelResourceLocation(new ResourceLocation("armourers_workshop", ItemLinkingTool.this.func_77658_a()), "normal");
                }
                return new ModelResourceLocation(new ResourceLocation("armourers_workshop", ItemLinkingTool.this.func_77658_a() + "-link"), "normal");
            }
        });
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(new ResourceLocation("armourers_workshop", this.func_77658_a()), "normal"), new ModelResourceLocation(new ResourceLocation("armourers_workshop", this.func_77658_a() + "-link"), "normal")});
    }
}

