/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.api.wrapper.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.gui.IButton;
import noppes.npcs.api.gui.ICustomGui;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.gui.IItemSlot;
import noppes.npcs.api.gui.ILabel;
import noppes.npcs.api.gui.IScroll;
import noppes.npcs.api.gui.ITextArea;
import noppes.npcs.api.gui.ITextField;
import noppes.npcs.api.gui.ITexturedRect;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.ItemScriptedWrapper;
import noppes.npcs.api.wrapper.PlayerWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiButtonWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiComponentWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiItemSlotWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiLabelWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiScrollWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiTextAreaWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiTextFieldWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiTexturedRectWrapper;
import noppes.npcs.controllers.CustomGuiController;
import noppes.npcs.controllers.ScriptContainer;

public class CustomGuiWrapper
implements ICustomGui {
    int id;
    int width;
    int height;
    int playerInvX;
    int playerInvY;
    boolean pauseGame;
    boolean showPlayerInv;
    String backgroundTexture = "";
    ScriptContainer scriptHandler;
    List<ICustomGuiComponent> components = new ArrayList<ICustomGuiComponent>();
    List<IItemSlot> slots = new ArrayList<IItemSlot>();

    public CustomGuiWrapper() {
    }

    public CustomGuiWrapper(int id, int width, int height, boolean pauseGame) {
        this.id = id;
        this.width = width;
        this.height = height;
        this.pauseGame = pauseGame;
        this.scriptHandler = ScriptContainer.Current;
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public List<ICustomGuiComponent> getComponents() {
        return this.components;
    }

    @Override
    public List<IItemSlot> getSlots() {
        return this.slots;
    }

    public ScriptContainer getScriptHandler() {
        return this.scriptHandler;
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void setDoesPauseGame(boolean pauseGame) {
        this.pauseGame = pauseGame;
    }

    public boolean getDoesPauseGame() {
        return this.pauseGame;
    }

    @Override
    public void setBackgroundTexture(String resourceLocation) {
        this.backgroundTexture = resourceLocation;
    }

    public String getBackgroundTexture() {
        return this.backgroundTexture;
    }

    @Override
    public IButton addButton(int id, String label, int x, int y) {
        CustomGuiButtonWrapper component = new CustomGuiButtonWrapper(id, label, x, y);
        this.components.add(component);
        return component;
    }

    @Override
    public IButton addButton(int id, String label, int x, int y, int width, int height) {
        CustomGuiButtonWrapper component = new CustomGuiButtonWrapper(id, label, x, y, width, height);
        this.components.add(component);
        return component;
    }

    @Override
    public IButton addTexturedButton(int id, String label, int x, int y, int width, int height, String texture) {
        CustomGuiButtonWrapper component = new CustomGuiButtonWrapper(id, label, x, y, width, height, texture);
        this.components.add(component);
        return component;
    }

    @Override
    public IButton addTexturedButton(int id, String label, int x, int y, int width, int height, String texture, int textureX, int textureY) {
        CustomGuiButtonWrapper component = new CustomGuiButtonWrapper(id, label, x, y, width, height, texture, textureX, textureY);
        this.components.add(component);
        return component;
    }

    @Override
    public ILabel addLabel(int id, String label, int x, int y, int width, int height) {
        CustomGuiLabelWrapper component = new CustomGuiLabelWrapper(id, label, x, y, width, height);
        this.components.add(component);
        return component;
    }

    @Override
    public ILabel addLabel(int id, String label, int x, int y, int width, int height, int color) {
        CustomGuiLabelWrapper component = new CustomGuiLabelWrapper(id, label, x, y, width, height, color);
        this.components.add(component);
        return component;
    }

    @Override
    public ITextField addTextField(int id, int x, int y, int width, int height) {
        CustomGuiTextFieldWrapper component = new CustomGuiTextFieldWrapper(id, x, y, width, height);
        this.components.add(component);
        return component;
    }

    @Override
    public ITextArea addTextArea(int id, int x, int y, int width, int height) {
        CustomGuiTextAreaWrapper component = new CustomGuiTextAreaWrapper(id, x, y, width, height);
        this.components.add(component);
        return component;
    }

    @Override
    public ITexturedRect addTexturedRect(int id, String texture, int x, int y, int width, int height) {
        CustomGuiTexturedRectWrapper component = new CustomGuiTexturedRectWrapper(id, texture, x, y, width, height);
        this.components.add(component);
        return component;
    }

    @Override
    public ITexturedRect addTexturedRect(int id, String texture, int x, int y, int width, int height, int textureX, int textureY) {
        CustomGuiTexturedRectWrapper component = new CustomGuiTexturedRectWrapper(id, texture, x, y, width, height, textureX, textureY);
        this.components.add(component);
        return component;
    }

    @Override
    public IItemSlot addItemSlot(int x, int y) {
        return this.addItemSlot(x, y, ItemScriptedWrapper.AIR);
    }

    @Override
    public IItemSlot addItemSlot(int x, int y, IItemStack stack) {
        CustomGuiItemSlotWrapper slot = new CustomGuiItemSlotWrapper(x, y, stack);
        this.slots.add(slot);
        return slot;
    }

    @Override
    public IScroll addScroll(int id, int x, int y, int width, int height, String[] list) {
        CustomGuiScrollWrapper component = new CustomGuiScrollWrapper(id, x, y, width, height, list);
        this.components.add(component);
        return component;
    }

    @Override
    public void showPlayerInventory(int x, int y) {
        this.showPlayerInv = true;
        this.playerInvX = x;
        this.playerInvY = y;
    }

    @Override
    public ICustomGuiComponent getComponent(int componentID) {
        for (ICustomGuiComponent component : this.components) {
            if (component.getID() != componentID) continue;
            return component;
        }
        return null;
    }

    @Override
    public void removeComponent(int componentID) {
        for (int i = 0; i < this.components.size(); ++i) {
            if (this.components.get(i).getID() != componentID) continue;
            this.components.remove(i);
            return;
        }
    }

    @Override
    public void updateComponent(ICustomGuiComponent component) {
        for (int i = 0; i < this.components.size(); ++i) {
            ICustomGuiComponent c = this.components.get(i);
            if (c.getID() != component.getID()) continue;
            this.components.set(i, component);
            return;
        }
    }

    @Override
    public void update(IPlayer player) {
        CustomGuiController.updateGui((PlayerWrapper)player, this);
    }

    public boolean getShowPlayerInv() {
        return this.showPlayerInv;
    }

    public int getPlayerInvX() {
        return this.playerInvX;
    }

    public int getPlayerInvY() {
        return this.playerInvY;
    }

    public ICustomGui fromNBT(NBTTagCompound tag) {
        this.id = tag.func_74762_e("id");
        this.width = tag.func_74759_k("size")[0];
        this.height = tag.func_74759_k("size")[1];
        this.pauseGame = tag.func_74767_n("pause");
        this.backgroundTexture = tag.func_74779_i("bgTexture");
        ArrayList<ICustomGuiComponent> components = new ArrayList<ICustomGuiComponent>();
        NBTTagList list = tag.func_150295_c("components", 10);
        for (NBTBase b : list) {
            CustomGuiComponentWrapper component = CustomGuiComponentWrapper.createFromNBT((NBTTagCompound)b);
            components.add(component);
        }
        this.components = components;
        ArrayList<IItemSlot> slots = new ArrayList<IItemSlot>();
        list = tag.func_150295_c("slots", 10);
        for (NBTBase b : list) {
            CustomGuiItemSlotWrapper component = (CustomGuiItemSlotWrapper)CustomGuiComponentWrapper.createFromNBT((NBTTagCompound)b);
            slots.add(component);
        }
        this.slots = slots;
        this.showPlayerInv = tag.func_74767_n("showPlayerInv");
        if (this.showPlayerInv) {
            this.playerInvX = tag.func_74759_k("pInvPos")[0];
            this.playerInvY = tag.func_74759_k("pInvPos")[1];
        }
        return this;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("id", this.id);
        tag.func_74783_a("size", new int[]{this.width, this.height});
        tag.func_74757_a("pause", this.pauseGame);
        tag.func_74778_a("bgTexture", this.backgroundTexture);
        NBTTagList list = new NBTTagList();
        for (ICustomGuiComponent iCustomGuiComponent : this.components) {
            list.func_74742_a((NBTBase)((CustomGuiComponentWrapper)iCustomGuiComponent).toNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("components", (NBTBase)list);
        list = new NBTTagList();
        for (ICustomGuiComponent iCustomGuiComponent : this.slots) {
            list.func_74742_a((NBTBase)((CustomGuiComponentWrapper)iCustomGuiComponent).toNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("slots", (NBTBase)list);
        tag.func_74757_a("showPlayerInv", this.showPlayerInv);
        if (this.showPlayerInv) {
            tag.func_74783_a("pInvPos", new int[]{this.playerInvX, this.playerInvY});
        }
        return tag;
    }
}

