/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.custom.components;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.api.gui.ICustomGuiComponent;
import noppes.npcs.api.wrapper.gui.CustomGuiTextAreaWrapper;
import noppes.npcs.api.wrapper.gui.CustomGuiTextFieldWrapper;
import noppes.npcs.client.gui.custom.GuiCustom;
import noppes.npcs.client.gui.custom.interfaces.IClickListener;
import noppes.npcs.client.gui.custom.interfaces.IDataHolder;
import noppes.npcs.client.gui.custom.interfaces.IKeyListener;
import noppes.npcs.client.gui.util.GuiTextArea;

public class CustomGuiTextArea
extends GuiTextArea
implements IDataHolder,
IClickListener,
IKeyListener {
    GuiCustom parent;
    String[] hoverText;

    public CustomGuiTextArea(int id, int x, int y, int width, int height) {
        super(id, GuiCustom.guiLeft + x, GuiCustom.guiTop + y, width, height, "");
    }

    @Override
    public void onRender(Minecraft mc, int mouseX, int mouseY, int mouseWheel, float partialTicks) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)this.id);
        boolean hovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
        super.drawScreen(mouseX, mouseY);
        if (hovered && this.hoverText != null && this.hoverText.length > 0) {
            this.parent.hoverText = this.hoverText;
        }
        GlStateManager.func_179121_F();
    }

    public void setParent(GuiCustom parent) {
        this.parent = parent;
    }

    @Override
    public int getID() {
        return this.id;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("id", this.id);
        tag.func_74778_a("text", this.text);
        return tag;
    }

    @Override
    public ICustomGuiComponent toComponent() {
        CustomGuiTextFieldWrapper component = new CustomGuiTextFieldWrapper(this.id, this.x - GuiCustom.guiLeft, this.y - GuiCustom.guiTop, this.width, this.height);
        component.setText(this.getText());
        component.setHoverText(this.hoverText);
        return component;
    }

    public static CustomGuiTextArea fromComponent(CustomGuiTextAreaWrapper component) {
        CustomGuiTextArea txt = new CustomGuiTextArea(component.getID(), component.getPosX(), component.getPosY(), component.getWidth(), component.getHeight());
        if (component.hasHoverText()) {
            txt.hoverText = component.getHoverText();
        }
        if (component.getText() != null && !component.getText().isEmpty()) {
            txt.text = component.getText();
        }
        txt.enabled = component.getEnabled();
        return txt;
    }

    @Override
    public boolean mouseClicked(GuiCustom gui, int mouseX, int mouseY, int mouseButton) {
        return this.mouseClicked(mouseX, mouseY, mouseButton);
    }
}

