/*
 * Decompiled with CFR 0.152.
 */
package com.driga.jmodelloader.obj.armor.manager;

import com.driga.jmodelloader.model.ModelManager;
import com.driga.jmodelloader.obj.armor.ArmorRegistry;
import com.driga.jmodelloader.obj.armor.ItemCustomArmor;
import java.util.List;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.EnumHelper;

public class CustomArmorManagerServer {
    private static final ItemArmor.ArmorMaterial DEFAULT_MATERIAL = CustomArmorManagerServer.generateArmorMaterial("jmodelloader", "default", 3.0f, 33, 1.5f, new int[]{3, 6, 8, 3}, 10, 2.0f);

    public static void registerItems() {
        List<String> models = ModelManager.getAllModels();
        for (String model : models) {
            CustomArmorManagerServer.registerAllItems(model);
        }
    }

    private static ItemArmor.ArmorMaterial generateArmorMaterial(String modid, String name, float durabilityFactor, int baseDurability, float damageFactor, int[] baseDamageability, int enchantibility, float toughness) {
        return EnumHelper.addArmorMaterial((String)(modid + ":" + name), (String)(modid + ":" + name), (int)((int)((float)baseDurability * durabilityFactor)), (int[])new int[]{(int)((float)baseDamageability[0] * damageFactor), (int)((float)baseDamageability[1] * damageFactor), (int)((float)baseDamageability[2] * damageFactor), (int)((float)baseDamageability[3] * damageFactor)}, (int)enchantibility, (SoundEvent)SoundEvents.field_187725_r, (float)toughness);
    }

    private static void registerAllItems(String model) {
        ItemCustomArmor MODEL_HEAD = new ItemCustomArmor(model, DEFAULT_MATERIAL, 1, EntityEquipmentSlot.HEAD);
        ItemCustomArmor MODEL_CHESTPLATE = new ItemCustomArmor(model, DEFAULT_MATERIAL, 1, EntityEquipmentSlot.CHEST);
        ItemCustomArmor MODEL_LEGGINS = new ItemCustomArmor(model, DEFAULT_MATERIAL, 2, EntityEquipmentSlot.LEGS);
        ItemCustomArmor MODEL_BOOTS = new ItemCustomArmor(model, DEFAULT_MATERIAL, 1, EntityEquipmentSlot.FEET);
        ArmorRegistry.Instance.registerNewArmor(model + "_head", MODEL_HEAD);
        ArmorRegistry.Instance.registerNewArmor(model + "_chest", MODEL_CHESTPLATE);
        ArmorRegistry.Instance.registerNewArmor(model + "_legs", MODEL_LEGGINS);
        ArmorRegistry.Instance.registerNewArmor(model + "_boots", MODEL_BOOTS);
    }
}

