/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.globallibrary.panels;

import com.google.common.util.concurrent.FutureCallback;
import com.google.gson.JsonObject;
import java.io.File;
import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.controls.AbstractGuiDialog;
import moe.plushie.armourers_workshop.client.gui.controls.GuiControlStarRating;
import moe.plushie.armourers_workshop.client.gui.controls.GuiPanel;
import moe.plushie.armourers_workshop.client.gui.controls.IDialogCallback;
import moe.plushie.armourers_workshop.client.gui.globallibrary.GuiGlobalLibrary;
import moe.plushie.armourers_workshop.client.gui.globallibrary.dialog.GuiGlobalLibraryDialogReportSkin;
import moe.plushie.armourers_workshop.client.render.ModRenderHelper;
import moe.plushie.armourers_workshop.client.render.SkinItemRenderHelper;
import moe.plushie.armourers_workshop.client.skin.cache.ClientSkinCache;
import moe.plushie.armourers_workshop.common.library.ILibraryManager;
import moe.plushie.armourers_workshop.common.library.global.GlobalSkinLibraryUtils;
import moe.plushie.armourers_workshop.common.library.global.PlushieUser;
import moe.plushie.armourers_workshop.common.library.global.SkinDownloader;
import moe.plushie.armourers_workshop.common.library.global.auth.PlushieAuth;
import moe.plushie.armourers_workshop.common.library.global.permission.PermissionSystem;
import moe.plushie.armourers_workshop.common.library.global.task.GlobalTaskGetSkinInfo;
import moe.plushie.armourers_workshop.common.library.global.task.GlobalTaskResult;
import moe.plushie.armourers_workshop.common.library.global.task.user.GlobalTaskSkinReport;
import moe.plushie.armourers_workshop.common.library.global.task.user.GlobalTaskUserSkinRate;
import moe.plushie.armourers_workshop.common.library.global.task.user.GlobalTaskUserSkinRating;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinDescriptor;
import moe.plushie.armourers_workshop.common.skin.data.SkinIdentifier;
import moe.plushie.armourers_workshop.utils.ModLogger;
import moe.plushie.armourers_workshop.utils.SkinIOUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiGlobalLibraryPanelSkinInfo
extends GuiPanel
implements IDialogCallback {
    private static final ResourceLocation BUTTON_TEXTURES = new ResourceLocation("armourers_workshop:textures/gui/global_library/global-library.png");
    private GuiButtonExt buttonBack;
    private GuiButtonExt buttonDownload;
    private GuiButtonExt buttonUserSkins;
    private GuiButtonExt buttonEditSkin;
    private GuiButtonExt buttonReportSkin;
    private GuiControlStarRating starRating;
    private final String guiName;
    private JsonObject skinJson = null;
    private GuiGlobalLibrary.Screen returnScreen;
    private boolean doneRatingCheck = false;
    private int rating = 0;

    public GuiGlobalLibraryPanelSkinInfo(GuiScreen parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
        this.guiName = ((GuiGlobalLibrary)parent).getGuiName() + ".skinInfo";
    }

    @Override
    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        int panelCenter = this.x + this.width / 2;
        this.buttonBack = new GuiButtonExt(0, 2, this.y + this.height - 18, 80, 16, GuiHelper.getLocalizedControlName(this.guiName, "back", new Object[0]));
        this.buttonDownload = new GuiButtonExt(0, this.x + 185 + 6, this.y + this.height - 38, 80, 16, GuiHelper.getLocalizedControlName(this.guiName, "downloadSkin", new Object[0]));
        this.buttonUserSkins = new GuiButtonExt(0, this.x + 3, this.y + 3, 26, 26, "");
        this.buttonEditSkin = new GuiButtonExt(0, this.x + this.width - 82, this.y + this.height - 18, 80, 16, GuiHelper.getLocalizedControlName(this.guiName, "editSkin", new Object[0]));
        this.buttonReportSkin = new GuiButtonExt(0, this.x + this.width - 82 - 2, this.y + this.height - 38, 80, 16, GuiHelper.getLocalizedControlName(this.guiName, "button.report_skin", new Object[0]));
        this.starRating = new GuiControlStarRating(this.x + 191, this.y + 4);
        this.updateLikeButtons();
        this.buttonList.add(this.buttonBack);
        this.buttonList.add(this.buttonDownload);
        this.buttonList.add(this.buttonUserSkins);
        this.buttonList.add(this.buttonEditSkin);
        this.buttonList.add(this.buttonReportSkin);
        this.buttonList.add(this.starRating);
    }

    @Override
    public void update() {
        this.buttonEditSkin.field_146125_m = false;
        this.buttonEditSkin.field_146125_m = this.isOwner() ? PlushieAuth.PLUSHIE_SESSION.hasPermission(PermissionSystem.PlushieAction.SKIN_OWNER_EDIT) : PlushieAuth.PLUSHIE_SESSION.hasPermission(PermissionSystem.PlushieAction.SKIN_MOD_EDIT);
        this.buttonDownload.field_146125_m = PlushieAuth.PLUSHIE_SESSION.hasPermission(PermissionSystem.PlushieAction.SKIN_DOWNLOAD);
    }

    private boolean isOwner() {
        if (this.skinJson != null && this.skinJson.has("user_id")) {
            return PlushieAuth.PLUSHIE_SESSION.isOwner(this.skinJson.get("user_id").getAsInt());
        }
        return false;
    }

    private void updateLikeButtons() {
        this.starRating.field_146125_m = false;
        if (this.doneRatingCheck) {
            this.starRating.setRating(this.rating);
            this.starRating.field_146125_m = true;
        }
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        int userId;
        PlushieUser plushieUser;
        if (button == this.buttonBack) {
            ((GuiGlobalLibrary)this.parent).switchScreen(this.returnScreen);
        }
        if (button == this.buttonDownload && this.skinJson != null) {
            this.buttonDownload.field_146124_l = false;
            new DownloadSkin(this.skinJson);
        }
        if (button == this.buttonUserSkins && this.skinJson != null && this.skinJson.has("user_id") && (plushieUser = GlobalSkinLibraryUtils.getUserInfo(userId = this.skinJson.get("user_id").getAsInt())) != null) {
            ((GuiGlobalLibrary)this.parent).panelUserSkins.clearResults();
            ((GuiGlobalLibrary)this.parent).switchScreen(GuiGlobalLibrary.Screen.USER_SKINS);
            ((GuiGlobalLibrary)this.parent).panelUserSkins.switchToUser(userId);
        }
        if (button == this.buttonEditSkin && this.skinJson != null) {
            ((GuiGlobalLibrary)this.parent).panelSkinEdit.displaySkinInfo(this.skinJson, this.returnScreen);
        }
        if (button == this.starRating) {
            if (this.starRating.getRating() == this.rating) {
                this.setSkinRating(0);
            } else {
                this.setSkinRating(this.starRating.getRating());
            }
        }
        if (button == this.buttonReportSkin) {
            int skinId = this.skinJson.get("id").getAsInt();
            ((GuiGlobalLibrary)this.parent).openDialog(new GuiGlobalLibraryDialogReportSkin(this.parent, this.guiName + ".dialog.report_skin", this, 240, 200, skinId));
        }
    }

    public void displaySkinInfo(JsonObject jsonObject, GuiGlobalLibrary.Screen returnScreen) {
        this.skinJson = jsonObject;
        ((GuiGlobalLibrary)this.parent).switchScreen(GuiGlobalLibrary.Screen.SKIN_INFO);
        ((GuiGlobalLibrary)this.parent).panelSkinEdit.setModerator(!this.isOwner());
        this.returnScreen = returnScreen;
        this.doneRatingCheck = false;
        if (PlushieAuth.isRemoteUser() & this.skinJson != null) {
            this.checkIfLiked();
        }
    }

    private void checkIfLiked() {
        int skinId = this.skinJson.get("id").getAsInt();
        new GlobalTaskUserSkinRating(skinId).createTaskAndRun(new FutureCallback<GlobalTaskUserSkinRating.UserSkinRatingResult>(){

            public void onSuccess(final GlobalTaskUserSkinRating.UserSkinRatingResult result) {
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        if (result.getResult() == GlobalTaskResult.SUCCESS) {
                            GuiGlobalLibraryPanelSkinInfo.this.rating = result.getRating();
                            GuiGlobalLibraryPanelSkinInfo.this.doneRatingCheck = true;
                            GuiGlobalLibraryPanelSkinInfo.this.updateLikeButtons();
                        } else {
                            ModLogger.log(Level.WARN, result.getMessage());
                        }
                    }
                });
            }

            public void onFailure(Throwable t) {
                t.printStackTrace();
            }
        });
    }

    private void setSkinRating(int rating) {
        int skinId = this.skinJson.get("id").getAsInt();
        this.rating = rating;
        new GlobalTaskUserSkinRate(skinId, rating).createTaskAndRun(new FutureCallback<GlobalTaskUserSkinRate.UserSkinRateResult>(){

            public void onSuccess(final GlobalTaskUserSkinRate.UserSkinRateResult result) {
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        if (result.getResult() == GlobalTaskResult.SUCCESS) {
                            GuiGlobalLibraryPanelSkinInfo.this.updateLikeButtons();
                            if (GuiGlobalLibraryPanelSkinInfo.this.skinJson != null) {
                                GuiGlobalLibraryPanelSkinInfo.this.skinJson.addProperty("rating", (Number)Float.valueOf(result.getNewRating()));
                            }
                        } else {
                            ModLogger.log(Level.WARN, result.getMessage());
                        }
                    }
                });
            }

            public void onFailure(Throwable t) {
                t.printStackTrace();
            }
        });
    }

    private void updateSkinJson() {
        int skinId = this.skinJson.get("id").getAsInt();
        new GlobalTaskGetSkinInfo(skinId).createTaskAndRun(new FutureCallback<JsonObject>(){

            public void onSuccess(final JsonObject result) {
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        if (result != null) {
                            GuiGlobalLibraryPanelSkinInfo.this.skinJson = result;
                        }
                    }
                });
            }

            public void onFailure(Throwable t) {
                t.printStackTrace();
            }
        });
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTickTime) {
        if (!this.visible) {
            return;
        }
        PlushieUser user = null;
        if (this.skinJson != null && this.skinJson.has("user_id")) {
            int userId = this.skinJson.get("user_id").getAsInt();
            user = GlobalSkinLibraryUtils.getUserInfo(userId);
        }
        this.func_73733_a(this.x, this.y, this.x + this.width, this.y + this.height, -1072689136, -804253680);
        Skin skin = null;
        SkinIdentifier identifier = new SkinIdentifier(0, null, this.skinJson.get("id").getAsInt(), null);
        if (this.skinJson != null && this.skinJson.has("id")) {
            skin = ClientSkinCache.INSTANCE.getSkin(identifier);
        }
        super.draw(mouseX, mouseY, partialTickTime);
        this.drawUserbox(this.x + 2, this.y + 2, 185, 30, mouseX, mouseY, partialTickTime);
        this.drawSkinInfo(skin, this.x + 2, this.y + 30 + 4, 185, this.height - 54, mouseX, mouseY, partialTickTime);
        this.drawPreviewBox(identifier, skin, this.x + 189, this.y + 2, this.width - 189 - 2, this.height - 22, mouseX, mouseY, partialTickTime);
    }

    public void drawUserbox(int boxX, int boxY, int boxWidth, int boxHeight, int mouseX, int mouseY, float partialTickTime) {
        this.func_73733_a(boxX, boxY, boxX + boxWidth, boxY + boxHeight, 0x22888888, 0x22CCCCCC);
        String fullName = "inventory." + "armourers_workshop".toLowerCase() + ":" + this.guiName + ".";
        PlushieUser user = null;
        if (this.skinJson != null && this.skinJson.has("user_id")) {
            int userId = this.skinJson.get("user_id").getAsInt();
            user = GlobalSkinLibraryUtils.getUserInfo(userId);
        }
        if (user != null) {
            this.func_73731_b(this.fontRenderer, I18n.func_135052_a((String)(fullName + "uploader"), (Object[])new Object[]{user.getUsername()}), boxX + 29, boxY + boxHeight - 12, -1118482);
            GuiHelper.drawPlayerHead(boxX + 5, boxY + 5, 16, user.getUsername());
        } else {
            GuiHelper.drawPlayerHead(boxX + 5, boxY + 5, 16, null);
        }
    }

    public void drawSkinInfo(Skin skin, int boxX, int boxY, int boxWidth, int boxHeight, int mouseX, int mouseY, float partialTickTime) {
        this.func_73733_a(boxX, boxY, boxX + boxWidth, boxY + boxHeight, 0x22888888, 0x22CCCCCC);
        ModRenderHelper.enableScissor(boxX, boxY, boxWidth, boxHeight, true);
        String fullName = "inventory." + "armourers_workshop".toLowerCase() + ":" + this.guiName + ".";
        String info = "";
        info = info + GuiHelper.getLocalizedControlName(this.guiName, "title", new Object[0]) + "\n\n";
        if (this.skinJson != null) {
            info = info + GuiHelper.getLocalizedControlName(this.guiName, "name", new Object[0]) + " ";
            info = info + this.skinJson.get("name").getAsString() + "\n\n";
            int yOffset = 100;
            if (this.skinJson.has("downloads")) {
                info = info + I18n.func_135052_a((String)(fullName + "downloads"), (Object[])new Object[]{this.skinJson.get("downloads").getAsInt()}) + "\n\n";
            }
            if (this.skinJson.has("rating") & this.skinJson.has("rating_count")) {
                float rating = this.skinJson.get("rating").getAsFloat();
                int ratingCount = this.skinJson.get("rating_count").getAsInt();
                info = info + "Rating: (" + ratingCount + ") " + rating + "/10 \n\n";
            }
            if (skin != null) {
                info = info + GuiHelper.getLocalizedControlName(this.guiName, "author", new Object[0]) + " ";
                info = info + skin.getAuthorName() + "\n\n";
            }
            info = info + "Global ID: " + this.skinJson.get("id").getAsInt() + "\n\n";
            if (this.skinJson.has("description")) {
                info = info + GuiHelper.getLocalizedControlName(this.guiName, "description", new Object[0]) + " ";
                info = info + this.skinJson.get("description").getAsString();
            }
        }
        this.fontRenderer.func_78279_b(info, boxX + 2, boxY + 2, boxWidth - 4, -1118482);
        this.mc.field_71446_o.func_110577_a(BUTTON_TEXTURES);
        ModRenderHelper.disableScissor();
    }

    public void drawPreviewBox(SkinIdentifier identifier, Skin skin, int boxX, int boxY, int boxWidth, int boxHeight, int mouseX, int mouseY, float partialTickTime) {
        this.func_73733_a(boxX, boxY, boxX + boxWidth, boxY + boxHeight, 0x22888888, 0x22CCCCCC);
        if (skin != null) {
            int iconSize = Math.min(boxWidth, boxHeight);
            ScaledResolution scaledResolution = new ScaledResolution(this.mc);
            float scale = 10 - scaledResolution.func_78325_e();
            GlStateManager.func_179094_E();
            GlStateManager.func_179123_a();
            GlStateManager.func_179109_b((float)(boxX + boxWidth / 2), (float)(boxY + boxHeight / 2), (float)500.0f);
            GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            float rotation = (float)((double)System.currentTimeMillis() / 10.0 % 360.0);
            GL11.glRotatef((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            RenderHelper.func_74520_c();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179133_A();
            GlStateManager.func_179119_h();
            GlStateManager.func_179108_z();
            GlStateManager.func_179142_g();
            ModRenderHelper.enableAlphaBlend();
            GlStateManager.func_179126_j();
            SkinItemRenderHelper.renderSkinAsItem(skin, new SkinDescriptor(identifier), true, false, boxWidth, boxHeight);
            GlStateManager.func_179097_i();
            ModRenderHelper.disableAlphaBlend();
            GlStateManager.func_179133_A();
            GlStateManager.func_179119_h();
            GlStateManager.func_179117_G();
            GlStateManager.func_179099_b();
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void dialogResult(AbstractGuiDialog dialog, IDialogCallback.DialogResult result) {
        if (result == IDialogCallback.DialogResult.OK && dialog instanceof GuiGlobalLibraryDialogReportSkin) {
            new GlobalTaskSkinReport(((GuiGlobalLibraryDialogReportSkin)dialog).getSkinReport()).createTaskAndRun(new FutureCallback<GlobalTaskSkinReport.SkinReportResult>(){

                public void onSuccess(GlobalTaskSkinReport.SkinReportResult result) {
                    ModLogger.log("Skin report sent.");
                }

                public void onFailure(Throwable t) {
                    t.printStackTrace();
                }
            });
        }
        ((GuiGlobalLibrary)this.parent).closeDialog();
    }

    private static class DownloadSkin
    implements Runnable {
        private final JsonObject skinJson;
        private final File target;

        public DownloadSkin(JsonObject skinJson) {
            this.skinJson = skinJson;
            int skinId = skinJson.get("id").getAsInt();
            String idString = String.format("%04d", skinId);
            String skinName = skinJson.get("name").getAsString();
            File path = new File(ArmourersWorkshop.getProxy().getSkinLibraryDirectory(), "downloads/");
            this.target = new File(path, SkinIOUtils.makeFileNameValid(idString + " - " + skinName + ".armour"));
            if (!path.exists()) {
                path.mkdirs();
            }
            new Thread(this).start();
        }

        @Override
        public void run() {
            int serverId;
            String fileName = this.skinJson.get("file_name").getAsString();
            Skin skin = SkinDownloader.downloadSkin(fileName, serverId = this.skinJson.get("id").getAsInt());
            if (skin != null && SkinIOUtils.saveSkinToFile(this.target, skin)) {
                ILibraryManager libraryManager = ArmourersWorkshop.getProxy().libraryManager;
                libraryManager.reloadLibrary();
            }
        }
    }
}

