/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.handler;

import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDescriptor;
import moe.plushie.armourers_workshop.client.skin.cache.ClientSkinCache;
import moe.plushie.armourers_workshop.common.init.items.ModItems;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinDescriptor;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import moe.plushie.armourers_workshop.common.tileentities.TileEntitySkinnable;
import moe.plushie.armourers_workshop.utils.PlayerUtils;
import moe.plushie.armourers_workshop.utils.SkinNBTHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BlockHighlightRenderHandler {
    public BlockHighlightRenderHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onDrawBlockHighlightEvent(DrawBlockHighlightEvent event) {
        SkinDescriptor descriptor;
        EntityPlayer player = event.getPlayer();
        World world = event.getPlayer().func_130014_f_();
        RayTraceResult target = event.getTarget();
        if (target != null && target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockPos pos = target.func_178782_a();
        EnumFacing facing = target.field_178784_b;
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() == ModItems.SKIN && (descriptor = SkinNBTHelper.getSkinDescriptorFromStack(stack)) != null && descriptor.getIdentifier().getSkinType() == SkinTypeRegistry.skinBlock) {
            this.drawSkinnableBlockHelper(world, pos.func_177972_a(facing), facing, player, event.getPartialTicks(), descriptor);
        }
    }

    private void drawSkinnableBlockHelper(World world, BlockPos pos, EnumFacing facing, EntityPlayer player, float partialTicks, ISkinDescriptor descriptor) {
        Skin skin = ClientSkinCache.INSTANCE.getSkin(descriptor, false);
        if (skin == null) {
            return;
        }
        if (skin.getSkinType() != SkinTypeRegistry.skinBlock) {
            return;
        }
        double xOff = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double yOff = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double zOff = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        float f1 = 0.002f;
        float scale = 0.0625f;
        EnumFacing dir = PlayerUtils.getDirectionSide(player).func_176734_d();
        for (int ix = 0; ix < 3; ++ix) {
            for (int iy = 0; iy < 3; ++iy) {
                for (int iz = 0; iz < 3; ++iz) {
                    float[] bounds = TileEntitySkinnable.getBlockBounds(skin, -ix + 2, iy, iz, dir);
                    if (bounds == null) continue;
                    double minX = bounds[0];
                    double minY = bounds[1];
                    double minZ = bounds[2];
                    double maxX = bounds[3];
                    double maxY = bounds[4];
                    double maxZ = bounds[5];
                    AxisAlignedBB aabb = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
                    aabb = aabb.func_72317_d(-xOff - 1.0, -yOff, -zOff - 1.0);
                    aabb = aabb.func_72317_d((double)(dir.func_82601_c() * -1), 0.0, (double)(dir.func_82599_e() * -1));
                    aabb = aabb.func_186670_a(pos);
                    aabb = aabb.func_72317_d((double)ix, (double)iy, (double)iz);
                    BlockPos target = pos.func_177982_a(ix - 1 - dir.func_82601_c(), 0, iz - 1 - dir.func_82599_e());
                    boolean blocked = false;
                    if (!world.func_175623_d(target)) {
                        blocked = true;
                    }
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    GlStateManager.func_187441_d((float)1.0f);
                    GlStateManager.func_179097_i();
                    GlStateManager.func_179090_x();
                    GlStateManager.func_179118_c();
                    if (!blocked) {
                        RenderGlobal.func_189697_a((AxisAlignedBB)aabb.func_191195_a((double)f1, (double)f1, (double)f1), (float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
                    } else {
                        RenderGlobal.func_189697_a((AxisAlignedBB)aabb.func_191195_a((double)f1, (double)f1, (double)f1), (float)1.0f, (float)0.0f, (float)0.0f, (float)0.75f);
                    }
                    GlStateManager.func_179141_d();
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179084_k();
                }
            }
        }
    }
}

