/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.handler;

import moe.plushie.armourers_workshop.api.common.capability.IEntitySkinCapability;
import moe.plushie.armourers_workshop.api.common.capability.IPlayerWardrobeCap;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinDescriptor;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.client.model.skin.ModelSkinBow;
import moe.plushie.armourers_workshop.client.render.SkinItemRenderHelper;
import moe.plushie.armourers_workshop.client.render.SkinModelRenderHelper;
import moe.plushie.armourers_workshop.client.skin.cache.ClientSkinCache;
import moe.plushie.armourers_workshop.common.addons.ModAddonManager;
import moe.plushie.armourers_workshop.common.capability.entityskin.EntitySkinCapability;
import moe.plushie.armourers_workshop.common.capability.wardrobe.player.PlayerWardrobeCap;
import moe.plushie.armourers_workshop.common.init.items.ModItems;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import moe.plushie.armourers_workshop.utils.SkinNBTHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public final class ClientWardrobeHandler {
    private static ItemStack[] armour = new ItemStack[4];

    public ClientWardrobeHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static ItemStack getArmourInSlot(int slotId) {
        return armour[slotId];
    }

    @SubscribeEvent
    public void onRenderHand(RenderHandEvent event) {
    }

    @SubscribeEvent
    public void onRenderSpecificHand(RenderSpecificHandEvent event) {
        ISkinDescriptor descriptorItem;
        IEntitySkinCapability skinCapability;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack itemStack = event.getItemStack();
        if (itemStack.func_77973_b() == ModItems.SKIN) {
            return;
        }
        ISkinType[] skinTypes = new ISkinType[]{SkinTypeRegistry.skinSword, SkinTypeRegistry.skinShield, SkinTypeRegistry.skinBow, SkinTypeRegistry.skinPickaxe, SkinTypeRegistry.skinAxe, SkinTypeRegistry.skinShovel, SkinTypeRegistry.skinHoe, SkinTypeRegistry.skinItem};
        ModAddonManager.ItemOverrideType overrideType = null;
        ISkinType skinType = null;
        for (int i = 0; i < ModAddonManager.ItemOverrideType.values().length; ++i) {
            if (!ModAddonManager.isOverrideItem(ModAddonManager.ItemOverrideType.values()[i], itemStack.func_77973_b())) continue;
            overrideType = ModAddonManager.ItemOverrideType.values()[i];
            skinType = skinTypes[i];
        }
        if (overrideType == null | skinType == null) {
            return;
        }
        ISkinDescriptor descriptor = SkinNBTHelper.getSkinDescriptorFromStack(itemStack);
        if (descriptor == null && (skinCapability = EntitySkinCapability.get((Entity)player)) != null && ModAddonManager.isOverrideItem(overrideType, itemStack.func_77973_b()) && (descriptorItem = skinCapability.getSkinDescriptor(skinType, 0)) != null) {
            descriptor = descriptorItem;
        }
        if (descriptor == null) {
            return;
        }
        event.setCanceled(true);
        boolean flag = event.getHand() == EnumHand.OFF_HAND;
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        this.renderItemInFirstPerson((AbstractClientPlayer)player, event.getPartialTicks(), event.getInterpolatedPitch(), event.getHand(), event.getSwingProgress(), itemStack, event.getEquipProgress());
        GlStateManager.func_179089_o();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179147_l();
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0625f, (float)0.0625f);
        if (flag) {
            GlStateManager.func_179152_a((float)-1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
        }
        if (overrideType != ModAddonManager.ItemOverrideType.BOW) {
            SkinItemRenderHelper.renderSkinWithoutHelper(descriptor, false);
        } else {
            Skin skin = ClientSkinCache.INSTANCE.getSkin(descriptor);
            if (skin != null) {
                int useCount = player.func_184612_cw();
                ModelSkinBow model = SkinModelRenderHelper.INSTANCE.modelBow;
                model.frame = this.getAnimationFrame(useCount);
                model.render((Entity)player, skin, false, descriptor.getSkinDye(), null, false, 0.0, false);
            }
        }
        if (flag) {
            GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        }
        GlStateManager.func_179129_p();
        GlStateManager.func_179084_k();
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }

    private int getAnimationFrame(int useCount) {
        if (useCount >= 18) {
            return 2;
        }
        if (useCount > 13) {
            return 1;
        }
        return 0;
    }

    public void renderItemInFirstPerson(AbstractClientPlayer player, float p_187457_2_, float p_187457_3_, EnumHand hand, float p_187457_5_, ItemStack stack, float equipProgress) {
        boolean flag1;
        boolean flag = hand == EnumHand.MAIN_HAND;
        EnumHandSide enumhandside = flag ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
        boolean bl = flag1 = enumhandside == EnumHandSide.RIGHT;
        if (player.func_184587_cr() && player.func_184605_cv() > 0 && player.func_184600_cs() == hand) {
            int j = flag1 ? 1 : -1;
            switch (stack.func_77975_n()) {
                case NONE: {
                    this.transformSideFirstPerson(enumhandside, equipProgress);
                    break;
                }
                case EAT: 
                case DRINK: {
                    this.transformSideFirstPerson(enumhandside, equipProgress);
                    break;
                }
                case BLOCK: {
                    this.transformSideFirstPerson(enumhandside, equipProgress);
                    break;
                }
                case BOW: {
                    this.transformSideFirstPerson(enumhandside, equipProgress);
                    GlStateManager.func_179109_b((float)((float)j * -0.2785682f), (float)0.18344387f, (float)0.15731531f);
                    GlStateManager.func_179114_b((float)-13.935f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)((float)j * 35.3f), (float)0.0f, (float)1.0f, (float)0.0f);
                    GlStateManager.func_179114_b((float)((float)j * -9.785f), (float)0.0f, (float)0.0f, (float)1.0f);
                    float f5 = (float)stack.func_77988_m() - ((float)player.func_184605_cv() - p_187457_2_ + 1.0f);
                    float f6 = f5 / 20.0f;
                    f6 = (f6 * f6 + f6 * 2.0f) / 3.0f;
                    if (f6 > 1.0f) {
                        f6 = 1.0f;
                    }
                    if (f6 > 0.1f) {
                        float f7 = MathHelper.func_76126_a((float)((f5 - 0.1f) * 1.3f));
                        float f3 = f6 - 0.1f;
                        float f4 = f7 * f3;
                        GlStateManager.func_179109_b((float)(f4 * 0.0f), (float)(f4 * 0.004f), (float)(f4 * 0.0f));
                    }
                    GlStateManager.func_179109_b((float)(f6 * 0.0f), (float)(f6 * 0.0f), (float)(f6 * 0.04f));
                    GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)(1.0f + f6 * 0.2f));
                    GlStateManager.func_179114_b((float)((float)j * 45.0f), (float)0.0f, (float)-1.0f, (float)0.0f);
                }
            }
        } else {
            float f = -0.4f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)p_187457_5_) * (float)Math.PI));
            float f1 = 0.2f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)p_187457_5_) * ((float)Math.PI * 2)));
            float f2 = -0.2f * MathHelper.func_76126_a((float)(p_187457_5_ * (float)Math.PI));
            int i = flag1 ? 1 : -1;
            GlStateManager.func_179109_b((float)((float)i * f), (float)f1, (float)f2);
            this.transformSideFirstPerson(enumhandside, equipProgress);
            this.transformFirstPerson(enumhandside, p_187457_5_);
        }
    }

    private void transformSideFirstPerson(EnumHandSide hand, float equipProgress) {
        int i = hand == EnumHandSide.RIGHT ? 1 : -1;
        GlStateManager.func_179109_b((float)((float)i * 0.56f), (float)(-0.52f + equipProgress * -0.6f), (float)-0.72f);
    }

    private void transformFirstPerson(EnumHandSide hand, float equipProgress) {
        int i = hand == EnumHandSide.RIGHT ? 1 : -1;
        float f = MathHelper.func_76126_a((float)(equipProgress * equipProgress * (float)Math.PI));
        GlStateManager.func_179114_b((float)((float)i * (45.0f + f * -20.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
        float f1 = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)equipProgress) * (float)Math.PI));
        GlStateManager.func_179114_b((float)((float)i * f1 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(f1 * -80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)i * -45.0f), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    @SubscribeEvent
    public void onRender(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player instanceof FakePlayer) {
            return;
        }
        for (int i = 0; i < armour.length; ++i) {
            ClientWardrobeHandler.armour[i] = ItemStack.field_190927_a;
        }
        IPlayerWardrobeCap wardrobeCapability = PlayerWardrobeCap.get(player);
        if (wardrobeCapability != null) {
            for (int i = 0; i < armour.length; ++i) {
                EntityEquipmentSlot slot = EntityEquipmentSlot.values()[i + 2];
                ClientWardrobeHandler.armour[i] = (ItemStack)player.field_71071_by.field_70460_b.get(i);
                if (SkinNBTHelper.stackHasSkinData(armour[i])) {
                    player.field_71071_by.field_70460_b.set(i, (Object)ItemStack.field_190927_a);
                    continue;
                }
                if (!wardrobeCapability.getArmourOverride(slot)) continue;
                player.field_71071_by.field_70460_b.set(i, (Object)ItemStack.field_190927_a);
            }
        }
    }

    @SubscribeEvent
    public void onRender(RenderPlayerEvent.Post event) {
        EntityPlayer player = event.getEntityPlayer();
        for (int i = 0; i < armour.length; ++i) {
            player.field_71071_by.field_70460_b.set(i, (Object)armour[i]);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRenderLivingPre(RenderLivingEvent.Pre<EntityPlayer> event) {
        EntitySkinCapability skinCapability = (EntitySkinCapability)EntitySkinCapability.get((Entity)event.getEntity());
        if (skinCapability == null) {
            return;
        }
        for (RenderPlayer playerRender : Minecraft.func_71410_x().func_175598_ae().getSkinMap().values()) {
            ModelPlayer modelPlayer = playerRender.func_177087_b();
            if (skinCapability.hideHead) {
                modelPlayer.field_78116_c.field_78807_k = true;
            }
            if (skinCapability.hideHead | skinCapability.hideHeadOverlay) {
                modelPlayer.field_178720_f.field_78807_k = true;
            }
            if (skinCapability.hideChest) {
                modelPlayer.field_78115_e.field_78807_k = true;
            }
            if (skinCapability.hideChest | skinCapability.hideChestOverlay) {
                modelPlayer.field_178730_v.field_78807_k = true;
            }
            if (skinCapability.hideArmLeft) {
                modelPlayer.field_178724_i.field_78807_k = true;
            }
            if (skinCapability.hideArmLeft | skinCapability.hideArmLeftOverlay) {
                modelPlayer.field_178734_a.field_78807_k = true;
            }
            if (skinCapability.hideArmRight) {
                modelPlayer.field_178723_h.field_78807_k = true;
            }
            if (skinCapability.hideArmRight | skinCapability.hideArmRightOverlay) {
                modelPlayer.field_178732_b.field_78807_k = true;
            }
            if (skinCapability.hideLegLeft) {
                modelPlayer.field_178722_k.field_78807_k = true;
            }
            if (skinCapability.hideLegLeft | skinCapability.hideLegLeftOverlay) {
                modelPlayer.field_178733_c.field_78807_k = true;
            }
            if (skinCapability.hideLegRight) {
                modelPlayer.field_178721_j.field_78807_k = true;
            }
            if (!(skinCapability.hideLegRight | skinCapability.hideLegRightOverlay)) continue;
            modelPlayer.field_178731_d.field_78807_k = true;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onRenderLivingPost(RenderLivingEvent.Post<EntityPlayer> event) {
        for (RenderPlayer playerRender : Minecraft.func_71410_x().func_175598_ae().getSkinMap().values()) {
            ModelPlayer modelPlayer = playerRender.func_177087_b();
            modelPlayer.field_78116_c.field_78807_k = false;
            modelPlayer.field_178720_f.field_78807_k = false;
            modelPlayer.field_78115_e.field_78807_k = false;
            modelPlayer.field_178730_v.field_78807_k = false;
            modelPlayer.field_178724_i.field_78807_k = false;
            modelPlayer.field_178734_a.field_78807_k = false;
            modelPlayer.field_178723_h.field_78807_k = false;
            modelPlayer.field_178732_b.field_78807_k = false;
            modelPlayer.field_178722_k.field_78807_k = false;
            modelPlayer.field_178733_c.field_78807_k = false;
            modelPlayer.field_178721_j.field_78807_k = false;
            modelPlayer.field_178731_d.field_78807_k = false;
        }
    }
}

