/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.capability;

import java.util.concurrent.Callable;
import moe.plushie.armourers_workshop.api.common.capability.IEntitySkinCapability;
import moe.plushie.armourers_workshop.api.common.capability.IPlayerWardrobeCap;
import moe.plushie.armourers_workshop.api.common.capability.IWardrobeCap;
import moe.plushie.armourers_workshop.api.common.skin.entity.ISkinnableEntity;
import moe.plushie.armourers_workshop.common.capability.entityskin.EntitySkinCapability;
import moe.plushie.armourers_workshop.common.capability.entityskin.EntitySkinProvider;
import moe.plushie.armourers_workshop.common.capability.entityskin.EntitySkinStorage;
import moe.plushie.armourers_workshop.common.capability.holiday.HolidayTrackCap;
import moe.plushie.armourers_workshop.common.capability.holiday.IHolidayTrackCap;
import moe.plushie.armourers_workshop.common.capability.wardrobe.WardrobeCap;
import moe.plushie.armourers_workshop.common.capability.wardrobe.WardrobeProvider;
import moe.plushie.armourers_workshop.common.capability.wardrobe.WardrobeStorage;
import moe.plushie.armourers_workshop.common.capability.wardrobe.player.PlayerWardrobeCap;
import moe.plushie.armourers_workshop.common.capability.wardrobe.player.PlayerWardrobeProvider;
import moe.plushie.armourers_workshop.common.capability.wardrobe.player.PlayerWardrobeStorage;
import moe.plushie.armourers_workshop.common.config.ConfigHandler;
import moe.plushie.armourers_workshop.common.skin.entity.SkinnableEntityRegisty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

@Mod.EventBusSubscriber(modid="armourers_workshop")
public final class ModCapabilityManager {
    private static final ResourceLocation KEY_ENTITY_SKIN_PROVIDER = new ResourceLocation("armourers_workshop", "entity-skin-provider");
    private static final ResourceLocation KEY_WARDROBE_PROVIDER = new ResourceLocation("armourers_workshop", "wardrobe-provider");
    private static final ResourceLocation KEY_PLAYER_WARDROBE_PROVIDER = new ResourceLocation("armourers_workshop", "player-wardrobe-provider");
    private static final ResourceLocation KEY_HOLIDAY_TRACKER = new ResourceLocation("armourers_workshop", "holiday-tracker");

    private ModCapabilityManager() {
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IEntitySkinCapability.class, (Capability.IStorage)new EntitySkinStorage(), (Callable)new Callable<IEntitySkinCapability>(){

            @Override
            public IEntitySkinCapability call() throws Exception {
                return null;
            }
        });
        CapabilityManager.INSTANCE.register(IWardrobeCap.class, (Capability.IStorage)new WardrobeStorage(), (Callable)new Callable<IWardrobeCap>(){

            @Override
            public IWardrobeCap call() throws Exception {
                return null;
            }
        });
        CapabilityManager.INSTANCE.register(IPlayerWardrobeCap.class, (Capability.IStorage)new PlayerWardrobeStorage(), (Callable)new Callable<IPlayerWardrobeCap>(){

            @Override
            public IPlayerWardrobeCap call() throws Exception {
                return null;
            }
        });
        CapabilityManager.INSTANCE.register(IHolidayTrackCap.class, (Capability.IStorage)new HolidayTrackCap.Storage(), (Callable)new HolidayTrackCap.Factory());
    }

    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (!(event.getObject() instanceof Entity)) {
            return;
        }
        Entity entity = (Entity)event.getObject();
        ISkinnableEntity skinnableEntity = SkinnableEntityRegisty.INSTANCE.getSkinnableEntity(entity);
        if (skinnableEntity == null) {
            return;
        }
        event.addCapability(KEY_ENTITY_SKIN_PROVIDER, (ICapabilityProvider)new EntitySkinProvider(entity, skinnableEntity));
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            event.addCapability(KEY_PLAYER_WARDROBE_PROVIDER, (ICapabilityProvider)new PlayerWardrobeProvider(player, skinnableEntity));
            event.addCapability(KEY_HOLIDAY_TRACKER, (ICapabilityProvider)new HolidayTrackCap.Provider());
        } else {
            event.addCapability(KEY_WARDROBE_PROVIDER, (ICapabilityProvider)new WardrobeProvider(entity, skinnableEntity));
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        IEntitySkinCapability skinCapability = EntitySkinCapability.get(event.getTarget());
        if (skinCapability != null) {
            skinCapability.syncToPlayer((EntityPlayerMP)event.getEntityPlayer());
        }
        if (event.getTarget() instanceof EntityPlayer) {
            IPlayerWardrobeCap wardrobeCapability = PlayerWardrobeCap.get((EntityPlayer)event.getTarget());
            if (wardrobeCapability != null) {
                wardrobeCapability.syncToPlayer((EntityPlayerMP)event.getEntityPlayer());
            }
        } else {
            IWardrobeCap wardrobeCapability = WardrobeCap.get(event.getTarget());
            if (wardrobeCapability != null) {
                wardrobeCapability.syncToPlayer((EntityPlayerMP)event.getEntityPlayer());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        IPlayerWardrobeCap wardrobeCapability;
        IEntitySkinCapability skinCapability = EntitySkinCapability.get((Entity)event.player);
        if (skinCapability != null) {
            skinCapability.syncToPlayer((EntityPlayerMP)event.player);
        }
        if ((wardrobeCapability = PlayerWardrobeCap.get(event.player)) != null) {
            wardrobeCapability.syncToPlayer((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        if (!event.getEntity().func_130014_f_().field_72995_K & event.getEntityLiving() instanceof EntityPlayer) {
            IEntitySkinCapability skinCapability = EntitySkinCapability.get((Entity)event.getEntityLiving());
            if (skinCapability == null) {
                return;
            }
            boolean dropSkins = true;
            MinecraftServer server = event.getEntity().func_130014_f_().func_73046_m();
            GameRules gr = ModCapabilityManager.getGameRules(server);
            boolean keepInventory = false;
            if (gr.func_82765_e("keepInventory")) {
                keepInventory = gr.func_82766_b("keepInventory");
            }
            switch (ConfigHandler.wardrobeDropSkinsOnDeath) {
                case 0: {
                    dropSkins = !keepInventory;
                    break;
                }
                case 1: {
                    dropSkins = false;
                    break;
                }
                case 2: {
                    dropSkins = true;
                    break;
                }
                default: {
                    boolean bl = dropSkins = !keepInventory;
                }
            }
            if (dropSkins) {
                skinCapability.getSkinInventoryContainer().dropItems(event.getEntityLiving().func_130014_f_(), event.getEntityLiving().func_174791_d());
            }
        }
    }

    private static GameRules getGameRules(MinecraftServer server) {
        return server.func_71218_a(0).func_82736_K();
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        World world = event.getEntityPlayer().func_130014_f_();
        NBTBase nbt = null;
        IPlayerWardrobeCap wardrobeCapOld = PlayerWardrobeCap.get(event.getOriginal());
        IPlayerWardrobeCap wardrobeCapNew = PlayerWardrobeCap.get(event.getEntityPlayer());
        Capability.IStorage storageWardrobe = PlayerWardrobeCap.PLAYER_WARDROBE_CAP.getStorage();
        nbt = storageWardrobe.writeNBT(PlayerWardrobeCap.PLAYER_WARDROBE_CAP, (Object)wardrobeCapOld, null);
        storageWardrobe.readNBT(PlayerWardrobeCap.PLAYER_WARDROBE_CAP, (Object)wardrobeCapNew, null, nbt);
        IEntitySkinCapability skinCapOld = EntitySkinCapability.get((Entity)event.getOriginal());
        IEntitySkinCapability skinCapNew = EntitySkinCapability.get((Entity)event.getEntityPlayer());
        Capability.IStorage storageEntitySkin = EntitySkinCapability.ENTITY_SKIN_CAP.getStorage();
        nbt = storageEntitySkin.writeNBT(EntitySkinCapability.ENTITY_SKIN_CAP, (Object)skinCapOld, null);
        storageEntitySkin.readNBT(EntitySkinCapability.ENTITY_SKIN_CAP, (Object)skinCapNew, null, nbt);
    }

    @SubscribeEvent
    public static void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        IPlayerWardrobeCap wardrobeCap = PlayerWardrobeCap.get(event.player);
        wardrobeCap.syncToAllTracking();
        wardrobeCap.syncToPlayer((EntityPlayerMP)event.player);
        IEntitySkinCapability skinCap = EntitySkinCapability.get((Entity)event.player);
        skinCap.syncToAllTracking();
        skinCap.syncToPlayer((EntityPlayerMP)event.player);
    }

    @SubscribeEvent
    public static void onChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        IPlayerWardrobeCap wardrobeCap = PlayerWardrobeCap.get(event.player);
        wardrobeCap.syncToPlayer((EntityPlayerMP)event.player);
        IEntitySkinCapability skinCap = EntitySkinCapability.get((Entity)event.player);
        skinCap.syncToPlayer((EntityPlayerMP)event.player);
    }
}

