/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.library.global.task;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import java.net.URLEncoder;
import moe.plushie.armourers_workshop.common.library.global.auth.MinecraftAuth;
import moe.plushie.armourers_workshop.common.library.global.auth.PlushieAuth;
import moe.plushie.armourers_workshop.common.library.global.auth.PlushieSession;
import moe.plushie.armourers_workshop.common.library.global.permission.PermissionSystem;
import moe.plushie.armourers_workshop.common.library.global.task.GlobalTask;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraft.client.Minecraft;

public class GlobalTaskBetaJoin
extends GlobalTask<BetaJoinResult> {
    private static final String URL_JOIN = "join.php?username=%s&uuid=%s&serverId=%s";

    public GlobalTaskBetaJoin() {
        super(PermissionSystem.PlushieAction.BETA_JOIN, true);
    }

    @Override
    public BetaJoinResult call() throws Exception {
        this.permissionCheck();
        PlushieSession session = PlushieAuth.PLUSHIE_SESSION;
        if (session.hasServerId()) {
            return new BetaJoinResult(BetaJoinResult.JoinResult.ALREADY_JOINED);
        }
        GameProfile gameProfile = Minecraft.func_71410_x().field_71439_g.func_146103_bH();
        String username = URLEncoder.encode(gameProfile.getName(), "UTF-8");
        String uuid = URLEncoder.encode(gameProfile.getId().toString(), "UTF-8");
        String serverId = String.valueOf(this.getBaseUrl().hashCode());
        if (!MinecraftAuth.checkAndRefeshAuth(Minecraft.func_71410_x().func_110432_I(), serverId)) {
            ModLogger.log("Failed MC Auth");
            return new BetaJoinResult(BetaJoinResult.JoinResult.MINECRAFT_AUTH_FAIL);
        }
        ModLogger.log("MC Auth Done");
        String urlJoin = String.format(this.getBaseUrl() + URL_JOIN, username, uuid, serverId);
        JsonObject jsonJoinResult = new JsonParser().parse(GlobalTaskBetaJoin.downloadString(urlJoin)).getAsJsonObject();
        if (jsonJoinResult.has("action") & jsonJoinResult.has("valid")) {
            String action = jsonJoinResult.get("action").getAsString();
            boolean valid = jsonJoinResult.get("valid").getAsBoolean();
            if (action.equals("join")) {
                if (valid) {
                    PlushieAuth.doRemoteUserCheck();
                    PlushieAuth.PLUSHIE_SESSION.authenticate(jsonJoinResult);
                    return new BetaJoinResult(BetaJoinResult.JoinResult.JOINED);
                }
                String reason = "";
                if (jsonJoinResult.has("reason")) {
                    reason = jsonJoinResult.get("reason").getAsString();
                }
                return new BetaJoinResult(BetaJoinResult.JoinResult.JOIN_FAILED, reason);
            }
        }
        return new BetaJoinResult(BetaJoinResult.JoinResult.JOIN_FAILED);
    }

    public static class BetaJoinResult {
        private final JoinResult joinResult;
        private final String message;

        public BetaJoinResult(JoinResult joinResult) {
            this.joinResult = joinResult;
            this.message = joinResult.toString().toLowerCase();
        }

        public BetaJoinResult(JoinResult joinResult, String message) {
            this.joinResult = joinResult;
            this.message = message;
        }

        public JoinResult getJoinResult() {
            return this.joinResult;
        }

        public String getMessage() {
            return this.message;
        }

        public static enum JoinResult {
            ALREADY_JOINED,
            MINECRAFT_AUTH_FAIL,
            JOIN_FAILED,
            JOINED;

        }
    }
}

