/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.skin.cache;

import java.util.LinkedList;
import java.util.Queue;
import moe.plushie.armourers_workshop.api.common.library.ILibraryFile;
import moe.plushie.armourers_workshop.api.common.skin.data.ISkinIdentifier;
import moe.plushie.armourers_workshop.common.data.type.BidirectionalHashMap;
import moe.plushie.armourers_workshop.common.library.LibraryFile;
import moe.plushie.armourers_workshop.common.skin.cache.CommonSkinCache;
import moe.plushie.armourers_workshop.common.skin.cache.SkinCacheLocalDatabase;
import moe.plushie.armourers_workshop.common.skin.cache.SkinRequestMessage;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinIdentifier;
import moe.plushie.armourers_workshop.utils.ModLogger;
import moe.plushie.armourers_workshop.utils.SkinIOUtils;
import org.apache.logging.log4j.Level;

public class SkinCacheLocalFile {
    private final BidirectionalHashMap<ILibraryFile, Integer> cacheMapFileLink;
    private final Object cacheMapLock = new Object();
    private final Queue<SkinRequestMessage> skinLoadQueue;
    private final Object skinLoadQueueLock = new Object();
    private final SkinCacheLocalDatabase cacheLocalDatabase;

    public SkinCacheLocalFile(SkinCacheLocalDatabase cacheLocalDatabase) {
        this.cacheLocalDatabase = cacheLocalDatabase;
        this.cacheMapFileLink = new BidirectionalHashMap();
        this.skinLoadQueue = new LinkedList<SkinRequestMessage>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSkinLoading() {
        Object object = this.cacheMapLock;
        synchronized (object) {
            Object object2 = this.skinLoadQueueLock;
            synchronized (object2) {
                if (!this.skinLoadQueue.isEmpty()) {
                    SkinRequestMessage requestMessage = this.skinLoadQueue.remove();
                    Skin skin = null;
                    try {
                        skin = this.load(requestMessage.getSkinIdentifier());
                    }
                    catch (Exception e) {
                        CommonSkinCache.INSTANCE.onSkinLoaded(null, requestMessage);
                        e.printStackTrace();
                    }
                    if (skin != null) {
                        CommonSkinCache.INSTANCE.onSkinLoaded(skin, requestMessage);
                    }
                }
            }
        }
    }

    public Skin get(ISkinIdentifier identifier, boolean softLoad) {
        return this.get(new SkinRequestMessage(identifier, null), softLoad);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Skin get(SkinRequestMessage requestMessage, boolean softLoad) {
        ISkinIdentifier identifier = requestMessage.getSkinIdentifier();
        ILibraryFile libraryFile = identifier.getSkinLibraryFile();
        Object object = this.cacheMapLock;
        synchronized (object) {
            if (!this.cacheMapFileLink.containsKey(libraryFile)) {
                if (softLoad) {
                    Object object2 = this.skinLoadQueueLock;
                    synchronized (object2) {
                        this.skinLoadQueue.add(requestMessage);
                    }
                    return null;
                }
                this.load(identifier);
            }
            if (this.cacheMapFileLink.containsKey(libraryFile)) {
                int id = this.cacheMapFileLink.get(libraryFile);
                SkinIdentifier newIdentifier = new SkinIdentifier(id, requestMessage.getSkinIdentifier().getSkinLibraryFile(), 0, requestMessage.getSkinIdentifier().getSkinType());
                Skin skin = this.cacheLocalDatabase.get(newIdentifier, false);
                if (skin != null) {
                    return skin;
                }
                ModLogger.log(Level.WARN, "Somehow failed to load a skin that we should have. ID was " + id);
            } else if (requestMessage.getPlayer() != null) {
                ModLogger.log(Level.ERROR, "Skin [" + libraryFile.getFullName() + "] was requested by " + requestMessage.getPlayer().func_70005_c_() + " but was not found.");
            } else {
                ModLogger.log(Level.ERROR, "Skin [" + libraryFile.getFullName() + "] was requested but was not found.");
            }
        }
        return null;
    }

    private Skin load(ISkinIdentifier skinIdentifier) {
        Skin skin = SkinIOUtils.loadSkinFromFileName(skinIdentifier.getSkinLibraryFile().getFullName() + ".armour");
        this.addSkinToCache(skin, skinIdentifier.getSkinLibraryFile());
        return skin;
    }

    private void addSkinToCache(Skin skin, ILibraryFile libraryFile) {
        if (skin == null) {
            return;
        }
        this.cacheLocalDatabase.add(skin);
        this.cacheMapFileLink.put(libraryFile, skin.lightHash());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(LibraryFile libraryFile, int skinId) {
        Object object = this.cacheMapLock;
        synchronized (object) {
            this.cacheMapFileLink.put(libraryFile, skinId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(int skinId) {
        Object object = this.cacheMapLock;
        synchronized (object) {
            return this.cacheMapFileLink.containsValue(skinId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILibraryFile getBackward(int skinId) {
        Object object = this.cacheMapLock;
        synchronized (object) {
            if (this.cacheMapFileLink.getMapBackward().containsKey(skinId)) {
                return this.cacheMapFileLink.getBackward(skinId);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ILibraryFile libraryFile) {
        Object object = this.cacheMapLock;
        synchronized (object) {
            this.cacheMapFileLink.remove(libraryFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.cacheMapLock;
        synchronized (object) {
            return this.cacheMapFileLink.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.cacheMapLock;
        synchronized (object) {
            this.cacheMapFileLink.clear();
        }
    }
}

