/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.item;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.registry.Registry;
import org.orecruncher.dsurround.registry.config.ModConfiguration;
import org.orecruncher.dsurround.registry.item.IItemData;
import org.orecruncher.dsurround.registry.item.ItemClass;
import org.orecruncher.dsurround.registry.item.ItemUtils;
import org.orecruncher.dsurround.registry.item.SimpleItemData;
import org.orecruncher.dsurround.registry.item.compat.ItemDataProducer;
import org.orecruncher.lib.ItemStackUtil;
import org.orecruncher.lib.MCHelper;

@SideOnly(value=Side.CLIENT)
public final class ItemRegistry
extends Registry {
    private static final String ID_PATTERN = "\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*";
    private static final Pattern FQCN = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*(\\.\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)*");
    private static final Pattern ITEM_PATTERN = Pattern.compile("([\\w\\-]+:[\\w\\.\\-/]+)[:]?(\\d+|\\*)?(\\{.*\\})?");
    private static final int SET_CAPACITY = 64;
    private static final int MAP_CAPACITY = 256;
    private SimpleItemData NONE_DATA;
    private EnumMap<ItemClass, Set<Class<?>>> classMap;
    private Map<Item, IItemData> items;

    public ItemRegistry() {
        super("Item Registry");
    }

    @Override
    protected void preInit() {
        this.classMap = new EnumMap(ItemClass.class);
        this.items = new IdentityHashMap<Item, IItemData>(256);
        this.NONE_DATA = (SimpleItemData)SimpleItemData.CACHE.get((Object)ItemClass.NONE);
        Item.field_150901_e.iterator().forEachRemaining(item -> ItemUtils.setItemData(item, this.NONE_DATA));
        ItemUtils.setItemData(Items.field_190931_a, (IItemData)SimpleItemData.CACHE.get((Object)ItemClass.EMPTY));
        for (ItemClass ic : ItemClass.values()) {
            this.classMap.put(ic, (Set<Class<?>>)new ReferenceOpenHashSet(64));
        }
    }

    @Override
    protected void init(@Nonnull ModConfiguration cfg) {
        for (Map.Entry<String, List<String>> entry : cfg.items.entrySet()) {
            this.process(entry.getValue(), entry.getKey());
        }
    }

    @Override
    protected void postInit() {
        for (Item item : Item.field_150901_e) {
            ItemClass ic;
            if (this.items.containsKey(item) || (ic = this.resolveClass(item)) == ItemClass.NONE) continue;
            this.items.put(item, ItemDataProducer.create(item, ic));
        }
        this.items.entrySet().forEach(entry -> ItemUtils.setItemData((Item)entry.getKey(), (IItemData)entry.getValue()));
        this.items = null;
        this.classMap = null;
    }

    private ItemClass resolveClass(@Nonnull Item item) {
        for (ItemClass ic : ItemClass.values()) {
            Set<Class<?>> itemSet = this.classMap.get((Object)ic);
            if (!this.doesBelong(itemSet, item)) continue;
            return ic;
        }
        return ItemClass.NONE;
    }

    private boolean doesBelong(@Nonnull Set<Class<?>> itemSet, @Nonnull Item item) {
        Class<?> itemClass = item.getClass();
        if (itemSet.contains(itemClass)) {
            return true;
        }
        Optional<Class> result = itemSet.stream().filter(c -> c.isAssignableFrom(itemClass)).findFirst();
        if (result.isPresent()) {
            itemSet.add(itemClass);
            return true;
        }
        return false;
    }

    private void process(@Nullable List<String> items, @Nonnull String itemClass) {
        if (items == null || items.isEmpty()) {
            return;
        }
        ItemClass ic = ItemClass.valueOf(itemClass);
        if (ic == null) {
            ModBase.log().warn("Unknown ItemClass %s", new Object[]{itemClass});
            return;
        }
        Set<Class<?>> theList = this.classMap.get((Object)ic);
        for (String c : items) {
            Matcher match = ITEM_PATTERN.matcher(c);
            if (match.matches()) {
                String itemName = match.group(1);
                Item item = MCHelper.getItemByName((String)itemName);
                if (item != null) {
                    this.items.put(item, ItemDataProducer.create(item, ic));
                    continue;
                }
                ModBase.log().warn("Cannot locate item [%s] for ItemRegistry", new Object[]{c});
                continue;
            }
            match = FQCN.matcher(c);
            if (match.matches()) {
                try {
                    Class<?> clazz = Class.forName(c, false, ItemRegistry.class.getClassLoader());
                    theList.add(clazz);
                }
                catch (ClassNotFoundException e) {
                    ModBase.log().warn("Cannot locate class '%s' for ItemRegistry", new Object[]{c});
                }
                continue;
            }
            ModBase.log().warn("Unrecognized pattern '%s' for ItemRegistry", new Object[]{c});
        }
    }

    @Nonnull
    public IItemData getItemClass(@Nonnull ItemStack stack) {
        return ItemStackUtil.isValidItemStack((ItemStack)stack) ? ItemUtils.getItemData(stack.func_77973_b()) : this.NONE_DATA;
    }
}

