/*
 * Decompiled with CFR 0.152.
 */
package chloeprime.fix4log4j.bukkit;

import chloeprime.fix4log4j.Censor;
import chloeprime.fix4log4j.Fixer;
import org.apache.logging.log4j.LogManager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Fix4Log4JBukkitPlugin
extends JavaPlugin
implements Listener {
    private volatile boolean doCensor;

    public void onLoad() {
        Fixer.disableJndiManager();
        super.onLoad();
    }

    public void onEnable() {
        super.onEnable();
        Fixer.doRuntimeTest(LogManager.getLogger((String)"Fix4Log4J"));
        this.doCensor = this.getConfig().getBoolean("censor-user-input", true);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void censorCommand(PlayerCommandPreprocessEvent event) {
        if (!this.doCensor) {
            return;
        }
        if (Censor.isMaliciousMessage(event.getMessage())) {
            this.getLogger().warning("Found malicious player command sent by " + event.getPlayer().getName());
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void censorChatAsync(AsyncPlayerChatEvent event) {
        if (!this.doCensor) {
            return;
        }
        if (Censor.isMaliciousMessage(event.getMessage())) {
            this.getLogger().warning("Found malicious chat message sent by " + event.getPlayer().getName());
            event.setCancelled(true);
        }
    }
}

