/*
 * Decompiled with CFR 0.152.
 */
package kamkeel.npcdbc.data.form;

import JinRyuu.JRMCore.JRMCoreH;
import java.util.Arrays;
import kamkeel.npcdbc.api.form.IFormKaiokenStackables;
import kamkeel.npcdbc.data.form.Form;
import kamkeel.npcdbc.data.form.FormStackable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class FormKaiokenStackableData
implements IFormKaiokenStackables {
    public float kaiokenDrainMulti = 1.0f;
    public float[] kaiokenBalanceValue = new float[6];
    public float[] kaiokenStrainedBalanceValue = new float[6];
    public boolean kaiokenMultipliesCurrentFormDrain;
    public boolean isUsingGlobalAttributeMultis;
    public float attributeMultiScalar = 1.0f;
    public float[] kaiokenMultis;
    private final Form parent;
    private final FormStackable stackableParent;

    public FormKaiokenStackableData(Form parent, FormStackable formStackable) {
        this.parent = parent;
        this.stackableParent = formStackable;
        Arrays.fill(this.kaiokenBalanceValue, 1.0f);
        Arrays.fill(this.kaiokenStrainedBalanceValue, 1.0f);
        this.kaiokenMultis = Arrays.copyOfRange(JRMCoreH.TransKaiDmg, 1, JRMCoreH.TransKaiDmg.length);
    }

    public void readFromNBT(NBTTagCompound stack) {
        if (stack.func_74764_b("kaiokenDrainData")) {
            NBTTagCompound kaioDrain = stack.func_74775_l("kaiokenDrainData");
            this.kaiokenDrainMulti = kaioDrain.func_74760_g("multi");
            NBTTagCompound balanceNormal = kaioDrain.func_74775_l("balanceNormal");
            for (int i = 0; i < 6; ++i) {
                this.kaiokenBalanceValue[i] = balanceNormal.func_74760_g(i + "");
            }
            NBTTagCompound balanceStrained = kaioDrain.func_74775_l("balanceStrained");
            for (int i = 0; i < 6; ++i) {
                this.kaiokenStrainedBalanceValue[i] = balanceStrained.func_74760_g(i + "");
            }
            this.kaiokenMultipliesCurrentFormDrain = kaioDrain.func_74767_n("multipliesCurrentFormDrain");
        } else {
            this.kaiokenMultipliesCurrentFormDrain = true;
        }
        if (stack.func_74764_b("kaiokenMultiData")) {
            NBTTagCompound kaioMulti = stack.func_74775_l("kaiokenMultiData");
            this.isUsingGlobalAttributeMultis = kaioMulti.func_74767_n("isUsingGlobal");
            this.attributeMultiScalar = kaioMulti.func_74760_g("attributeScalar");
            NBTTagCompound multis = kaioMulti.func_74775_l("multis");
            for (int i = 0; i < 6; ++i) {
                this.kaiokenMultis[i] = multis.func_74760_g(i + "");
            }
        } else {
            this.isUsingGlobalAttributeMultis = true;
            this.attributeMultiScalar = 1.0f;
        }
    }

    public void saveToNBT(NBTTagCompound stack) {
        NBTTagCompound kaioDrainData = new NBTTagCompound();
        kaioDrainData.func_74776_a("multi", this.kaiokenDrainMulti);
        NBTTagCompound kaioBalanceNormal = new NBTTagCompound();
        for (int i = 0; i < 6; ++i) {
            kaioBalanceNormal.func_74776_a(i + "", this.kaiokenBalanceValue[i]);
        }
        NBTTagCompound kaioBalanceStrained = new NBTTagCompound();
        for (int i = 0; i < 6; ++i) {
            kaioBalanceStrained.func_74776_a(i + "", this.kaiokenStrainedBalanceValue[i]);
        }
        kaioDrainData.func_74782_a("balanceNormal", (NBTBase)kaioBalanceNormal);
        kaioDrainData.func_74782_a("balanceStrained", (NBTBase)kaioBalanceStrained);
        kaioDrainData.func_74757_a("multipliesCurrentFormDrain", this.kaiokenMultipliesCurrentFormDrain);
        stack.func_74782_a("kaiokenDrainData", (NBTBase)kaioDrainData);
        NBTTagCompound kaioMulti = new NBTTagCompound();
        kaioMulti.func_74757_a("isUsingGlobal", this.isUsingGlobalAttributeMultis);
        kaioMulti.func_74776_a("attributeScalar", this.attributeMultiScalar);
        NBTTagCompound multiData = new NBTTagCompound();
        for (int i = 0; i < 6; ++i) {
            multiData.func_74776_a(i + "", this.kaiokenMultis[i]);
        }
        kaioMulti.func_74782_a("multis", (NBTBase)multiData);
        stack.func_74782_a("kaiokenMultiData", (NBTBase)kaioMulti);
    }

    @Override
    public void setKaioDrain(float drain) {
        this.kaiokenDrainMulti = drain;
    }

    @Override
    public float getKaioDrain() {
        return this.kaiokenDrainMulti;
    }

    @Override
    public void setMultiplyingCurrentFormDrain(boolean isOn) {
        this.kaiokenMultipliesCurrentFormDrain = isOn;
    }

    @Override
    public boolean isMultiplyingCurrentFormDrain() {
        return this.kaiokenMultipliesCurrentFormDrain;
    }

    @Override
    public void setKaioState2Balance(int state2, boolean strained, float value) {
        if (state2 < 0) {
            state2 = 0;
        }
        if (state2 > 5) {
            state2 = 5;
        }
        if (strained) {
            this.kaiokenStrainedBalanceValue[state2] = value;
        } else {
            this.kaiokenBalanceValue[state2] = value;
        }
    }

    @Override
    public float getKaioState2Balance(int state2, boolean strained) {
        if (state2 < 0) {
            state2 = 0;
        }
        if (state2 > 5) {
            state2 = 5;
        }
        return strained ? this.kaiokenStrainedBalanceValue[state2] : this.kaiokenBalanceValue[state2];
    }

    @Override
    public float getKaiokenAttributeMulti(int state2) {
        if (state2 < 0) {
            return 1.0f;
        }
        if (state2 >= this.kaiokenMultis.length) {
            return 1.0f;
        }
        return this.kaiokenMultis[state2];
    }

    @Override
    public float getKaiokenMultiScalar() {
        return this.attributeMultiScalar;
    }

    @Override
    public void setKaiokenAttributeMulti(int state2, float multi) {
        if (state2 < 0) {
            return;
        }
        if (state2 >= this.kaiokenMultis.length) {
            return;
        }
        this.kaiokenMultis[state2] = multi;
    }

    @Override
    public void setKaiokenMultiScalar(float scalar) {
        if (scalar < 0.0f) {
            scalar = 0.0f;
        }
        this.attributeMultiScalar = scalar;
    }

    @Override
    public boolean isUsingGlobalAttributeMultis() {
        return this.isUsingGlobalAttributeMultis;
    }

    @Override
    public void setUsingGlobalAttributeMultis(boolean isUsing) {
        this.isUsingGlobalAttributeMultis = isUsing;
    }

    public float getCurrentFormMulti(int state2) {
        if (state2 < 0) {
            return 1.0f;
        }
        if (state2 >= this.kaiokenMultis.length) {
            return 1.0f;
        }
        if (this.isUsingGlobalAttributeMultis) {
            return JRMCoreH.TransKaiDmg[state2 + 1] * this.attributeMultiScalar;
        }
        return this.kaiokenMultis[state2] * this.attributeMultiScalar;
    }
}

