/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.controls;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.regex.Pattern;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class GuiCustomLabel
extends Gui {
    private final FontRenderer fontRenderer;
    private int colour = -1;
    private int x;
    private int y;
    private int width;
    private int height;
    private String text = "";

    public GuiCustomLabel(FontRenderer fontRenderer, int x, int y, int width, int height) {
        this.fontRenderer = fontRenderer;
        this.x = x;
        this.y = y;
        this.height = height;
        this.width = width;
    }

    public void setColour(int colour) {
        this.colour = colour;
    }

    public void addLine(String text) {
        this.text = this.text + text + "\n";
    }

    public void addText(String text) {
        this.text = this.text + text;
    }

    public void addUrl(String url) {
        this.text = this.text + TextFormatting.BLUE.toString() + url + TextFormatting.RESET.toString();
    }

    public void addNewLine() {
        this.text = this.text + "\n";
    }

    public void addNewLines(int count) {
        for (int i = 0; i < count; ++i) {
            this.text = this.text + "\n";
        }
    }

    public void clearText() {
        this.text = "";
    }

    public boolean mouseClick(int mouseX, int mouseY, int button) {
        if (this.isInside(mouseX, mouseY)) {
            if (button != 0) {
                return true;
            }
            String textAtMouse = StringUtils.func_76338_a((String)this.getWordAtPos(mouseX, mouseY));
            if (textAtMouse.startsWith("http")) {
                try {
                    this.openWebLink(new URI(textAtMouse));
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }

    public void draw(int mouseX, int mouseY) {
        String displayString = this.text;
        String textAtMouse = this.getWordAtPos(mouseX, mouseY);
        String replaceCheck = "http";
        if (StringUtils.func_76338_a((String)textAtMouse).startsWith(replaceCheck)) {
            String url = StringUtils.func_76338_a((String)textAtMouse);
            displayString = displayString.replace(TextFormatting.BLUE.toString() + url, TextFormatting.BLUE.toString() + TextFormatting.UNDERLINE.toString() + url);
        }
        List lines = this.fontRenderer.func_78271_c(displayString, this.width);
        for (int i = 0; i < lines.size(); ++i) {
            this.fontRenderer.func_78276_b((String)lines.get(i), this.x, this.y + i * this.fontRenderer.field_78288_b, this.colour);
        }
    }

    public String getWordAtPos(int posX, int posY) {
        String line = this.getLineAtPos(posX, posY);
        if (line.isEmpty()) {
            return "";
        }
        String[] words = line.split(Pattern.quote(" "));
        String text = "";
        for (int i = 0; i < words.length; ++i) {
            int textWidth;
            if (posX >= this.x & posX < this.x + (textWidth = this.fontRenderer.func_78256_a(text = text + words[i]))) {
                return words[i];
            }
            text = text + " ";
        }
        return "";
    }

    public String getLineAtPos(int posX, int posY) {
        List lines;
        int line = this.getLineIndexAtPos(posX, posY);
        if (line >= 0 && line < (lines = this.fontRenderer.func_78271_c(this.text, this.width)).size()) {
            return (String)lines.get(line);
        }
        return "";
    }

    public int getLineIndexAtPos(int posX, int posY) {
        if (this.isInside(posX, posY)) {
            int line = 0;
            if (posY != 0) {
                line = MathHelper.func_76141_d((float)((float)(posY - this.y) / (float)this.fontRenderer.field_78288_b));
            }
            return line;
        }
        return -1;
    }

    public boolean isInside(int posX, int posY) {
        return posX >= this.x & posY >= this.y & posX < this.x + this.width & posY < this.y + this.height;
    }

    private void openWebLink(URI url) {
        try {
            Class<?> oclass = Class.forName("java.awt.Desktop");
            Object object = oclass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            oclass.getMethod("browse", URI.class).invoke(object, url);
        }
        catch (Throwable throwable1) {
            Throwable throwable = throwable1.getCause();
            ModLogger.log(Level.ERROR, String.format("Couldn't open link: {}", throwable == null ? "<UNKNOWN>" : throwable.getMessage()));
        }
    }
}

