/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.globallibrary;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import moe.plushie.armourers_workshop.client.gui.controls.GuiPanel;
import moe.plushie.armourers_workshop.client.gui.controls.ModGuiContainer;
import moe.plushie.armourers_workshop.client.gui.globallibrary.panels.GuiGlobalLibraryPanelHeader;
import moe.plushie.armourers_workshop.client.gui.globallibrary.panels.GuiGlobalLibraryPanelHome;
import moe.plushie.armourers_workshop.client.gui.globallibrary.panels.GuiGlobalLibraryPanelInfo;
import moe.plushie.armourers_workshop.client.gui.globallibrary.panels.GuiGlobalLibraryPanelJoin;
import moe.plushie.armourers_workshop.client.gui.globallibrary.panels.GuiGlobalLibraryPanelModeration;
import moe.plushie.armourers_workshop.client.gui.globallibrary.panels.GuiGlobalLibraryPanelProfile;
import moe.plushie.armourers_workshop.client.gui.globallibrary.panels.GuiGlobalLibraryPanelSearchBox;
import moe.plushie.armourers_workshop.client.gui.globallibrary.panels.GuiGlobalLibraryPanelSearchResults;
import moe.plushie.armourers_workshop.client.gui.globallibrary.panels.GuiGlobalLibraryPanelSkinEdit;
import moe.plushie.armourers_workshop.client.gui.globallibrary.panels.GuiGlobalLibraryPanelSkinInfo;
import moe.plushie.armourers_workshop.client.gui.globallibrary.panels.GuiGlobalLibraryPanelUpload;
import moe.plushie.armourers_workshop.client.gui.globallibrary.panels.GuiGlobalLibraryPanelUserSkins;
import moe.plushie.armourers_workshop.common.addons.ModAddonManager;
import moe.plushie.armourers_workshop.common.inventory.ContainerGlobalSkinLibrary;
import moe.plushie.armourers_workshop.common.inventory.slot.SlotHidable;
import moe.plushie.armourers_workshop.common.library.global.auth.PlushieAuth;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityGlobalSkinLibrary;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiGlobalLibrary
extends ModGuiContainer<ContainerGlobalSkinLibrary> {
    public final TileEntityGlobalSkinLibrary tileEntity;
    public final EntityPlayer player;
    public ArrayList<GuiPanel> panelList;
    private int oldMouseX;
    private int oldMouseY;
    public Executor jsonDownloadExecutor = Executors.newFixedThreadPool(2);
    public Executor uploadExecutor = Executors.newFixedThreadPool(1);
    private static final int PADDING = 5;
    private boolean isNEIVisible;
    public GuiGlobalLibraryPanelHeader panelHeader;
    public GuiGlobalLibraryPanelSearchBox panelSearchBox;
    public GuiGlobalLibraryPanelHome panelHome;
    public GuiGlobalLibraryPanelSearchResults panelSearchResults;
    public GuiGlobalLibraryPanelSkinInfo panelSkinInfo;
    public GuiGlobalLibraryPanelUpload panelUpload;
    public GuiGlobalLibraryPanelJoin panelJoinBeta;
    public GuiGlobalLibraryPanelUserSkins panelUserSkins;
    public GuiGlobalLibraryPanelSkinEdit panelSkinEdit;
    public GuiGlobalLibraryPanelInfo panelInfo;
    public GuiGlobalLibraryPanelModeration panelModeration;
    public GuiGlobalLibraryPanelProfile panelProfile;
    private Screen screen;

    public GuiGlobalLibrary(TileEntityGlobalSkinLibrary tileEntity, InventoryPlayer inventoryPlayer) {
        super(new ContainerGlobalSkinLibrary(inventoryPlayer, tileEntity));
        this.tileEntity = tileEntity;
        this.player = Minecraft.func_71410_x().field_71439_g;
        this.panelList = new ArrayList();
        this.panelHeader = new GuiGlobalLibraryPanelHeader((GuiScreen)this, 0, 0, this.field_146294_l, 26);
        this.panelList.add(this.panelHeader);
        this.panelSearchBox = new GuiGlobalLibraryPanelSearchBox(this, 0, 25, this.field_146294_l, 23);
        this.panelList.add(this.panelSearchBox);
        this.panelHome = new GuiGlobalLibraryPanelHome((GuiScreen)this, 2, 136, this.field_146294_l / 2 - 5, this.field_146295_m - 141);
        this.panelList.add(this.panelHome);
        this.panelSearchResults = new GuiGlobalLibraryPanelSearchResults((GuiScreen)this, 5, 5, 100, 100);
        this.panelList.add(this.panelSearchResults);
        this.panelSkinInfo = new GuiGlobalLibraryPanelSkinInfo((GuiScreen)this, 5, 5, 100, 100);
        this.panelList.add(this.panelSkinInfo);
        this.panelUpload = new GuiGlobalLibraryPanelUpload((GuiScreen)this, 5, 5, 100, 100);
        this.panelList.add(this.panelUpload);
        this.panelJoinBeta = new GuiGlobalLibraryPanelJoin((GuiScreen)this, 5, 5, 100, 100);
        this.panelList.add(this.panelJoinBeta);
        this.panelUserSkins = new GuiGlobalLibraryPanelUserSkins((GuiScreen)this, 5, 5, 100, 100);
        this.panelList.add(this.panelUserSkins);
        this.panelSkinEdit = new GuiGlobalLibraryPanelSkinEdit((GuiScreen)this, 5, 5, 100, 100);
        this.panelList.add(this.panelSkinEdit);
        this.panelInfo = new GuiGlobalLibraryPanelInfo((GuiScreen)this);
        this.panelList.add(this.panelInfo);
        this.panelModeration = new GuiGlobalLibraryPanelModeration((GuiScreen)this);
        this.panelList.add(this.panelModeration);
        this.panelProfile = new GuiGlobalLibraryPanelProfile((GuiScreen)this);
        this.panelList.add(this.panelProfile);
        this.screen = Screen.HOME;
        this.isNEIVisible = ModAddonManager.addonNEI.isVisible();
        if (!PlushieAuth.startedRemoteUserCheck()) {
            PlushieAuth.doRemoteUserCheck();
        }
    }

    @Override
    public void func_73866_w_() {
        ScaledResolution reso = new ScaledResolution(this.field_146297_k);
        this.field_146999_f = reso.func_78326_a();
        this.field_147000_g = reso.func_78328_b();
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.setupPanels();
        for (int i = 0; i < this.panelList.size(); ++i) {
            this.panelList.get(i).initGui();
        }
        if (this.screen == Screen.HOME) {
            this.panelHome.updateSkinPanels();
        }
    }

    public void setSlotVisibility(boolean visible) {
        for (int x = 0; x < 9; ++x) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(x);
            if (!(slot instanceof SlotHidable)) continue;
            ((SlotHidable)slot).setVisible(visible);
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                Slot slot = (Slot)this.field_147002_h.field_75151_b.get(x + y * 9 + 9);
                if (!(slot instanceof SlotHidable)) continue;
                ((SlotHidable)slot).setVisible(visible);
            }
        }
        SlotHidable slot = this.getInputSlot();
        if (slot instanceof SlotHidable) {
            slot.setVisible(visible);
        }
        if ((slot = this.getOutputSlot()) instanceof SlotHidable) {
            slot.setVisible(visible);
        }
    }

    public void setPlayerSlotLocation(int xPos, int yPos) {
        for (int x = 0; x < 9; ++x) {
            Slot slot = (Slot)this.field_147002_h.field_75151_b.get(x);
            if (!(slot instanceof SlotHidable)) continue;
            ((SlotHidable)slot).setDisplayPosition(xPos + x * 18, yPos + 58);
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                Slot slot = (Slot)this.field_147002_h.field_75151_b.get(x + y * 9 + 9);
                if (!(slot instanceof SlotHidable)) continue;
                ((SlotHidable)slot).setDisplayPosition(xPos + x * 18, yPos + y * 18);
            }
        }
    }

    public void setInputSlotLocation(int xPos, int yPos) {
        SlotHidable slot = this.getInputSlot();
        if (slot instanceof SlotHidable) {
            slot.setDisplayPosition(xPos, yPos);
        }
    }

    public void setOutputSlotLocation(int xPos, int yPos) {
        SlotHidable slot = this.getOutputSlot();
        if (slot instanceof SlotHidable) {
            slot.setDisplayPosition(xPos, yPos);
        }
    }

    public SlotHidable getInputSlot() {
        return (SlotHidable)((Object)this.field_147002_h.field_75151_b.get(36));
    }

    public SlotHidable getOutputSlot() {
        return (SlotHidable)((Object)this.field_147002_h.field_75151_b.get(37));
    }

    @Override
    public ContainerGlobalSkinLibrary getContainer() {
        return (ContainerGlobalSkinLibrary)this.field_147002_h;
    }

    private void setupPanels() {
        for (int i = 0; i < this.panelList.size(); ++i) {
            this.panelList.get(i).setVisible(false);
        }
        this.setSlotVisibility(false);
        int yOffset = 1;
        this.panelHeader.setPosition(1, 1).setSize(this.field_146294_l - 2, 26);
        this.panelHeader.setVisible(true);
        yOffset += this.panelHeader.getHeight() + 1;
        int neiBump = 0;
        if (this.isNEIVisible) {
            neiBump = 18;
        }
        if (ModAddonManager.addonJEI.isModLoaded()) {
            neiBump = 24;
        }
        switch (this.screen) {
            case HOME: {
                this.panelSearchBox.setPosition(1, yOffset).setSize(this.field_146294_l - 2, 23);
                this.panelSearchBox.setVisible(true);
                this.panelHome.setPosition(1, yOffset += this.panelSearchBox.getHeight() + 1).setSize(this.field_146294_l - 2, this.field_146295_m - yOffset - 1 - neiBump);
                this.panelHome.setVisible(true);
                break;
            }
            case SEARCH: {
                this.panelSearchBox.setPosition(1, yOffset).setSize(this.field_146294_l - 2, 23);
                this.panelSearchBox.setVisible(true);
                this.panelSearchResults.setPosition(1, yOffset += this.panelSearchBox.getHeight() + 1).setSize(this.field_146294_l - 2, this.field_146295_m - yOffset - 1 - neiBump);
                this.panelSearchResults.setVisible(true);
                break;
            }
            case SKIN_INFO: {
                this.panelSearchBox.setPosition(1, yOffset).setSize(this.field_146294_l - 2, 23);
                this.panelSearchBox.setVisible(true);
                this.panelSkinInfo.setPosition(1, yOffset += this.panelSearchBox.getHeight() + 1).setSize(this.field_146294_l - 2, this.field_146295_m - yOffset - 1 - neiBump);
                this.panelSkinInfo.setVisible(true);
                break;
            }
            case UPLOAD: {
                this.panelUpload.setPosition(1, yOffset).setSize(this.field_146294_l - 2, this.field_146295_m - yOffset - 1 - neiBump);
                this.panelUpload.setVisible(true);
                this.setSlotVisibility(true);
                break;
            }
            case JOIN: {
                this.panelJoinBeta.setPosition(1, yOffset).setSize(this.field_146294_l - 2, this.field_146295_m - yOffset - 1 - neiBump);
                this.panelJoinBeta.setVisible(true);
                break;
            }
            case USER_SKINS: {
                this.panelSearchBox.setPosition(1, yOffset).setSize(this.field_146294_l - 2, 23);
                this.panelSearchBox.setVisible(true);
                this.panelUserSkins.setPosition(1, yOffset += this.panelSearchBox.getHeight() + 1).setSize(this.field_146294_l - 2, this.field_146295_m - yOffset - 1 - neiBump);
                this.panelUserSkins.setVisible(true);
                break;
            }
            case SKIN_EDIT: {
                this.panelSearchBox.setPosition(1, yOffset).setSize(this.field_146294_l - 2, 23);
                this.panelSearchBox.setVisible(true);
                this.panelSkinEdit.setPosition(1, yOffset += this.panelSearchBox.getHeight() + 1).setSize(this.field_146294_l - 2, this.field_146295_m - yOffset - 1 - neiBump);
                this.panelSkinEdit.setVisible(true);
                break;
            }
            case FAVOURITES: {
                this.panelSearchBox.setPosition(1, yOffset).setSize(this.field_146294_l - 2, this.field_146295_m - yOffset - 1 - neiBump);
                this.panelSearchBox.setVisible(true);
                yOffset += this.panelSearchBox.getHeight() + 1;
                break;
            }
            case INFO: {
                this.panelInfo.setPosition(1, yOffset).setSize(this.field_146294_l - 2, this.field_146295_m - yOffset - 1 - neiBump);
                this.panelInfo.setVisible(true);
                break;
            }
            case MODERATION: {
                this.panelModeration.setPosition(1, yOffset).setSize(this.field_146294_l - 2, this.field_146295_m - yOffset - 1 - neiBump);
                this.panelModeration.setVisible(true);
                break;
            }
            case PROFILE: {
                this.panelProfile.setPosition(1, yOffset).setSize(this.field_146294_l - 2, this.field_146295_m - yOffset - 1 - neiBump);
                this.panelProfile.setVisible(true);
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        PlushieAuth.updateAccessToken();
        for (GuiPanel panel : this.panelList) {
            panel.update();
        }
    }

    public void switchScreen(Screen screen) {
        this.screen = screen;
        this.setupPanels();
        for (GuiPanel panel : this.panelList) {
            panel.initGui();
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        if (!this.isDialogOpen()) {
            for (GuiPanel panel : this.panelList) {
                if (!panel.mouseClicked(mouseX, mouseY, button)) continue;
                return;
            }
        }
        super.func_73864_a(mouseX, mouseY, button);
    }

    @Override
    protected void func_146286_b(int mouseX, int mouseY, int state) {
        if (!this.isDialogOpen()) {
            for (GuiPanel panel : this.panelList) {
                panel.mouseMovedOrUp(mouseX, mouseY, state);
            }
        }
        super.func_146286_b(mouseX, mouseY, state);
    }

    @Override
    protected void func_73869_a(char c, int keycode) throws IOException {
        boolean keyTyped = false;
        if (!this.isDialogOpen()) {
            for (GuiPanel panel : this.panelList) {
                if (!panel.keyTyped(c, keycode)) continue;
                keyTyped = true;
            }
        }
        if (!keyTyped) {
            super.func_73869_a(c, keycode);
        }
        this.checkNEIVisibility();
    }

    private void checkNEIVisibility() {
        if (this.isNEIVisible != ModAddonManager.addonNEI.isVisible()) {
            this.isNEIVisible = !this.isNEIVisible;
            this.func_73866_w_();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected void func_146976_a(float partialTickTime, int mouseX, int mouseY) {
        GlStateManager.func_179097_i();
        GlStateManager.func_179123_a();
        for (GuiPanel panel : this.panelList) {
            panel.drawBackground(mouseX, mouseY, partialTickTime);
        }
        GlStateManager.func_179099_b();
        GlStateManager.func_179123_a();
        for (GuiPanel panel : this.panelList) {
            panel.draw(mouseX, mouseY, partialTickTime);
        }
        GlStateManager.func_179099_b();
        GlStateManager.func_179123_a();
        for (GuiPanel panel : this.panelList) {
            panel.drawForeground(mouseX, mouseY, partialTickTime);
        }
        GlStateManager.func_179099_b();
        GlStateManager.func_179126_j();
    }

    public String getGuiName() {
        return this.getName();
    }

    public void gotSkinFromServer(Skin skin) {
        this.panelUpload.uploadSkin(skin);
    }

    @Override
    public String getName() {
        return "global-skin-library";
    }

    public static enum Screen {
        HOME,
        SEARCH,
        UPLOAD,
        SKIN_INFO,
        USER_SKINS,
        FAVOURITES,
        JOIN,
        SKIN_EDIT,
        INFO,
        MODERATION,
        PROFILE;

    }
}

