/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.globallibrary.panels;

import com.google.common.util.concurrent.FutureCallback;
import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.controls.GuiCustomLabel;
import moe.plushie.armourers_workshop.client.gui.controls.GuiPanel;
import moe.plushie.armourers_workshop.client.gui.globallibrary.GuiGlobalLibrary;
import moe.plushie.armourers_workshop.common.library.global.task.GlobalTaskInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiGlobalLibraryPanelInfo
extends GuiPanel {
    private static final String URL_DISCORD = "https://discord.gg/5Z3KKvU";
    private static final String URL_GITHUB = "https://github.com/RiskyKen/Armourers-Workshop";
    private static final String URL_REDDIT = "https://www.reddit.com/r/ArmourersWorkshop/";
    private static final String URL_DONATION = "https://ko-fi.com/riskyken";
    private final String guiName;
    private GuiCustomLabel statsText;
    private GlobalTaskInfo.TaskData stats = null;
    private String failMessage = null;

    public GuiGlobalLibraryPanelInfo(GuiScreen parent) {
        super(parent, 0, 0, 1, 1);
        this.guiName = ((GuiGlobalLibrary)parent).getGuiName() + ".panel.info";
    }

    @Override
    public void initGui() {
        super.initGui();
        this.statsText = new GuiCustomLabel(this.fontRenderer, this.x + 2, this.y + 2, this.width - 4, this.height - 4);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float partialTickTime) {
        if (!this.visible) {
            return;
        }
        this.func_73733_a(this.x, this.y, this.x + this.width, this.y + this.height, -1072689136, -804253680);
    }

    public void updateInfo() {
        this.stats = null;
        this.failMessage = null;
        new GlobalTaskInfo().createTaskAndRun(new FutureCallback<GlobalTaskInfo.TaskData>(){

            public void onSuccess(final GlobalTaskInfo.TaskData result) {
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        GuiGlobalLibraryPanelInfo.this.stats = result;
                    }
                });
            }

            public void onFailure(Throwable t) {
                t.printStackTrace();
                GuiGlobalLibraryPanelInfo.this.failMessage = t.getMessage();
            }
        });
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (!this.visible | !this.enabled) {
            return false;
        }
        this.statsText.mouseClick(mouseX, mouseY, button);
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY, float partialTickTime) {
        if (!this.visible) {
            return;
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        this.statsText.clearText();
        this.statsText.addLine(GuiHelper.getLocalizedControlName(this.guiName, "name", new Object[0]));
        this.statsText.addNewLine();
        if (this.stats != null) {
            this.statsText.addLine(GuiHelper.getLocalizedControlName(this.guiName, "total_skins", this.stats.getTotalSkin()));
            this.statsText.addNewLine();
            this.statsText.addLine(GuiHelper.getLocalizedControlName(this.guiName, "download_count", this.stats.getDownloadsLastHour(), this.stats.getDownloadsLastDay(), this.stats.getDownloadsLastWeek()));
            this.statsText.addNewLine();
        } else if (this.failMessage != null) {
            this.statsText.addLine(GuiHelper.getLocalizedControlName(this.guiName, "error_getting_stats", new Object[0]));
            this.statsText.addLine(this.failMessage);
        } else {
            this.statsText.addLine(GuiHelper.getLocalizedControlName(this.guiName, "loading", new Object[0]));
            this.statsText.addNewLine();
            this.statsText.addNewLine();
            this.statsText.addNewLine();
        }
        this.statsText.addNewLine();
        this.statsText.addText(GuiHelper.getLocalizedControlName(this.guiName, "links", new Object[0]));
        this.statsText.addNewLine();
        this.statsText.addNewLine();
        this.statsText.addText(GuiHelper.getLocalizedControlName(this.guiName, "link.discord", new Object[0]) + " ");
        this.statsText.addUrl(URL_DISCORD);
        this.statsText.addNewLine();
        this.statsText.addNewLine();
        this.statsText.addText(GuiHelper.getLocalizedControlName(this.guiName, "link.github", new Object[0]) + " ");
        this.statsText.addUrl(URL_GITHUB);
        this.statsText.addNewLine();
        this.statsText.addNewLine();
        this.statsText.addText(GuiHelper.getLocalizedControlName(this.guiName, "link.reddit", new Object[0]) + " ");
        this.statsText.addUrl(URL_REDDIT);
        this.statsText.addNewLine();
        this.statsText.addNewLine();
        this.statsText.addNewLine();
        this.statsText.addText(GuiHelper.getLocalizedControlName(this.guiName, "link.donation", new Object[0]) + " ");
        this.statsText.addUrl(URL_DONATION);
        this.statsText.addNewLine();
        this.statsText.addNewLine();
        this.statsText.draw(mouseX, mouseY);
    }
}

