/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.init.items;

import java.util.List;
import moe.plushie.armourers_workshop.client.render.item.RenderItemMannequin;
import moe.plushie.armourers_workshop.common.config.ConfigHandler;
import moe.plushie.armourers_workshop.common.data.type.TextureType;
import moe.plushie.armourers_workshop.common.init.entities.EntityMannequin;
import moe.plushie.armourers_workshop.common.init.items.AbstractModItem;
import moe.plushie.armourers_workshop.common.init.items.ModItems;
import moe.plushie.armourers_workshop.utils.TranslateUtils;
import moe.plushie.armourers_workshop.utils.TrigUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMannequin
extends AbstractModItem {
    private static final String TAG_TEXTURE_DATA = "texture_data";
    private static final String TAG_SCALE = "scale";

    public ItemMannequin() {
        super("mannequin");
        this.setSortPriority(199);
        this.func_77625_d(1);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this));
            if (!ConfigHandler.hideDollFromCreativeTabs) {
                items.add((Object)ItemMannequin.create((EntityMannequin.TextureData)null, 0.5f));
            }
            if (!ConfigHandler.hideGiantFromCreativeTabs) {
                items.add((Object)ItemMannequin.create((EntityMannequin.TextureData)null, 2.0f));
            }
        }
    }

    @Override
    protected String getModdedUnlocalizedName(String unlocalizedName, ItemStack stack) {
        String name = unlocalizedName.substring(unlocalizedName.indexOf(".") + 1);
        String moddedUnlocalizedName = "item." + "armourers_workshop".toLowerCase() + ":" + name;
        float scale = ItemMannequin.getScale(stack);
        if (scale <= 0.5f) {
            moddedUnlocalizedName = moddedUnlocalizedName + ".small";
        }
        if (scale >= 2.0f) {
            moddedUnlocalizedName = moddedUnlocalizedName + ".big";
        }
        return moddedUnlocalizedName;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            EntityMannequin.TextureData textureData = ItemMannequin.getTextureData(stack);
            if (textureData.getTextureType() == TextureType.USER) {
                tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.user", textureData.getProfile().getName()));
            }
            if (textureData.getTextureType() == TextureType.URL) {
                tooltip.add(TranslateUtils.translate("item.armourers_workshop:rollover.url", textureData.getUrl()));
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public static ItemStack create(EntityMannequin.TextureData textureData, float scale) {
        ItemStack itemStack = new ItemStack(ModItems.MANNEQUIN);
        itemStack.func_77982_d(new NBTTagCompound());
        if (textureData != null) {
            ItemMannequin.setTextureData(itemStack, textureData);
        }
        ItemMannequin.setScale(itemStack, scale);
        return itemStack;
    }

    public static ItemStack create(EntityPlayer player, float scale) {
        if (player != null) {
            return ItemMannequin.create(new EntityMannequin.TextureData(player.func_146103_bH()), scale);
        }
        return new ItemStack(ModItems.MANNEQUIN);
    }

    public static void setTextureData(ItemStack itemStack, EntityMannequin.TextureData textureData) {
        if (itemStack.func_190926_b()) {
            return;
        }
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound compoundTextureData = new NBTTagCompound();
        textureData.writeToNBT(compoundTextureData);
        itemStack.func_77978_p().func_74782_a(TAG_TEXTURE_DATA, (NBTBase)compoundTextureData);
    }

    public static EntityMannequin.TextureData getTextureData(ItemStack itemStack) {
        EntityMannequin.TextureData textureData = new EntityMannequin.TextureData();
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_150297_b(TAG_TEXTURE_DATA, 10)) {
            textureData.readFromNBT(itemStack.func_77978_p().func_74775_l(TAG_TEXTURE_DATA));
        }
        return textureData;
    }

    public static void setScale(ItemStack itemStack, float scale) {
        if (itemStack.func_190926_b()) {
            return;
        }
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74776_a(TAG_SCALE, scale);
    }

    public static float getScale(ItemStack itemStack) {
        if (!itemStack.func_190926_b() && itemStack.func_77942_o() && itemStack.func_77978_p().func_150297_b(TAG_SCALE, 5)) {
            return itemStack.func_77978_p().func_74760_g(TAG_SCALE);
        }
        return 1.0f;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (facing == EnumFacing.UP) {
            ItemStack itemStack = player.func_184586_b(hand);
            if (!worldIn.field_72995_K) {
                pos = pos.func_177972_a(facing);
                EntityMannequin entityMannequin = new EntityMannequin(worldIn);
                if (player.func_70093_af()) {
                    int l = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 16.0f / 360.0f) + 0.5)) & 0xF;
                    entityMannequin.func_70107_b((float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f);
                    entityMannequin.setRotation((float)l * 22.5f + 180.0f);
                } else {
                    entityMannequin.func_70107_b((float)pos.func_177958_n() + hitX, pos.func_177956_o(), (float)pos.func_177952_p() + hitZ);
                    double angle = TrigUtils.getAngleDegrees(player.field_70165_t, player.field_70161_v, (float)pos.func_177958_n() + hitX, (float)pos.func_177952_p() + hitZ) + 90.0;
                    entityMannequin.setRotation((float)angle);
                }
                if (itemStack.func_77942_o()) {
                    EntityMannequin.TextureData textureData = ItemMannequin.getTextureData(itemStack);
                    float scale = ItemMannequin.getScale(itemStack);
                    entityMannequin.setTextureData(textureData, true);
                    entityMannequin.setScale(scale);
                }
                worldIn.func_72838_d((Entity)entityMannequin);
                itemStack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        super.registerModels();
        this.setTileEntityItemStackRenderer(new RenderItemMannequin());
    }
}

