/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.common.painting.IPantable;
import moe.plushie.armourers_workshop.api.common.painting.IPantableBlock;
import moe.plushie.armourers_workshop.api.common.skin.cubes.ICubeColour;
import moe.plushie.armourers_workshop.common.skin.cubes.CubeColour;
import moe.plushie.armourers_workshop.utils.UtilItems;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public final class BlockUtils {
    private BlockUtils() {
    }

    public static int determineOrientation(BlockPos pos, EntityLivingBase entity) {
        return BlockUtils.determineOrientation(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), entity);
    }

    public static int determineOrientation(int x, int y, int z, EntityLivingBase entity) {
        int l;
        if (MathHelper.func_76135_e((float)((float)entity.field_70165_t - (float)x)) < 2.0f && MathHelper.func_76135_e((float)((float)entity.field_70161_v - (float)z)) < 2.0f) {
            double d0 = entity.field_70163_u + (double)entity.func_70047_e() - entity.func_70033_W();
            if (d0 - (double)y > 2.0) {
                return 1;
            }
            if ((double)y - d0 > 0.0) {
                return 0;
            }
        }
        return (l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3) == 0 ? 2 : (l == 1 ? 5 : (l == 2 ? 3 : (l == 3 ? 4 : 0)));
    }

    public static int determineOrientationSide(EntityLivingBase entity) {
        int rotation = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        rotation = BlockUtils.determineOrientationSideMeta(rotation);
        return rotation;
    }

    public static int determineOrientationSideMeta(int metadata) {
        return metadata == 0 ? 3 : (metadata == 3 ? 5 : (metadata == 1 ? 4 : 2));
    }

    public static EnumFacing determineDirectionSideMeta(int metadata) {
        return EnumFacing.func_82600_a((int)BlockUtils.determineOrientationSideMeta(metadata));
    }

    public static EnumFacing determineDirectionSide(EntityLivingBase entity) {
        return EnumFacing.func_82600_a((int)BlockUtils.determineOrientationSide(entity));
    }

    public static ICubeColour getColourFromTileEntity(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null & te instanceof IPantable) {
            return ((IPantable)te).getColour();
        }
        return new CubeColour();
    }

    public static void dropInventoryBlocks(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null & te instanceof IInventory) {
            BlockUtils.dropInventoryBlocks(world, (IInventory)te, pos);
        }
    }

    public static void dropInventoryBlocks(World world, IInventory inventory, BlockPos pos) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70304_b(i);
            if (stack == null) continue;
            UtilItems.spawnItemInWorld(world, pos, stack);
        }
    }

    public static ArrayList<BlockPos> findTouchingBlockFaces(World world, BlockPos pos, EnumFacing facing, int radius, boolean restrictPlane) {
        ArrayList<BlockPos> blockFaces = new ArrayList<BlockPos>();
        ArrayList<BlockPos> openList = new ArrayList<BlockPos>();
        ArrayList<BlockPos> closedList = new ArrayList<BlockPos>();
        BlockPos startPos = pos.func_177972_a(facing);
        openList.add(pos.func_177972_a(facing));
        EnumFacing[] sides = EnumFacing.field_82609_l;
        boolean first = true;
        while (!openList.isEmpty()) {
            BlockPos loc = (BlockPos)openList.get(0);
            openList.remove(0);
            IBlockState state = world.func_180495_p(loc);
            if (state.func_177230_c() instanceof IPantableBlock) {
                if (restrictPlane) {
                    if (loc.func_177958_n() * facing.func_82601_c() == pos.func_177958_n() * facing.func_82601_c() && loc.func_177956_o() * facing.func_96559_d() == pos.func_177956_o() * facing.func_96559_d() && loc.func_177952_p() * facing.func_82599_e() == pos.func_177952_p() * facing.func_82599_e()) {
                        blockFaces.add(loc);
                    }
                } else {
                    blockFaces.add(loc);
                }
            }
            if (world.func_175623_d(loc)) {
                for (int i = 0; i < sides.length; ++i) {
                    BlockPos sideLoc = loc.func_177972_a(EnumFacing.values()[i]);
                    IBlockState stateSide = world.func_180495_p(sideLoc);
                    if (closedList.contains(sideLoc)) continue;
                    closedList.add(sideLoc);
                    boolean validCube = false;
                    for (int ix = 0; ix < 3; ++ix) {
                        for (int iy = 0; iy < 3; ++iy) {
                            for (int iz = 0; iz < 3; ++iz) {
                                IBlockState stateValid = world.func_180495_p(sideLoc.func_177982_a(ix - 1, iy - 1, iz - 1));
                                if (!(stateValid.func_177230_c() instanceof IPantableBlock)) continue;
                                validCube = true;
                            }
                        }
                    }
                    if (!(sideLoc.func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) < (double)radius & validCube)) continue;
                    openList.add(sideLoc);
                }
            }
            if (closedList.size() <= 5000) continue;
            break;
        }
        return blockFaces;
    }
}

