/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.ModOptions;
import org.orecruncher.dsurround.client.handlers.EffectHandlerBase;
import org.orecruncher.dsurround.client.handlers.EnvironStateHandler;
import org.orecruncher.dsurround.client.handlers.SoundEffectHandler;
import org.orecruncher.dsurround.client.sound.SoundInstance;
import org.orecruncher.dsurround.client.sound.Sounds;
import org.orecruncher.dsurround.client.weather.Weather;
import org.orecruncher.dsurround.event.DiagnosticEvent;
import org.orecruncher.dsurround.event.ThunderEvent;

@SideOnly(value=Side.CLIENT)
public class WeatherHandler
extends EffectHandlerBase {
    private int timer = 0;

    public WeatherHandler() {
        super("Weather");
    }

    @Override
    public boolean doTick(int tick) {
        return this.timer > 0;
    }

    @Override
    public void onConnect() {
        this.timer = 0;
    }

    @Override
    public void process(@Nonnull EntityPlayer player2) {
        --this.timer;
        player2.func_130014_f_().func_175702_c(2);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public void onThunderEvent(@Nonnull ThunderEvent event) {
        if (!ModOptions.rain.allowBackgroundThunder || EnvironStateHandler.EnvironState.getDimensionId() != event.dimId) {
            return;
        }
        SoundInstance thunder = Sounds.THUNDER.createSoundAt(event.location).setVolume(ModOptions.sound.thunderVolume);
        SoundEffectHandler.INSTANCE.playSound(thunder);
        if (event.doFlash) {
            this.timer = 2;
        }
    }

    @SubscribeEvent
    public void diagnostic(@Nonnull DiagnosticEvent.Gather event) {
        event.output.add(Weather.diagnostic());
    }
}

