/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.globallibrary.panels;

import com.google.common.util.concurrent.FutureCallback;
import java.awt.Rectangle;
import moe.plushie.armourers_workshop.client.gui.GuiHelper;
import moe.plushie.armourers_workshop.client.gui.controls.GuiCustomLabel;
import moe.plushie.armourers_workshop.client.gui.controls.GuiIconButton;
import moe.plushie.armourers_workshop.client.gui.controls.GuiPanel;
import moe.plushie.armourers_workshop.client.gui.globallibrary.GuiGlobalLibrary;
import moe.plushie.armourers_workshop.common.library.global.GlobalSkinLibraryUtils;
import moe.plushie.armourers_workshop.common.library.global.task.GlobalTaskBetaJoin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiGlobalLibraryPanelJoin
extends GuiPanel {
    private static final ResourceLocation TEXTURE_BUTTONS = new ResourceLocation("armourers_workshop:textures/gui/_controls/buttons.png");
    private static final int MAX_PAGES = 5;
    private final String guiName;
    private Rectangle rectangleRules;
    private GuiIconButton buttonPrevious;
    private GuiIconButton buttonNext;
    private GuiButtonExt buttonJoin;
    private GuiCustomLabel statsText;
    private boolean joining = false;
    private String joinFailMessage = null;
    private int messagePageIndex = 0;

    public GuiGlobalLibraryPanelJoin(GuiScreen parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
        this.guiName = ((GuiGlobalLibrary)parent).getGuiName() + ".join";
    }

    @Override
    public void initGui() {
        super.initGui();
        this.buttonList.clear();
        int recWidth = 318;
        int recHeight = 180;
        this.rectangleRules = new Rectangle(this.x + this.width / 2 - recWidth / 2, this.y + this.height / 2 - recHeight / 2, recWidth, recHeight);
        this.buttonPrevious = new GuiIconButton(this.parent, 0, this.rectangleRules.x + 5, this.rectangleRules.y + recHeight - 16 - 5, 16, 16, I18n.func_135052_a((String)"inventory.armourers_workshop:common.button.previous", (Object[])new Object[0]), TEXTURE_BUTTONS);
        this.buttonPrevious.setIconLocation(208, 80, 16, 16);
        this.buttonPrevious.setDrawButtonBackground(false);
        this.buttonNext = new GuiIconButton(this.parent, 0, this.rectangleRules.x + recWidth - 16 - 5, this.rectangleRules.y + recHeight - 16 - 5, 16, 16, I18n.func_135052_a((String)"inventory.armourers_workshop:common.button.next", (Object[])new Object[0]), TEXTURE_BUTTONS);
        this.buttonNext.setIconLocation(208, 96, 16, 16);
        this.buttonNext.setDrawButtonBackground(false);
        this.buttonJoin = new GuiButtonExt(0, this.rectangleRules.x + recWidth / 2 - 70, this.rectangleRules.y + recHeight - 16 - 5, 140, 16, GuiHelper.getLocalizedControlName(this.guiName, "button.join", new Object[0]));
        this.buttonJoin.field_146125_m = false;
        this.statsText = new GuiCustomLabel(this.fontRenderer, this.rectangleRules.x + 5, this.rectangleRules.y + 5, recWidth - 10, recHeight - 75 - 5);
        this.statsText.setColour(0x333333);
        this.buttonList.add(this.buttonPrevious);
        this.buttonList.add(this.buttonNext);
        this.buttonList.add(this.buttonJoin);
    }

    @Override
    public void update() {
        this.buttonPrevious.field_146124_l = this.messagePageIndex > 0;
        this.buttonNext.field_146124_l = this.messagePageIndex < 4;
        this.buttonJoin.field_146125_m = this.messagePageIndex == 4;
    }

    private void joinedFailed(String reason) {
        this.buttonJoin.field_146124_l = true;
        this.joining = false;
        this.joinFailMessage = reason;
    }

    private void joinedBeta() {
        this.buttonJoin.field_146124_l = true;
        this.joining = false;
        this.joinFailMessage = "";
        ((GuiGlobalLibrary)this.parent).switchScreen(GuiGlobalLibrary.Screen.HOME);
    }

    @Override
    public boolean keyTyped(char c, int keycode) {
        if (!this.visible | !this.enabled) {
            return false;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (!this.visible | !this.enabled) {
            return false;
        }
        this.statsText.mouseClick(mouseX, mouseY, button);
        boolean clicked = super.mouseClicked(mouseX, mouseY, button);
        return clicked;
    }

    @Override
    protected void actionPerformed(GuiButton button) {
        if (button == this.buttonPrevious) {
            --this.messagePageIndex;
            this.messagePageIndex = MathHelper.func_76125_a((int)this.messagePageIndex, (int)0, (int)4);
        }
        if (button == this.buttonNext) {
            ++this.messagePageIndex;
            this.messagePageIndex = MathHelper.func_76125_a((int)this.messagePageIndex, (int)0, (int)4);
        }
        if (button == this.buttonJoin) {
            this.join();
        }
    }

    private void join() {
        this.buttonJoin.field_146124_l = false;
        this.joinFailMessage = "";
        new GlobalTaskBetaJoin().createTaskAndRun(new FutureCallback<GlobalTaskBetaJoin.BetaJoinResult>(){

            public void onSuccess(final GlobalTaskBetaJoin.BetaJoinResult result) {
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        switch (result.getJoinResult()) {
                            case JOINED: {
                                GuiGlobalLibraryPanelJoin.this.joinedBeta();
                                break;
                            }
                            case ALREADY_JOINED: {
                                GuiGlobalLibraryPanelJoin.this.joinedFailed(result.getMessage());
                                break;
                            }
                            case MINECRAFT_AUTH_FAIL: {
                                GuiGlobalLibraryPanelJoin.this.joinedFailed(result.getMessage());
                                break;
                            }
                            case JOIN_FAILED: {
                                GuiGlobalLibraryPanelJoin.this.joinedFailed(result.getMessage());
                            }
                        }
                    }
                });
            }

            public void onFailure(final Throwable t) {
                t.printStackTrace();
                Minecraft.func_71410_x().func_152344_a(new Runnable(){

                    @Override
                    public void run() {
                        GuiGlobalLibraryPanelJoin.this.joinedFailed(t.toString());
                    }
                });
            }
        });
    }

    @Override
    public void draw(int mouseX, int mouseY, float partialTickTime) {
        boolean validJava;
        if (!this.visible) {
            return;
        }
        this.func_73733_a(this.x, this.y, this.x + this.width, this.y + this.height, -1072689136, -804253680);
        int textureWidth = 128;
        int textureHeight = 128;
        int borderSize = 4;
        this.mc.field_71446_o.func_110577_a(new ResourceLocation("armourers_workshop:textures/gui/common.png"));
        GuiUtils.drawContinuousTexturedBox((int)this.rectangleRules.x, (int)this.rectangleRules.y, (int)0, (int)0, (int)this.rectangleRules.width, (int)this.rectangleRules.height, (int)textureWidth, (int)textureHeight, (int)borderSize, (float)this.field_73735_i);
        super.draw(mouseX, mouseY, partialTickTime);
        this.fontRenderer.func_78276_b(GuiHelper.getLocalizedControlName(this.guiName, "name", new Object[0]), this.x + 5, this.y + 5, 0xFFFFFF);
        this.statsText.clearText();
        if (this.messagePageIndex == 0) {
            this.statsText.addText(GuiHelper.getLocalizedControlName(this.guiName, "message_1.title", new Object[0]));
            this.statsText.addNewLines(2);
            this.statsText.addText(GuiHelper.getLocalizedControlName(this.guiName, "message_1.text", new Object[0]));
        }
        if (this.messagePageIndex == 1) {
            this.statsText.addText(GuiHelper.getLocalizedControlName(this.guiName, "message_2.title", new Object[0]));
            this.statsText.addNewLines(2);
            this.statsText.addText(GuiHelper.getLocalizedControlName(this.guiName, "message_2.text", new Object[0]));
        }
        if (this.messagePageIndex == 2) {
            this.statsText.addText(GuiHelper.getLocalizedControlName(this.guiName, "message_3.title", new Object[0]));
            this.statsText.addNewLines(2);
            this.statsText.addText(GuiHelper.getLocalizedControlName(this.guiName, "message_3.text", new Object[0]));
        }
        if (this.messagePageIndex == 3) {
            this.statsText.addText(GuiHelper.getLocalizedControlName(this.guiName, "message_4.title", new Object[0]));
            this.statsText.addNewLines(2);
            this.statsText.addText(GuiHelper.getLocalizedControlName(this.guiName, "message_4.text", new Object[0]));
        }
        if (this.messagePageIndex == 4) {
            String urlDiscord = TextFormatting.BLUE.toString() + "https://discord.gg/5Z3KKvU" + TextFormatting.RESET.toString();
            this.statsText.addText(GuiHelper.getLocalizedControlName(this.guiName, "message_5.title", new Object[0]));
            this.statsText.addNewLines(2);
            this.statsText.addText(GuiHelper.getLocalizedControlName(this.guiName, "message_5.text", urlDiscord));
        }
        if (!StringUtils.func_151246_b((String)this.joinFailMessage) & this.messagePageIndex == 4) {
            this.statsText.addNewLines(2);
            this.statsText.addText(TextFormatting.RED.toString());
            this.statsText.addText("Error: " + this.joinFailMessage);
            this.statsText.addText(TextFormatting.RESET.toString());
            this.statsText.addNewLine();
            this.statsText.addNewLine();
        }
        int[] javaVersion = GlobalSkinLibraryUtils.getJavaVersion();
        this.buttonNext.field_146125_m = validJava = GlobalSkinLibraryUtils.isValidJavaVersion(javaVersion);
        this.buttonPrevious.field_146125_m = validJava;
        if (!validJava) {
            String urlWikiFaq = TextFormatting.BLUE.toString() + "https://github.com/RiskyKen/Armourers-Workshop/wiki/FAQ" + TextFormatting.RESET.toString();
            String urlVideoUpdateJava = TextFormatting.BLUE.toString() + "https://youtu.be/xZfaXHulmKo" + TextFormatting.RESET.toString();
            this.statsText.clearText();
            this.statsText.addText(GuiHelper.getLocalizedControlName(this.guiName, "old_java", javaVersion[0], javaVersion[1], urlWikiFaq, urlVideoUpdateJava));
        }
        this.statsText.draw(mouseX, mouseY);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY, float partialTickTime) {
        super.drawForeground(mouseX, mouseY, partialTickTime);
    }
}

