/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.render.tileentities;

import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.client.config.ConfigHandlerClient;
import moe.plushie.armourers_workshop.client.model.skin.ModelTypeHelper;
import moe.plushie.armourers_workshop.client.render.ModRenderHelper;
import moe.plushie.armourers_workshop.client.render.SkinModelRenderHelper;
import moe.plushie.armourers_workshop.client.skin.cache.ClientSkinCache;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinDescriptor;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityHologramProjector;
import moe.plushie.armourers_workshop.utils.SkinNBTHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderBlockHologramProjector
extends TileEntitySpecialRenderer<TileEntityHologramProjector> {
    public void render(TileEntityHologramProjector tileEntity, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (ConfigHandlerClient.showSkinRenderBounds) {
            AxisAlignedBB aabb = new AxisAlignedBB(tileEntity.func_174877_v());
            this.renderBox(aabb, 1.0f, 1.0f, 0.0f);
        }
        if (tileEntity.getPowerMode().get() != TileEntityHologramProjector.PowerMode.IGNORED && (tileEntity.getPowerMode().get() == TileEntityHologramProjector.PowerMode.HIGH ? tileEntity.getPowered().get() == false : tileEntity.getPowered().get() != false)) {
            return;
        }
        ItemStack itemStack = tileEntity.func_70301_a(0);
        SkinDescriptor skinPointer = SkinNBTHelper.getSkinDescriptorFromStack(itemStack);
        if (skinPointer == null) {
            return;
        }
        Skin skin = ClientSkinCache.INSTANCE.getSkin(skinPointer);
        if (skin == null) {
            return;
        }
        int rot = tileEntity.func_145832_p();
        GL11.glPushMatrix();
        GL11.glEnable((int)2977);
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (rot == 1) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (rot == 2) {
            GL11.glRotatef((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
        }
        if (rot == 3) {
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (rot == 4) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
        }
        if (rot == 5) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        float scale = 0.0625f;
        GL11.glTranslated((double)((float)tileEntity.getOffsetX().get().intValue() * scale), (double)((float)tileEntity.getOffsetY().get().intValue() * scale), (double)((float)tileEntity.getOffsetZ().get().intValue() * scale));
        GL11.glScalef((float)-1.0f, (float)-1.0f, (float)1.0f);
        int speedX = tileEntity.getRotationSpeedX().get();
        int speedY = tileEntity.getRotationSpeedY().get();
        int speedZ = tileEntity.getRotationSpeedZ().get();
        float angleX = 0.0f;
        float angleY = 0.0f;
        float angleZ = 0.0f;
        if (speedX != 0) {
            angleX = System.currentTimeMillis() % (long)speedX;
            angleX = angleX / (float)speedX * 360.0f;
        }
        if (speedY != 0) {
            angleY = System.currentTimeMillis() % (long)speedY;
            angleY = angleY / (float)speedY * 360.0f;
        }
        if (speedZ != 0) {
            angleZ = System.currentTimeMillis() % (long)speedZ;
            angleZ = angleZ / (float)speedZ * 360.0f;
        }
        if (!tileEntity.getGlowing().get().booleanValue()) {
            EnumFacing dir = EnumFacing.func_82600_a((int)tileEntity.func_145832_p());
            float xLight = tileEntity.func_174877_v().func_177958_n();
            float yLight = tileEntity.func_174877_v().func_177956_o();
            float zLight = tileEntity.func_174877_v().func_177952_p();
            float offsetX = tileEntity.getOffsetX().get().intValue();
            float offsetY = tileEntity.getOffsetY().get().intValue();
            float offsetZ = tileEntity.getOffsetZ().get().intValue();
            switch (dir) {
                case UP: {
                    xLight += offsetX * scale;
                    yLight += offsetY * scale;
                    zLight += offsetZ * scale;
                    break;
                }
                case DOWN: {
                    xLight += -offsetX * scale;
                    yLight += -offsetY * scale;
                    zLight += offsetZ * scale;
                    break;
                }
                case EAST: {
                    xLight += offsetY * scale;
                    yLight += -offsetX * scale;
                    zLight += offsetZ * scale;
                    break;
                }
                case WEST: {
                    xLight += -offsetY * scale;
                    yLight += offsetX * scale;
                    zLight += offsetZ * scale;
                    break;
                }
                case NORTH: {
                    xLight += offsetX * scale;
                    yLight += -offsetZ * scale;
                    zLight += -offsetY * scale;
                    break;
                }
                case SOUTH: {
                    xLight += -offsetX * scale;
                    yLight += offsetY * scale;
                    zLight += offsetZ * scale;
                }
            }
            ModRenderHelper.setLightingForBlock(tileEntity.func_145831_w(), tileEntity.func_174877_v());
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)((float)(-tileEntity.getRotationOffsetX().get().intValue() + tileEntity.getRotationOffsetX().get()) * scale), (double)((float)(-tileEntity.getRotationOffsetY().get().intValue() + tileEntity.getRotationOffsetY().get()) * scale), (double)((float)(-tileEntity.getRotationOffsetZ().get().intValue() + tileEntity.getRotationOffsetZ().get()) * scale));
        if (tileEntity.getAngleX().get() != 0) {
            GL11.glRotatef((float)tileEntity.getAngleX().get().intValue(), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (tileEntity.getAngleY().get() != 0) {
            GL11.glRotatef((float)tileEntity.getAngleY().get().intValue(), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (tileEntity.getAngleZ().get() != 0) {
            GL11.glRotatef((float)tileEntity.getAngleZ().get().intValue(), (float)0.0f, (float)0.0f, (float)1.0f);
        }
        if (angleX != 0.0f) {
            GL11.glRotatef((float)angleX, (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (angleY != 0.0f) {
            GL11.glRotatef((float)angleY, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (angleZ != 0.0f) {
            GL11.glRotatef((float)angleZ, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GL11.glTranslated((double)((float)tileEntity.getRotationOffsetX().get().intValue() * scale), (double)((float)tileEntity.getRotationOffsetY().get().intValue() * scale), (double)((float)tileEntity.getRotationOffsetZ().get().intValue() * scale));
        if (tileEntity.getGlowing().get().booleanValue()) {
            ModRenderHelper.disableLighting();
        }
        ModRenderHelper.enableAlphaBlend();
        double distance = Minecraft.func_71410_x().field_71439_g.func_70011_f((double)tileEntity.func_174877_v().func_177958_n(), (double)tileEntity.func_174877_v().func_177956_o(), (double)tileEntity.func_174877_v().func_177952_p());
        ISkinType skinType = skinPointer.getIdentifier().getSkinType();
        if (skinType == null) {
            skinType = skin.getSkinType();
        }
        skinType = skin.getSkinType();
        ModelTypeHelper targetModel = SkinModelRenderHelper.INSTANCE.getTypeHelperForModel(SkinModelRenderHelper.ModelType.MODEL_BIPED, skinType);
        targetModel.render(null, skin, null, true, skinPointer.getSkinDye(), null, true, distance, true);
        GL11.glPopMatrix();
        if (tileEntity.isShowRotationPoint()) {
            AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, (double)scale, (double)scale, (double)scale);
            this.renderBox(aabb, 1.0f, 0.0f, 1.0f);
        }
        ModRenderHelper.disableAlphaBlend();
        if (tileEntity.getGlowing().get().booleanValue()) {
            ModRenderHelper.enableLighting();
        }
        GL11.glDisable((int)2977);
        GL11.glPopMatrix();
    }

    private void renderBox(AxisAlignedBB aabb, float r, float g, float b) {
        float f1 = 0.002f;
        ModRenderHelper.disableLighting();
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2896);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)0.4f);
        GL11.glLineWidth((float)1.0f);
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        RenderGlobal.func_189697_a((AxisAlignedBB)aabb.func_191195_a((double)f1, (double)f1, (double)f1), (float)r, (float)g, (float)b, (float)0.4f);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        ModRenderHelper.enableLighting();
    }
}

