/*
 * Decompiled with CFR 0.152.
 */
package com.teamderpy.shouldersurfing.event;

import com.teamderpy.shouldersurfing.config.Config;
import com.teamderpy.shouldersurfing.config.Perspective;
import com.teamderpy.shouldersurfing.math.Vec2f;
import com.teamderpy.shouldersurfing.util.ShoulderState;
import com.teamderpy.shouldersurfing.util.ShoulderSurfingHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientEventHandler {
    @SubscribeEvent
    public void clientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.START)) {
            if (!Perspective.FIRST_PERSON.equals((Object)Perspective.current())) {
                ShoulderState.setSwitchPerspective(false);
            }
            ShoulderState.setAiming(ShoulderSurfingHelper.isHoldingSpecialItem());
            if (ShoulderState.isAiming() && Config.CLIENT.getCrosshairType().doSwitchPerspective() && ShoulderState.doShoulderSurfing()) {
                ShoulderSurfingHelper.setPerspective(Perspective.FIRST_PERSON);
                ShoulderState.setSwitchPerspective(true);
            } else if (!ShoulderState.isAiming() && Perspective.FIRST_PERSON.equals((Object)Perspective.current()) && ShoulderState.doSwitchPerspective()) {
                ShoulderSurfingHelper.setPerspective(Perspective.SHOULDER_SURFING);
            }
        }
    }

    @SubscribeEvent
    public void preRenderPlayerEvent(RenderPlayerEvent.Pre event) {
        if (event.isCancelable() && event.getEntityPlayer().equals((Object)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71462_r == null && ShoulderState.getCameraDistance() < 0.8 && Config.CLIENT.keepCameraOutOfHead() && ShoulderState.doShoulderSurfing()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void preRenderGameOverlayEvent(RenderGameOverlayEvent.Pre event) {
        if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.CROSSHAIRS)) {
            if (ShoulderState.getProjected() != null) {
                ScaledResolution mainWindow = event.getResolution();
                float scale = (float)mainWindow.func_78325_e() * ShoulderSurfingHelper.getShadersResmul();
                Vec2f window = new Vec2f(mainWindow.func_78326_a(), mainWindow.func_78328_b());
                Vec2f center = window.scale(scale).divide(2.0f);
                Vec2f projectedOffset = ShoulderState.getProjected().subtract(center).divide(scale);
                Vec2f lastTranslation = ShoulderState.getLastTranslation();
                Vec2f interpolated = projectedOffset.subtract(lastTranslation).scale(event.getPartialTicks());
                ShoulderState.setTranslation(ShoulderState.getLastTranslation().add(interpolated));
            }
            if (Config.CLIENT.getCrosshairType().isDynamic() && ShoulderState.doShoulderSurfing()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)ShoulderState.getTranslation().getX(), (float)(-ShoulderState.getTranslation().getY()), (float)0.0f);
                ShoulderState.setLastTranslation(ShoulderState.getTranslation());
            } else {
                ShoulderState.setLastTranslation(Vec2f.ZERO);
            }
        } else if (event.getType().equals((Object)RenderGameOverlayEvent.ElementType.BOSSHEALTH) && Config.CLIENT.getCrosshairType().isDynamic() && ShoulderState.doShoulderSurfing()) {
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public void renderWorldLast(RenderWorldLastEvent event) {
        Entity renderView = Minecraft.func_71410_x().func_175606_aa();
        PlayerControllerMP controller = Minecraft.func_71410_x().field_71442_b;
        if (ShoulderState.doShoulderSurfing()) {
            double playerReach = Config.CLIENT.useCustomRaytraceDistance() ? Config.CLIENT.getCustomRaytraceDistance() : 0.0;
            RayTraceResult result = ShoulderSurfingHelper.traceFromEyes(renderView, controller, playerReach, event.getPartialTicks());
            Vec3d position = result.field_72307_f.func_178788_d(renderView.func_174824_e(event.getPartialTicks()).func_178786_a(0.0, (double)renderView.func_70047_e(), 0.0));
            ShoulderState.setProjected(ShoulderSurfingHelper.project2D(position));
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        Config.CLIENT.sync();
    }
}

