/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.gfx.shaders;

import java.nio.FloatBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import org.lwjgl.opengl.GL11;
import org.orecruncher.lib.gfx.shaders.ShaderException;
import org.orecruncher.lib.gfx.shaders.ShaderProgram;

public class FrameBufferShader {
    protected final ShaderProgram shader;
    protected final ShaderProgram.IShaderUseCallback callback;
    protected Framebuffer blit = null;
    private static final FloatBuffer CLEAR_COLOR_BUFFER = GLAllocation.func_74529_h((int)16);

    public FrameBufferShader(ShaderProgram program, ShaderProgram.IShaderUseCallback callback) {
        this.shader = program;
        this.callback = callback;
    }

    public void setSize(int width, int height) {
        if (this.blit != null && (this.blit.field_147621_c != width || this.blit.field_147618_d != height)) {
            this.release();
        }
        if (this.blit == null) {
            this.blit = new Framebuffer(width, height, false);
            this.blit.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    public void bindTexture() {
        if (this.blit == null) {
            throw new RuntimeException("Texture not available");
        }
        this.blit.func_147612_c();
    }

    public void release() {
        if (this.blit != null) {
            this.blit.func_147608_a();
            this.blit = null;
        }
    }

    public void render() throws ShaderException {
        if (this.blit == null) {
            throw new RuntimeException("Framebuffer not initialized");
        }
        this.blit.func_147614_f();
        Framebuffer mcFrameBuffer = Minecraft.func_71410_x().func_147110_a();
        this.blit.func_147610_a(true);
        float renderHeight = this.blit.field_147618_d;
        float renderWidth = this.blit.field_147621_c;
        GL11.glPushAttrib((int)7072);
        int prevShaderProgram = GL11.glGetInteger((int)35725);
        GL11.glGetFloat((int)3106, (FloatBuffer)CLEAR_COLOR_BUFFER);
        GlStateManager.func_179094_E();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179130_a((double)0.0, (double)renderWidth, (double)renderHeight, (double)0.0, (double)1000.0, (double)3000.0);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
        this.shader.use(this.callback);
        GlStateManager.func_179098_w();
        GlStateManager.func_187447_r((int)4);
        GlStateManager.func_187426_b((float)0.0f, (float)0.0f);
        GlStateManager.func_187435_e((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_187426_b((float)0.0f, (float)1.0f);
        GlStateManager.func_187435_e((float)0.0f, (float)renderHeight, (float)0.0f);
        GlStateManager.func_187426_b((float)1.0f, (float)1.0f);
        GlStateManager.func_187435_e((float)renderWidth, (float)renderHeight, (float)0.0f);
        GlStateManager.func_187426_b((float)1.0f, (float)1.0f);
        GlStateManager.func_187435_e((float)renderWidth, (float)renderHeight, (float)0.0f);
        GlStateManager.func_187426_b((float)1.0f, (float)0.0f);
        GlStateManager.func_187435_e((float)renderWidth, (float)0.0f, (float)0.0f);
        GlStateManager.func_187426_b((float)0.0f, (float)0.0f);
        GlStateManager.func_187435_e((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_187437_J();
        this.shader.unUse();
        OpenGlHelper.func_153161_d((int)prevShaderProgram);
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179121_F();
        GlStateManager.func_179099_b();
        GlStateManager.func_179082_a((float)CLEAR_COLOR_BUFFER.get(0), (float)CLEAR_COLOR_BUFFER.get(1), (float)CLEAR_COLOR_BUFFER.get(2), (float)CLEAR_COLOR_BUFFER.get(3));
        GlStateManager.func_179121_F();
        mcFrameBuffer.func_147610_a(true);
    }
}

