/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.SimpleModelFontRenderer;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

final class FancyMissingModel
implements IModel {
    private static final nf font = new nf("minecraft", "textures/font/ascii.png");
    private static final nf font2 = new nf("minecraft", "font/ascii");
    private static final TRSRTransformation smallTransformation = TRSRTransformation.blockCenterToCorner(new TRSRTransformation(null, null, new Vector3f(0.25f, 0.25f, 0.25f), null));
    private static final LoadingCache<cea, SimpleModelFontRenderer> fontCache = CacheBuilder.newBuilder().maximumSize(3L).build((CacheLoader)new CacheLoader<cea, SimpleModelFontRenderer>(){

        public SimpleModelFontRenderer load(cea format) throws Exception {
            Matrix4f m = new Matrix4f();
            m.m20 = 0.0078125f;
            m.m01 = m.m12 = -m.m20;
            m.m33 = 1.0f;
            m.setTranslation(new Vector3f(1.0f, 1.0039062f, 0.0f));
            return new SimpleModelFontRenderer(bib.z().t, font, bib.z().N(), false, m, format){

                @Override
                protected float b(char c2, boolean italic) {
                    return super.a(126, italic);
                }
            };
        }
    });
    private final IModel missingModel;
    private final String message;

    public FancyMissingModel(IModel missingModel, String message) {
        this.missingModel = missingModel;
        this.message = message;
    }

    @Override
    public Collection<nf> getTextures() {
        return ImmutableList.of((Object)font2);
    }

    @Override
    public Optional<bvu> asVanillaModel() {
        return this.missingModel.asVanillaModel();
    }

    @Override
    public cfy bake(IModelState state, cea format, Function<nf, cdq> bakedTextureGetter) {
        cfy bigMissing = this.missingModel.bake(state, format, bakedTextureGetter);
        ModelStateComposition smallState = new ModelStateComposition(state, smallTransformation);
        cfy smallMissing = this.missingModel.bake(smallState, format, bakedTextureGetter);
        return new BakedModel(bigMissing, smallMissing, (SimpleModelFontRenderer)((Object)fontCache.getUnchecked((Object)format)), this.message, bakedTextureGetter.apply(font2));
    }

    static final class BakedModel
    implements cfy {
        private final SimpleModelFontRenderer fontRenderer;
        private final String message;
        private final cdq fontTexture;
        private final cfy missingModel;
        private final cfy otherModel;
        private final boolean big;
        private ImmutableList<bvp> quads;

        public BakedModel(cfy bigMissing, cfy smallMissing, SimpleModelFontRenderer fontRenderer, String message, cdq fontTexture) {
            this.missingModel = bigMissing;
            this.otherModel = new BakedModel(smallMissing, fontRenderer, message, fontTexture, this);
            this.big = true;
            this.fontRenderer = fontRenderer;
            this.message = message;
            this.fontTexture = fontTexture;
        }

        public BakedModel(cfy smallMissing, SimpleModelFontRenderer fontRenderer, String message, cdq fontTexture, BakedModel big) {
            this.missingModel = smallMissing;
            this.otherModel = big;
            this.big = false;
            this.fontRenderer = fontRenderer;
            this.message = message;
            this.fontTexture = fontTexture;
        }

        public List<bvp> a(@Nullable awt state, @Nullable fa side, long rand) {
            if (side == null) {
                if (this.quads == null) {
                    int y;
                    this.fontRenderer.setSprite(this.fontTexture);
                    this.fontRenderer.setFillBlanks(true);
                    String[] lines = this.message.split("\\r?\\n");
                    ArrayList splitLines = Lists.newArrayList();
                    for (y = 0; y < lines.length; ++y) {
                        splitLines.addAll(this.fontRenderer.c(lines[y], 128));
                    }
                    for (y = 0; y < splitLines.size(); ++y) {
                        this.fontRenderer.a((String)splitLines.get(y), 0, (int)(((float)y - (float)splitLines.size() / 2.0f) * (float)this.fontRenderer.a) + 64, -16711681);
                    }
                    ImmutableList.Builder builder = ImmutableList.builder();
                    builder.addAll((Iterable)this.missingModel.a(state, side, rand));
                    builder.addAll(this.fontRenderer.build());
                    this.quads = builder.build();
                }
                return this.quads;
            }
            return this.missingModel.a(state, side, rand);
        }

        public boolean a() {
            return true;
        }

        public boolean b() {
            return false;
        }

        public boolean c() {
            return false;
        }

        public cdq d() {
            return this.fontTexture;
        }

        public bwa f() {
            return bwa.a;
        }

        public Pair<? extends cfy, Matrix4f> handlePerspective(bwc.b cameraTransformType) {
            TRSRTransformation transform = TRSRTransformation.identity();
            boolean big = true;
            switch (cameraTransformType) {
                case b: {
                    break;
                }
                case c: {
                    break;
                }
                case d: {
                    transform = new TRSRTransformation(new Vector3f(-0.62f, 0.5f, -0.5f), new Quat4f(1.0f, -1.0f, -1.0f, 1.0f), null, null);
                    big = false;
                    break;
                }
                case e: {
                    transform = new TRSRTransformation(new Vector3f(-0.5f, 0.5f, -0.5f), new Quat4f(1.0f, 1.0f, 1.0f, 1.0f), null, null);
                    big = false;
                    break;
                }
                case f: {
                    break;
                }
                case g: {
                    if (ForgeModContainer.zoomInMissingModelTextInGui) {
                        transform = new TRSRTransformation(null, new Quat4f(1.0f, 1.0f, 1.0f, 1.0f), new Vector3f(4.0f, 4.0f, 4.0f), null);
                        big = false;
                        break;
                    }
                    transform = new TRSRTransformation(null, new Quat4f(1.0f, 1.0f, 1.0f, 1.0f), null, null);
                    big = true;
                    break;
                }
                case i: {
                    transform = new TRSRTransformation(null, new Quat4f(-1.0f, -1.0f, 1.0f, 1.0f), null, null);
                    break;
                }
            }
            if (big != this.big) {
                return Pair.of((Object)this.otherModel, (Object)transform.getMatrix());
            }
            return Pair.of((Object)this, (Object)transform.getMatrix());
        }
    }
}

