/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import net.minecraftforge.common.ticket.AABBTicket;
import net.minecraftforge.common.ticket.ChunkTicketManager;
import net.minecraftforge.common.ticket.SimpleTicket;
import net.minecraftforge.fml.common.FMLLog;

public class FarmlandWaterManager {
    private static boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugFarmlandWaterManager", "false"));
    private static final Int2ObjectMap<Map<amn, ChunkTicketManager<bhe>>> customWaterHandler = new Int2ObjectOpenHashMap();

    @Deprecated
    public static <T extends SimpleTicket<bhe>> T addCustomTicket(amu world, T ticket, amn ... chunkPoses) {
        return FarmlandWaterManager.addCustomTicket(world, ticket, chunkPoses[0], Arrays.copyOfRange(chunkPoses, 1, chunkPoses.length));
    }

    public static <T extends SimpleTicket<bhe>> T addCustomTicket(amu world, T ticket, amn masterChunk, amn ... additionalChunks) {
        Preconditions.checkArgument((!world.G ? 1 : 0) != 0, (Object)"Water region is only determined server-side");
        Map ticketMap = (Map)customWaterHandler.computeIfAbsent((Object)world.s.getDimension(), id -> new MapMaker().weakValues().makeMap());
        ChunkTicketManager[] additionalTickets = new ChunkTicketManager[additionalChunks.length];
        for (int i2 = 0; i2 < additionalChunks.length; ++i2) {
            additionalTickets[i2] = ticketMap.computeIfAbsent(additionalChunks[i2], ChunkTicketManager::new);
        }
        ticket.setManager(ticketMap.computeIfAbsent(masterChunk, ChunkTicketManager::new), additionalTickets);
        ticket.validate();
        return ticket;
    }

    public static AABBTicket addAABBTicket(amu world, bhb aabb) {
        if (DEBUG) {
            FMLLog.log.info("FarmlandWaterManager: New AABBTicket, aabb={}", (Object)aabb);
        }
        amn leftUp = new amn((int)aabb.a >> 4, (int)aabb.c >> 4);
        amn rightDown = new amn((int)aabb.d >> 4, (int)aabb.f >> 4);
        HashSet<amn> posSet = new HashSet<amn>();
        for (int x = leftUp.a; x <= rightDown.a; ++x) {
            for (int z = leftUp.b; z <= rightDown.b; ++z) {
                posSet.add(new amn(x, z));
            }
        }
        amn masterPos = null;
        double masterDistance = Double.MAX_VALUE;
        for (amn pos : posSet) {
            bhe center;
            double distToCenter = FarmlandWaterManager.getDistanceSq(pos, center = new bhe(aabb.a + (aabb.d - aabb.a) * 0.5, aabb.b + (aabb.e - aabb.b) * 0.5, aabb.c + (aabb.f - aabb.c) * 0.5));
            if (!(distToCenter < masterDistance)) continue;
            if (DEBUG) {
                FMLLog.log.info("FarmlandWaterManager: New better pos then {}: {}, prev dist {}, new dist {}", (Object)masterPos, (Object)pos, (Object)masterDistance, (Object)distToCenter);
            }
            masterPos = pos;
            masterDistance = distToCenter;
        }
        posSet.remove(masterPos);
        if (DEBUG) {
            FMLLog.log.info("FarmlandWaterManager: {} center pos, {} dummy posses. Dist to center {}", masterPos, (Object)posSet.toArray(new amn[0]), (Object)masterDistance);
        }
        return FarmlandWaterManager.addCustomTicket(world, new AABBTicket(aabb), masterPos, posSet.toArray(new amn[0]));
    }

    private static double getDistanceSq(amn pos, bhe vec3d) {
        double d0 = pos.a * 16 + 8;
        double d1 = pos.b * 16 + 8;
        double d2 = d0 - vec3d.b;
        double d3 = d1 - vec3d.d;
        return d2 * d2 + d3 * d3;
    }

    public static boolean hasBlockWaterTicket(amu world, et pos) {
        ChunkTicketManager<bhe> ticketManager = FarmlandWaterManager.getTicketManager(new amn(pos.p() >> 4, pos.r() >> 4), world);
        if (ticketManager != null) {
            bhe posAsVec3d = new bhe((double)pos.p() + 0.5, (double)pos.q() + 0.5, (double)pos.r() + 0.5);
            for (SimpleTicket<bhe> ticket : ticketManager.getTickets()) {
                if (!ticket.matches(posAsVec3d)) continue;
                return true;
            }
        }
        return false;
    }

    static void removeTickets(axw chunk) {
        ChunkTicketManager<bhe> ticketManager = FarmlandWaterManager.getTicketManager(chunk.k(), chunk.q());
        if (ticketManager != null) {
            if (DEBUG) {
                FMLLog.log.info("FarmlandWaterManager: got tickets {} at {} before", (Object)ticketManager.getTickets().size(), (Object)ticketManager.pos);
            }
            ticketManager.getTickets().removeIf(next -> next.unload(ticketManager));
            if (DEBUG) {
                FMLLog.log.info("FarmlandWaterManager: got tickets {} at {} after", (Object)ticketManager.getTickets().size(), (Object)ticketManager.pos);
            }
        }
    }

    private static ChunkTicketManager<bhe> getTicketManager(amn pos, amu world) {
        Preconditions.checkArgument((!world.G ? 1 : 0) != 0, (Object)"Water region is only determined server-side");
        Map ticketMap = (Map)customWaterHandler.get(world.s.getDimension());
        if (ticketMap == null) {
            return null;
        }
        return (ChunkTicketManager)ticketMap.get(pos);
    }
}

