/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.util;

import codechicken.lib.colour.Colour;
import codechicken.lib.math.MathHelper;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.Vertex5;
import codechicken.lib.vec.uv.UV;
import codechicken.lib.vec.uv.UVTransformation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;

public class VertexDataUtils {
    public static int getPositionElement(VertexFormat format) {
        for (int e = 0; e < format.func_177345_h(); ++e) {
            if (!format.func_177348_c(e).func_177374_g()) continue;
            return e;
        }
        return -1;
    }

    public static int getNormalElement(VertexFormat format) {
        for (int e = 0; e < format.func_177345_h(); ++e) {
            if (format.func_177348_c(e).func_177375_c() != VertexFormatElement.EnumUsage.NORMAL) continue;
            return e;
        }
        return -1;
    }

    public static int getUVElement(VertexFormat format) {
        for (int e = 0; e < format.func_177345_h(); ++e) {
            if (format.func_177348_c(e).func_177375_c() != VertexFormatElement.EnumUsage.UV || format.func_177348_c(e).func_177369_e() != 0) continue;
            return e;
        }
        return -1;
    }

    public static int getElement(VertexFormat format, VertexFormatElement element) {
        for (int e = 0; e < format.func_177345_h(); ++e) {
            if (!format.func_177348_c(e).equals((Object)element)) continue;
            return e;
        }
        return -1;
    }

    public static TextureAtlasSprite getSpriteForUV(TextureMap textureMap, UV uv) {
        for (TextureAtlasSprite sprite : textureMap.field_94252_e.values()) {
            if (!MathHelper.between(sprite.func_94209_e(), uv.u, sprite.func_94212_f()) || !MathHelper.between(sprite.func_94206_g(), uv.v, sprite.func_94210_h())) continue;
            return sprite;
        }
        return textureMap.func_174944_f();
    }

    public static BakedQuad copyQuad(UnpackedBakedQuad quad) {
        return new BakedQuad(quad.func_178209_a(), quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat());
    }

    public static Map<EnumFacing, List<BakedQuad>> sortFaceData(List<BakedQuad> quads) {
        HashMap<EnumFacing, List<BakedQuad>> faceQuadMap = new HashMap<EnumFacing, List<BakedQuad>>();
        for (BakedQuad quad : quads) {
            List faceQuads = faceQuadMap.computeIfAbsent(quad.func_178210_d(), k -> new ArrayList());
            faceQuads.add(quad);
        }
        return faceQuadMap;
    }

    public static void fullyPackQuads(int[] packedData, float[][][] unpackedData, VertexFormat format) {
        for (int e = 0; e < format.func_177345_h(); ++e) {
            for (int v = 0; v < 4; ++v) {
                LightUtil.pack((float[])unpackedData[v][e], (int[])packedData, (VertexFormat)format, (int)v, (int)e);
            }
        }
    }

    public static void fullyUnPackQuads(int[] packedData, float[][][] unpackedData, VertexFormat format) {
        for (int e = 0; e < format.func_177345_h(); ++e) {
            for (int v = 0; v < 4; ++v) {
                LightUtil.unpack((int[])packedData, (float[])unpackedData[v][e], (VertexFormat)format, (int)v, (int)e);
            }
        }
    }

    public static float[][] unpackElements(int[] packed, VertexFormat format, VertexFormatElement element) {
        float[][] data = new float[4][4];
        int e = VertexDataUtils.getElement(format, element);
        for (int v = 0; v < 4; ++v) {
            LightUtil.unpack((int[])packed, (float[])data[v], (VertexFormat)format, (int)v, (int)e);
        }
        return data;
    }

    public static BakedQuad buildQuad(VertexFormat format, TextureAtlasSprite sprite, EnumFacing face, Colour colour, UVTransformation t, Vertex5 v1, Vertex5 v2, Vertex5 v3, Vertex5 v4) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadTint(-1);
        builder.setQuadOrientation(face);
        builder.setTexture(sprite);
        t.apply(v1.uv);
        t.apply(v2.uv);
        t.apply(v3.uv);
        t.apply(v4.uv);
        VertexDataUtils.putVertex(builder, format, face, v1, colour);
        VertexDataUtils.putVertex(builder, format, face, v2, colour);
        VertexDataUtils.putVertex(builder, format, face, v3, colour);
        VertexDataUtils.putVertex(builder, format, face, v4, colour);
        return VertexDataUtils.copyQuad(builder.build());
    }

    private static void putVertex(UnpackedBakedQuad.Builder builder, VertexFormat format, EnumFacing face, Vertex5 vert, Colour colour) {
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            VertexFormatElement element = format.func_177348_c(e);
            switch (element.func_177375_c()) {
                case POSITION: {
                    Vector3 vec = vert.vec;
                    builder.put(e, new float[]{(float)vec.x, (float)vec.y, (float)vec.z, 1.0f});
                    continue block6;
                }
                case NORMAL: {
                    builder.put(e, new float[]{face.func_82601_c(), face.func_96559_d(), face.func_82599_e(), 0.0f});
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{(float)(colour.r & 0xFF) / 255.0f, (float)(colour.g & 0xFF) / 255.0f, (float)(colour.b & 0xFF) / 255.0f, (float)(colour.a & 0xFF) / 255.0f});
                    continue block6;
                }
                case UV: {
                    UV uv = vert.uv;
                    builder.put(e, new float[]{(float)uv.u, (float)uv.v, 0.0f, 1.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public static List<BakedQuad> shadeQuadFaces(BakedQuad ... quads) {
        return VertexDataUtils.shadeQuadFaces(Arrays.asList(quads));
    }

    public static List<BakedQuad> shadeQuadFaces(List<BakedQuad> quads) {
        LinkedList<BakedQuad> shadedQuads = new LinkedList<BakedQuad>();
        for (BakedQuad quad : quads) {
            int[] rawData = quad.func_178209_a();
            for (int v = 0; v < 4; ++v) {
                for (int e = 0; e < quad.getFormat().func_177345_h(); ++e) {
                    VertexFormatElement element = quad.getFormat().func_177348_c(e);
                    if (element.func_177375_c() != VertexFormatElement.EnumUsage.COLOR) continue;
                    float[] data = new float[4];
                    LightUtil.unpack((int[])rawData, (float[])data, (VertexFormat)quad.getFormat(), (int)v, (int)e);
                    data = VertexDataUtils.diffuseFaceLight(quad.func_178210_d(), data);
                    LightUtil.pack((float[])data, (int[])rawData, (VertexFormat)quad.getFormat(), (int)v, (int)e);
                }
            }
            shadedQuads.add(new BakedQuad(rawData, quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat()));
        }
        return shadedQuads;
    }

    private static float[] diffuseFaceLight(EnumFacing face, float[] colour) {
        double diffuse;
        switch (face) {
            case DOWN: {
                diffuse = 0.5;
                break;
            }
            case NORTH: 
            case SOUTH: {
                diffuse = 0.8;
                break;
            }
            case WEST: 
            case EAST: {
                diffuse = 0.6;
                break;
            }
            default: {
                diffuse = 1.0;
            }
        }
        colour[0] = (float)((double)colour[0] * diffuse);
        colour[1] = (float)((double)colour[1] * diffuse);
        colour[2] = (float)((double)colour[2] * diffuse);
        return colour;
    }
}

