/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.capabilities.season;

import javax.annotation.Nonnull;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public enum TemperatureRating {
    ICY("icy", 0.0f),
    COOL("cool", 0.2f),
    MILD("mild", 1.0f),
    WARM("warm", 1.8f),
    HOT("hot", 100.0f);

    private final String val;
    private final float tempRange;

    private TemperatureRating(String val, float tempRange) {
        this.val = val;
        this.tempRange = tempRange;
    }

    @Nonnull
    public String getValue() {
        return this.val;
    }

    public float getTempRange() {
        return this.tempRange;
    }

    @Nonnull
    public static TemperatureRating fromTemp(float temp) {
        for (TemperatureRating rating : TemperatureRating.values()) {
            if (!(temp < rating.getTempRange())) continue;
            return rating;
        }
        return MILD;
    }
}

