/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.client.handlers.fog;

import javax.annotation.Nonnull;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.client.handlers.fog.IFogColorCalculator;
import org.orecruncher.lib.Color;
import org.orecruncher.lib.collections.ObjectArray;

@SideOnly(value=Side.CLIENT)
public class HolisticFogColorCalculator
implements IFogColorCalculator {
    protected ObjectArray<IFogColorCalculator> calculators = new ObjectArray(4);
    protected Color cached;

    public void add(@Nonnull IFogColorCalculator calc2) {
        this.calculators.add((Object)calc2);
    }

    @Override
    public Color calculate(@Nonnull EntityViewRenderEvent.FogColors event) {
        Color result = null;
        for (int i = 0; i < this.calculators.size(); ++i) {
            Color color = ((IFogColorCalculator)this.calculators.get(i)).calculate(event);
            if (result == null) {
                result = color;
                continue;
            }
            if (color == null) continue;
            result = result.mix(color);
        }
        this.cached = result;
        return this.cached;
    }

    @Override
    public void tick() {
        this.calculators.forEach(IFogColorCalculator::tick);
    }

    public String toString() {
        return this.cached != null ? this.cached.toString() : "<NOT SET>";
    }
}

