/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.recipe;

import codechicken.lib.configuration.ConfigFile;
import codechicken.lib.configuration.ConfigTag;
import codechicken.lib.configuration.IConfigTag;
import com.google.gson.JsonObject;
import java.util.function.BooleanSupplier;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.crafting.IConditionFactory;
import net.minecraftforge.common.crafting.JsonContext;

public abstract class AbstractConfigConditionalFactory
implements IConditionFactory {
    private ConfigFile config;

    protected AbstractConfigConditionalFactory(ConfigFile config) {
        this.config = config;
    }

    public BooleanSupplier parse(JsonContext context, JsonObject json) {
        String tag = JsonUtils.func_151200_h((JsonObject)json, (String)"tag");
        boolean flip = tag.startsWith("!");
        if (flip) {
            tag = tag.substring(1);
        }
        String[] parts = tag.contains(".") ? tag.split("\\.") : new String[]{tag};
        ConfigTag t = this.config;
        for (String p : parts) {
            if (!t.hasTag(p)) {
                throw new RuntimeException("Tag: " + tag + " does not exist in the specified config.");
            }
            t = t.getTagIfPresent(p);
        }
        if (t.getType() != IConfigTag.TagType.BOOLEAN) {
            throw new RuntimeException("Unable to use non boolean tag as conditional.");
        }
        boolean value = t.getBoolean();
        return () -> flip != value;
    }
}

