/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.gui.controls;

import moe.plushie.armourers_workshop.client.gui.controls.GuiTabController;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiTab
extends Gui {
    private final GuiTabController parent;
    private final String name;
    public boolean enabled;
    public boolean visible;
    private int iconTextureX = 0;
    private int iconTextureY = 0;
    private int iconTextureWidth = 16;
    private int iconTextureHeight = 16;
    private int tabTextureWidth = 26;
    private int tabTextureHeight = 30;
    private int padLeft;
    private int padRight;
    private int padTop;
    private int padBottom = 0;
    private int animationFrames = 0;
    private int animationSpeed = 0;

    public GuiTab(GuiTabController parent, String name) {
        this.parent = parent;
        this.name = name;
        this.enabled = true;
        this.visible = true;
    }

    public String getName() {
        return this.name;
    }

    public void render(int index, int x, int y, int mouseX, int mouseY, boolean activeTab, ResourceLocation tabIcons, boolean left) {
        int textureOffsetX = 0;
        int textureOffsetY = this.tabTextureHeight;
        if (this.isMouseOver(x, y, mouseX, mouseY)) {
            textureOffsetX += this.tabTextureWidth;
        }
        if (!this.enabled) {
            textureOffsetX = this.tabTextureWidth * 2;
        }
        if (activeTab) {
            textureOffsetY = 0;
        }
        if (this.parent.isFullscreen()) {
            textureOffsetY += this.tabTextureHeight * 2;
        }
        if (!left & !this.parent.isFullscreen()) {
            textureOffsetX += this.tabTextureWidth * 2;
        }
        this.func_73729_b(x, y, textureOffsetX, textureOffsetY, this.tabTextureWidth, this.tabTextureHeight);
        if (this.parent.isEditMode() & left) {
            if (index != 0) {
                this.func_73729_b(x - 2, y + 3, 0, 248, 8, 8);
            }
            this.func_73729_b(x - 2, y + 11, 16, 240, 8, 8);
            if (index < this.parent.getTabCount() - 2) {
                this.func_73729_b(x - 2, y + 19, 0, 240, 8, 8);
            }
        }
        if (this.parent.isEditMode() & !left) {
            if (index != 0) {
                this.func_73729_b(x + 19, y + 3, 0, 248, 8, 8);
            }
            this.func_73729_b(x + 19, y + 11, 16, 240, 8, 8);
            if (index < this.parent.getTabCount() - 2) {
                this.func_73729_b(x + 19, y + 19, 0, 240, 8, 8);
            }
        }
        Minecraft.func_71410_x().field_71446_o.func_110577_a(tabIcons);
        if (left) {
            this.renderIcon(x - 1, y, mouseX, mouseY);
        } else {
            this.renderIcon(x, y, mouseX, mouseY);
        }
    }

    public GuiTab setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public GuiTab setVisable(boolean visible) {
        this.visible = visible;
        return this;
    }

    public GuiTab setIconLocation(int x, int y) {
        this.iconTextureX = x;
        this.iconTextureY = y;
        return this;
    }

    public GuiTab setIconSize(int width, int height) {
        this.iconTextureWidth = width;
        this.iconTextureHeight = height;
        return this;
    }

    public GuiTab setTabTextureSize(int width, int height) {
        this.tabTextureWidth = width;
        this.tabTextureHeight = height;
        return this;
    }

    public GuiTab setPadding(int left, int right, int top, int bottom) {
        this.padLeft = left;
        this.padRight = right;
        this.padTop = top;
        this.padBottom = bottom;
        return this;
    }

    public GuiTab setAnimation(int frames, int speed) {
        this.animationFrames = frames;
        this.animationSpeed = speed;
        return this;
    }

    public boolean isMouseOver(int x, int y, int mouseX, int mouseY) {
        return mouseX >= x + this.padLeft & mouseX < x + this.tabTextureWidth - this.padRight && mouseY >= y + this.padTop & mouseY < y + this.tabTextureHeight - this.padBottom;
    }

    public boolean mousePress(int x, int y, int mouseX, int mouseY) {
        return mouseX >= x + this.padLeft & mouseX < x + this.tabTextureWidth - this.padRight && mouseY >= y + this.padTop & mouseY < y + this.tabTextureHeight - this.padBottom && this.enabled && !this.parent.isEditMode();
    }

    private void renderIcon(int x, int y, int mouseX, int mouseY) {
        int animationOffset = 0;
        if (this.isMouseOver(x, y, mouseX, mouseY) & this.animationFrames > 0) {
            int frame = (int)(System.currentTimeMillis() / (long)this.animationSpeed % (long)this.animationFrames);
            animationOffset += this.iconTextureHeight * frame;
        }
        this.func_73729_b(x + (int)((float)this.tabTextureWidth / 2.0f - (float)this.iconTextureWidth / 2.0f), y + (int)((float)this.tabTextureHeight / 2.0f - (float)this.iconTextureHeight / 2.0f), this.iconTextureX, this.iconTextureY + animationOffset, this.iconTextureWidth, this.iconTextureHeight);
    }
}

