/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.client.palette;

import java.util.Arrays;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Palette {
    public static final int MAX_COLOURS_PER_PALETTE = 32;
    private String name;
    private final boolean locked;
    private int[] colours;

    public Palette(String name, boolean locked, int[] colours) {
        this.name = name;
        this.locked = locked;
        this.colours = colours;
    }

    public Palette(String name) {
        this(name, false, new int[32]);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public int[] getColours() {
        return this.colours;
    }

    public void setColour(int index, int colour) {
        this.colours[index] = colour;
    }

    public int getColour(int index) {
        return this.colours[index];
    }

    public String toString() {
        return "Palette [name=" + this.name + ", colours=" + Arrays.toString(this.colours) + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Palette other = (Palette)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    protected Palette clone() {
        return new Palette(this.name, this.locked, (int[])this.colours.clone());
    }
}

