/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.data.type;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;

public class BipedRotations {
    private static final String TAG_ROTATION_DATA = "rotation_data";
    private static final String TAG_CHILD = "child";
    private float[][] rotationData = new float[BipedPart.values().length][3];
    private boolean child = false;

    public BipedRotations() {
        this.resetRotations();
    }

    public void resetRotations() {
        this.setPartRotations(BipedPart.HEAD, 0.0f, 0.0f, 0.0f);
        this.setPartRotations(BipedPart.CHEST, 0.0f, 0.0f, 0.0f);
        this.setPartRotations(BipedPart.LEFT_ARM, 0.0f, (float)Math.toRadians(-1.0), (float)Math.toRadians(-5.0));
        this.setPartRotations(BipedPart.RIGHT_ARM, 0.0f, (float)Math.toRadians(1.0), (float)Math.toRadians(5.0));
        this.setPartRotations(BipedPart.LEFT_LEG, 0.0f, 0.0f, 0.0f);
        this.setPartRotations(BipedPart.RIGHT_LEG, 0.0f, 0.0f, 0.0f);
    }

    public void setChild(boolean child) {
        this.child = child;
    }

    public boolean isChild() {
        return this.child;
    }

    public void setPartRotations(BipedPart bipedPart, float[] rotationData) {
        this.setPartRotations(bipedPart, rotationData[0], rotationData[1], rotationData[2]);
    }

    public void setPartRotations(BipedPart bipedPart, float x, float y, float z) {
        this.rotationData[bipedPart.ordinal()][0] = x;
        this.rotationData[bipedPart.ordinal()][1] = y;
        this.rotationData[bipedPart.ordinal()][2] = z;
    }

    public float[] getPartRotations(BipedPart bipedPart) {
        return this.rotationData[bipedPart.ordinal()];
    }

    public void applyRotationsToBiped(ModelPlayer modelBiped) {
        modelBiped.field_78091_s = this.child;
        this.applyRotationsToBipedPart(modelBiped.field_78116_c, this.getPartRotations(BipedPart.HEAD));
        this.applyRotationsToBipedPart(modelBiped.field_178720_f, this.getPartRotations(BipedPart.HEAD));
        this.applyRotationsToBipedPart(modelBiped.field_78115_e, this.getPartRotations(BipedPart.CHEST));
        this.applyRotationsToBipedPart(modelBiped.field_178730_v, this.getPartRotations(BipedPart.CHEST));
        this.applyRotationsToBipedPart(modelBiped.field_178724_i, this.getPartRotations(BipedPart.LEFT_ARM));
        this.applyRotationsToBipedPart(modelBiped.field_178734_a, this.getPartRotations(BipedPart.LEFT_ARM));
        this.applyRotationsToBipedPart(modelBiped.field_178723_h, this.getPartRotations(BipedPart.RIGHT_ARM));
        this.applyRotationsToBipedPart(modelBiped.field_178732_b, this.getPartRotations(BipedPart.RIGHT_ARM));
        this.applyRotationsToBipedPart(modelBiped.field_178722_k, this.getPartRotations(BipedPart.LEFT_LEG));
        this.applyRotationsToBipedPart(modelBiped.field_178733_c, this.getPartRotations(BipedPart.LEFT_LEG));
        this.applyRotationsToBipedPart(modelBiped.field_178721_j, this.getPartRotations(BipedPart.RIGHT_LEG));
        this.applyRotationsToBipedPart(modelBiped.field_178731_d, this.getPartRotations(BipedPart.RIGHT_LEG));
    }

    public void applyRotationsToBiped(ModelBiped modelBiped) {
        modelBiped.field_78091_s = this.child;
        this.applyRotationsToBipedPart(modelBiped.field_78116_c, this.getPartRotations(BipedPart.HEAD));
        this.applyRotationsToBipedPart(modelBiped.field_178720_f, this.getPartRotations(BipedPart.HEAD));
        this.applyRotationsToBipedPart(modelBiped.field_78115_e, this.getPartRotations(BipedPart.CHEST));
        this.applyRotationsToBipedPart(modelBiped.field_178724_i, this.getPartRotations(BipedPart.LEFT_ARM));
        this.applyRotationsToBipedPart(modelBiped.field_178723_h, this.getPartRotations(BipedPart.RIGHT_ARM));
        this.applyRotationsToBipedPart(modelBiped.field_178722_k, this.getPartRotations(BipedPart.LEFT_LEG));
        this.applyRotationsToBipedPart(modelBiped.field_178721_j, this.getPartRotations(BipedPart.RIGHT_LEG));
    }

    public void applyRotationsToBipedPart(ModelRenderer modelRenderer, float[] partRotations) {
        modelRenderer.field_78795_f = partRotations[0];
        modelRenderer.field_78796_g = partRotations[1];
        modelRenderer.field_78808_h = partRotations[2];
    }

    public void getRotationsFromBiped(ModelBiped modelBiped) {
        this.setPartRotations(BipedPart.HEAD, this.getRotationsFromBipedPart(modelBiped.field_78116_c));
        this.setPartRotations(BipedPart.CHEST, this.getRotationsFromBipedPart(modelBiped.field_78115_e));
        this.setPartRotations(BipedPart.LEFT_ARM, this.getRotationsFromBipedPart(modelBiped.field_178724_i));
        this.setPartRotations(BipedPart.RIGHT_ARM, this.getRotationsFromBipedPart(modelBiped.field_178723_h));
        this.setPartRotations(BipedPart.LEFT_LEG, this.getRotationsFromBipedPart(modelBiped.field_178722_k));
        this.setPartRotations(BipedPart.RIGHT_LEG, this.getRotationsFromBipedPart(modelBiped.field_178721_j));
    }

    public float[] getRotationsFromBipedPart(ModelRenderer modelRenderer) {
        return new float[]{modelRenderer.field_78795_f, modelRenderer.field_78796_g, modelRenderer.field_78808_h};
    }

    public void loadNBTData(NBTTagCompound compound) {
        if (compound.func_150297_b(TAG_ROTATION_DATA, 9)) {
            NBTTagList list = compound.func_150295_c(TAG_ROTATION_DATA, 5);
            int totalRotations = BipedPart.values().length * 3;
            if (list.func_74745_c() >= totalRotations) {
                int counter = 0;
                for (BipedPart bipedPart : BipedPart.values()) {
                    NBTTagFloat rot1 = (NBTTagFloat)list.func_179238_g(counter);
                    NBTTagFloat rot2 = (NBTTagFloat)list.func_179238_g(counter + 1);
                    NBTTagFloat rot3 = (NBTTagFloat)list.func_179238_g(counter + 2);
                    counter += 3;
                    this.setPartRotations(bipedPart, rot1.func_150288_h(), rot2.func_150288_h(), rot3.func_150288_h());
                }
            }
        }
        if (compound.func_150297_b(TAG_CHILD, 1)) {
            this.child = compound.func_74767_n(TAG_CHILD);
        }
    }

    public NBTTagCompound saveNBTData(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (BipedPart bipedPart : BipedPart.values()) {
            float[] rots = this.getPartRotations(bipedPart);
            for (int i = 0; i < rots.length; ++i) {
                list.func_74742_a((NBTBase)new NBTTagFloat(rots[i]));
            }
        }
        compound.func_74782_a(TAG_ROTATION_DATA, (NBTBase)list);
        compound.func_74757_a(TAG_CHILD, this.child);
        return compound;
    }

    public void readFromBuf(ByteBuf buf) {
        for (BipedPart bipedPart : BipedPart.values()) {
            float rot1 = buf.readFloat();
            float rot2 = buf.readFloat();
            float rot3 = buf.readFloat();
            this.setPartRotations(bipedPart, rot1, rot2, rot3);
        }
        this.child = buf.readBoolean();
    }

    public void writeToBuf(ByteBuf buf) {
        for (BipedPart bipedPart : BipedPart.values()) {
            float[] rots = this.getPartRotations(bipedPart);
            for (int i = 0; i < rots.length; ++i) {
                buf.writeFloat(rots[i]);
            }
        }
        buf.writeBoolean(this.child);
    }

    public BipedRotations copy() {
        BipedRotations rotations = new BipedRotations();
        rotations.loadNBTData(this.saveNBTData(new NBTTagCompound()));
        return rotations;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.child ? 1231 : 1237);
        result = 31 * result + Arrays.deepHashCode((Object[])this.rotationData);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BipedRotations other = (BipedRotations)obj;
        if (this.child != other.child) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.rotationData, (Object[])other.rotationData);
    }

    public String toString() {
        return "BipedRotations [rotationData=" + Arrays.deepToString((Object[])this.rotationData) + ", child=" + this.child + "]";
    }

    public static enum BipedPart {
        HEAD,
        CHEST,
        LEFT_ARM,
        RIGHT_ARM,
        LEFT_LEG,
        RIGHT_LEG;

    }
}

