/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.init.blocks;

import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.client.texture.PlayerTexture;
import moe.plushie.armourers_workshop.common.data.type.TextureType;
import moe.plushie.armourers_workshop.common.init.blocks.AbstractModBlockContainer;
import moe.plushie.armourers_workshop.common.lib.EnumGuiId;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityArmourer;
import moe.plushie.armourers_workshop.utils.BlockUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockArmourer
extends AbstractModBlockContainer {
    public BlockArmourer() {
        super("armourer");
        this.func_149647_a(ArmourersWorkshop.TAB_PAINTING_TOOLS);
        this.setSortPriority(200);
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)placer;
            TileEntity te = worldIn.func_175625_s(pos);
            if (te != null && te instanceof TileEntityArmourer) {
                EnumFacing direction = BlockUtils.determineDirectionSide(placer).func_176734_d();
                ((TileEntityArmourer)te).setDirection(EnumFacing.NORTH);
                if (!worldIn.field_72995_K) {
                    ((TileEntityArmourer)te).setTexture(new PlayerTexture(player.func_70005_c_(), TextureType.USER));
                    ((TileEntityArmourer)te).onPlaced();
                }
            }
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null & te instanceof TileEntityArmourer) {
            ((TileEntityArmourer)te).preRemove();
        }
        BlockUtils.dropInventoryBlocks(worldIn, pos);
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null & te instanceof TileEntityArmourer) {
            ((TileEntityArmourer)te).preRemove();
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!playerIn.func_175151_a(pos, facing, playerIn.func_184586_b(hand))) {
            return false;
        }
        this.openGui(playerIn, EnumGuiId.ARMOURER, worldIn, pos, state, facing);
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityArmourer();
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return null;
    }
}

