/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.init.items;

import moe.plushie.armourers_workshop.api.common.capability.IPlayerWardrobeCap;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.common.capability.wardrobe.player.PlayerWardrobeCap;
import moe.plushie.armourers_workshop.common.init.items.AbstractModItem;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSkinUnlock
extends AbstractModItem {
    private final ISkinType[] VALID_SKINS = new ISkinType[]{SkinTypeRegistry.skinHead, SkinTypeRegistry.skinChest, SkinTypeRegistry.skinLegs, SkinTypeRegistry.skinFeet, SkinTypeRegistry.skinWings, SkinTypeRegistry.skinOutfit};

    public ItemSkinUnlock() {
        super("skin-unlock");
        this.func_77627_a(true);
        this.setSortPriority(7);
        this.func_77625_d(8);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < this.VALID_SKINS.length; ++i) {
                items.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        for (int i = 0; i < this.VALID_SKINS.length; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("armourers_workshop", this.func_77658_a()) + "-" + this.VALID_SKINS[i].getName().toLowerCase(), "inventory"));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemStack = playerIn.func_184586_b(handIn);
        ISkinType skinType = this.getSkinTypeFormStack(playerIn.func_184586_b(handIn));
        TextComponentTranslation unlocalizedSkinName = new TextComponentTranslation("skinType." + skinType.getRegistryName() + ".name", new Object[0]);
        IPlayerWardrobeCap wardrobeCap = PlayerWardrobeCap.get(playerIn);
        if (wardrobeCap == null) {
            return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
        }
        int count = wardrobeCap.getUnlockedSlotsForSkinType(skinType) + 1;
        if (count <= wardrobeCap.getMaxSlotsForSkinType(skinType)) {
            if (!worldIn.field_72995_K) {
                wardrobeCap.setUnlockedSlotsForSkinType(skinType, count);
                wardrobeCap.syncToPlayer((EntityPlayerMP)playerIn);
                wardrobeCap.syncToAllTracking();
                itemStack.func_190918_g(1);
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("chat.armourers_workshop:slotUnlocked", new Object[]{unlocalizedSkinName, Integer.toString(count)}));
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        if (!worldIn.field_72995_K) {
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("chat.armourers_workshop:slotUnlockedFailed", new Object[]{unlocalizedSkinName}));
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
    }

    private ISkinType getSkinTypeFormStack(ItemStack itemStack) {
        int damage = itemStack.func_77952_i();
        if (damage >= 0 & damage < this.VALID_SKINS.length) {
            return this.VALID_SKINS[damage];
        }
        return this.VALID_SKINS[0];
    }
}

