/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.init.items.paintingtool;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.api.common.painting.IPaintType;
import moe.plushie.armourers_workshop.api.common.painting.IPantable;
import moe.plushie.armourers_workshop.api.common.painting.IPantableBlock;
import moe.plushie.armourers_workshop.common.init.blocks.ModBlocks;
import moe.plushie.armourers_workshop.common.init.items.paintingtool.AbstractPaintingTool;
import moe.plushie.armourers_workshop.common.init.sounds.ModSounds;
import moe.plushie.armourers_workshop.common.network.PacketHandler;
import moe.plushie.armourers_workshop.common.network.messages.client.MessageClientToolPaintBlock;
import moe.plushie.armourers_workshop.common.painting.tool.IConfigurableTool;
import moe.plushie.armourers_workshop.common.painting.tool.ToolOption;
import moe.plushie.armourers_workshop.common.painting.tool.ToolOptions;
import moe.plushie.armourers_workshop.common.tileentities.TileEntityArmourer;
import moe.plushie.armourers_workshop.common.world.undo.UndoManager;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHueTool
extends AbstractPaintingTool
implements IConfigurableTool {
    public ItemHueTool() {
        super("hue-tool");
        this.setSortPriority(13);
    }

    @Override
    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = worldIn.func_180495_p(pos);
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af() & state.func_177230_c() == ModBlocks.COLOUR_MIXER) {
            TileEntity te = worldIn.func_175625_s(pos);
            if (te != null && te instanceof IPantable && !worldIn.field_72995_K) {
                int colour = ((IPantable)te).getColour(0);
                IPaintType paintType = ((IPantable)te).getPaintType(0);
                this.setToolColour(stack, colour);
                this.setToolPaintType(stack, paintType);
            }
            return EnumActionResult.SUCCESS;
        }
        if (state.func_177230_c() instanceof IPantableBlock) {
            if (!worldIn.field_72995_K) {
                UndoManager.begin(player);
            }
            if (((Boolean)ToolOptions.FULL_BLOCK_MODE.getValue(stack)).booleanValue()) {
                for (int i = 0; i < 6; ++i) {
                    this.usedOnBlockSide(stack, player, worldIn, pos, state.func_177230_c(), EnumFacing.field_82609_l[i], facing == EnumFacing.field_82609_l[i]);
                }
            } else {
                this.usedOnBlockSide(stack, player, worldIn, pos, state.func_177230_c(), facing, true);
            }
            if (!worldIn.field_72995_K) {
                UndoManager.end(player);
                worldIn.func_184133_a(null, pos, (SoundEvent)ModSounds.PAINT, SoundCategory.BLOCKS, 1.0f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            return EnumActionResult.SUCCESS;
        }
        if (state.func_177230_c() == ModBlocks.ARMOURER & player.func_70093_af()) {
            TileEntity te;
            if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) != null && te instanceof TileEntityArmourer) {
                ((TileEntityArmourer)te).toolUsedOnArmourer(this, worldIn, stack, player);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Override
    public void usedOnBlockSide(ItemStack stack, EntityPlayer player, World world, BlockPos pos, Block block, EnumFacing face, boolean spawnParticles) {
        boolean changeHue = (Boolean)ToolOptions.CHANGE_HUE.getValue(stack);
        boolean changeSaturation = (Boolean)ToolOptions.CHANGE_SATURATION.getValue(stack);
        boolean changeBrightness = (Boolean)ToolOptions.CHANGE_BRIGHTNESS.getValue(stack);
        boolean changePaintType = (Boolean)ToolOptions.CHANGE_PAINT_TYPE.getValue(stack);
        Color toolColour = new Color(this.getToolColour(stack));
        IPaintType paintType = this.getToolPaintType(stack);
        float[] toolhsb = Color.RGBtoHSB(toolColour.getRed(), toolColour.getGreen(), toolColour.getBlue(), null);
        IPantableBlock worldColourable = (IPantableBlock)block;
        if (worldColourable.isRemoteOnly((IBlockAccess)world, pos, face) & world.field_72995_K) {
            int oldColour = worldColourable.getColour((IBlockAccess)world, pos, face);
            byte oldPaintType = (byte)worldColourable.getPaintType((IBlockAccess)world, pos, face).getId();
            Color blockColour = new Color(oldColour);
            float[] blockhsb = Color.RGBtoHSB(blockColour.getRed(), blockColour.getGreen(), blockColour.getBlue(), null);
            float[] recolour = new float[]{blockhsb[0], blockhsb[1], blockhsb[2]};
            if (changeHue) {
                recolour[0] = toolhsb[0];
            }
            if (changeSaturation) {
                recolour[1] = toolhsb[1];
            }
            if (changeBrightness) {
                recolour[2] = toolhsb[2];
            }
            int newColour = Color.HSBtoRGB(recolour[0], recolour[1], recolour[2]);
            Color c = new Color(newColour);
            byte[] rgbt = new byte[]{(byte)c.getRed(), (byte)c.getGreen(), (byte)c.getBlue(), oldPaintType};
            if (changePaintType) {
                rgbt[3] = (byte)paintType.getId();
            }
            MessageClientToolPaintBlock message = new MessageClientToolPaintBlock(pos, face, rgbt);
            PacketHandler.networkWrapper.sendToServer((IMessage)message);
        } else if (!worldColourable.isRemoteOnly((IBlockAccess)world, pos, face) & !world.field_72995_K) {
            int oldColour = worldColourable.getColour((IBlockAccess)world, pos, face);
            byte oldPaintType = (byte)worldColourable.getPaintType((IBlockAccess)world, pos, face).getId();
            Color blockColour = new Color(oldColour);
            float[] blockhsb = Color.RGBtoHSB(blockColour.getRed(), blockColour.getGreen(), blockColour.getBlue(), null);
            float[] recolour = new float[]{blockhsb[0], blockhsb[1], blockhsb[2]};
            if (changeHue) {
                recolour[0] = toolhsb[0];
            }
            if (changeSaturation) {
                recolour[1] = toolhsb[1];
            }
            if (changeBrightness) {
                recolour[2] = toolhsb[2];
            }
            int newColour = Color.HSBtoRGB(recolour[0], recolour[1], recolour[2]);
            UndoManager.blockPainted(player, world, pos, oldColour, oldPaintType, face);
            ((IPantableBlock)block).setColour((IBlockAccess)world, pos, newColour, face);
            if (changePaintType) {
                ((IPantableBlock)block).setPaintType((IBlockAccess)world, pos, paintType, face);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        this.addOpenSettingsInformation(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public void getToolOptions(ArrayList<ToolOption<?>> toolOptionList) {
        toolOptionList.add(ToolOptions.CHANGE_HUE);
        toolOptionList.add(ToolOptions.CHANGE_SATURATION);
        toolOptionList.add(ToolOptions.CHANGE_BRIGHTNESS);
        toolOptionList.add(ToolOptions.CHANGE_PAINT_TYPE);
        toolOptionList.add(ToolOptions.FULL_BLOCK_MODE);
    }
}

