/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.common.tileentities;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.common.painting.IPantableBlock;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinPartType;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.client.gui.armourer.GuiArmourer;
import moe.plushie.armourers_workshop.client.texture.PlayerTexture;
import moe.plushie.armourers_workshop.common.data.type.TextureType;
import moe.plushie.armourers_workshop.common.exception.SkinSaveException;
import moe.plushie.armourers_workshop.common.inventory.ContainerArmourer;
import moe.plushie.armourers_workshop.common.inventory.IGuiFactory;
import moe.plushie.armourers_workshop.common.painting.IBlockPainter;
import moe.plushie.armourers_workshop.common.skin.data.SkinProperties;
import moe.plushie.armourers_workshop.common.skin.data.SkinTexture;
import moe.plushie.armourers_workshop.common.skin.type.SkinTypeRegistry;
import moe.plushie.armourers_workshop.common.tileentities.AbstractTileEntityInventory;
import moe.plushie.armourers_workshop.common.world.ArmourerWorldHelper;
import moe.plushie.armourers_workshop.common.world.undo.UndoManager;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityArmourer
extends AbstractTileEntityInventory
implements IGuiFactory {
    private static final String TAG_DIRECTION = "direction";
    private static final String TAG_TYPE = "skinType";
    private static final String TAG_SHOW_GUIDES = "showGuides";
    private static final String TAG_SHOW_HELPER = "showHelper";
    private static final String TAG_PAINT_DATA = "paintData";
    private static final String TAG_TEXTURE = "texture";
    private static final int HEIGHT_OFFSET = 1;
    private static final int INVENTORY_SIZE = 2;
    private static final AxisAlignedBB AABB = new AxisAlignedBB(-32.0, -32.0, -44.0, 64.0, 64.0, 64.0);
    private EnumFacing direction;
    private ISkinType skinType;
    private boolean showGuides = true;
    private boolean showHelper = true;
    private SkinProperties skinProps;
    private int[] paintData;
    public boolean loadedArmourItem = false;
    private PlayerTexture texture = new PlayerTexture("", TextureType.USER);
    private PlayerTexture textureOld = new PlayerTexture("", TextureType.USER);
    @SideOnly(value=Side.CLIENT)
    public SkinTexture skinTexture;

    public TileEntityArmourer() {
        super(2);
        this.direction = EnumFacing.NORTH;
        this.skinType = SkinTypeRegistry.INSTANCE.getSkinTypeFromRegistryName("armourers:head");
        this.skinProps = new SkinProperties();
        this.clearPaintData(false);
    }

    public int[] getPaintData() {
        return this.paintData;
    }

    public void setPaintData(int[] paintData) {
        this.paintData = paintData;
    }

    public void updatePaintData(int x, int y, int colour) {
        this.paintData[x + y * 64] = colour;
        this.func_70296_d();
        this.syncWithClients();
    }

    public int getPaintData(int x, int y) {
        return this.paintData[x + y * 64];
    }

    public void clearPaintData(boolean update) {
        this.paintData = new int[2048];
        for (int i = 0; i < 2048; ++i) {
            this.paintData[i] = 0xFFFFFF;
        }
        if (update) {
            this.dirtySync();
        }
    }

    public void toolUsedOnArmourer(IBlockPainter tool, World world, ItemStack stack, EntityPlayer player) {
        UndoManager.begin(player);
        this.applyToolToBlocks(tool, world, stack, player);
        UndoManager.end(player);
    }

    private void applyToolToBlocks(IBlockPainter tool, World world, ItemStack stack, EntityPlayer player) {
        if (this.skinType != null) {
            ArrayList<BlockPos> paintableCubes = ArmourerWorldHelper.getListOfPaintableCubes(this.func_145831_w(), this.func_174877_v().func_177967_a(EnumFacing.UP, 1), this.skinType);
            for (int i = 0; i < paintableCubes.size(); ++i) {
                BlockPos bl = paintableCubes.get(i);
                IBlockState blockState = world.func_180495_p(bl);
                Block block = blockState.func_177230_c();
                if (!(block instanceof IPantableBlock)) continue;
                for (int side = 0; side < 6; ++side) {
                    EnumFacing face = EnumFacing.field_82609_l[side];
                    tool.usedOnBlockSide(stack, player, world, bl, block, face, false);
                }
            }
        }
    }

    public void onPlaced() {
        this.createBoundingBoxes();
    }

    public void preRemove() {
        this.removeBoundingBoxes();
    }

    public int getHeightOffset() {
        return 1;
    }

    public void copySkinCubes(EntityPlayerMP player, ISkinPartType srcPart, ISkinPartType desPart, boolean mirror) {
        try {
            ArmourerWorldHelper.copySkinCubes(this.func_145831_w(), this.func_174877_v().func_177967_a(EnumFacing.UP, 1), srcPart, desPart, mirror);
        }
        catch (SkinSaveException e) {
            player.func_145747_a((ITextComponent)new TextComponentString(e.getMessage()));
        }
    }

    public void clearArmourCubes(ISkinPartType partType) {
        if (this.skinType != null) {
            ArmourerWorldHelper.clearEquipmentCubes(this.func_145831_w(), this.func_174877_v().func_177967_a(EnumFacing.UP, 1), this.skinType, this.skinProps, partType);
            SkinProperties newSkinProps = new SkinProperties();
            SkinProperties.PROP_BLOCK_MULTIBLOCK.setValue(newSkinProps, SkinProperties.PROP_BLOCK_MULTIBLOCK.getValue(this.skinProps));
            this.setSkinProps(newSkinProps);
            this.dirtySync();
        }
    }

    public void clearMarkers(ISkinPartType partType) {
        if (this.skinType != null) {
            ArmourerWorldHelper.clearMarkers(this.func_145831_w(), this.func_174877_v().func_177967_a(EnumFacing.UP, 1), this.skinType, this.skinProps, partType);
            this.dirtySync();
        }
    }

    protected void removeBoundingBoxes() {
        if (this.skinType != null) {
            ArmourerWorldHelper.removeBoundingBoxes(this.func_145831_w(), this.func_174877_v().func_177967_a(EnumFacing.UP, 1), this.skinType);
        }
    }

    protected void createBoundingBoxes() {
        if (this.skinType != null) {
            ArmourerWorldHelper.createBoundingBoxes(this.func_145831_w(), this.func_174877_v().func_177967_a(EnumFacing.UP, 1), this.func_174877_v(), this.skinType, this.skinProps);
        }
    }

    public void setDirection(EnumFacing direction) {
        this.direction = direction;
        this.dirtySync();
    }

    public EnumFacing getDirection() {
        return this.direction;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AABB.func_186670_a(this.func_174877_v());
    }

    public ISkinType getSkinType() {
        return this.skinType;
    }

    public boolean isShowGuides() {
        return this.showGuides;
    }

    public boolean isShowHelper() {
        return this.showHelper;
    }

    public void setTexture(PlayerTexture texture) {
        this.textureOld = this.texture;
        this.texture = texture;
        this.dirtySync();
    }

    public PlayerTexture getTexture() {
        return this.texture;
    }

    public PlayerTexture getTextureOld() {
        return this.textureOld;
    }

    public void setSkinType(ISkinType skinType) {
        if (this.skinType == skinType) {
            return;
        }
        this.removeBoundingBoxes();
        this.skinType = skinType;
        SkinProperties oldProperties = this.skinProps;
        this.skinProps = new SkinProperties();
        SkinProperties.PROP_ALL_CUSTOM_NAME.setValue(this.skinProps, SkinProperties.PROP_ALL_CUSTOM_NAME.getValue(oldProperties));
        SkinProperties.PROP_ALL_FLAVOUR_TEXT.setValue(this.skinProps, SkinProperties.PROP_ALL_FLAVOUR_TEXT.getValue(oldProperties));
        this.clearPaintData(true);
        this.createBoundingBoxes();
        this.dirtySync();
    }

    public void toggleGuides() {
        this.showGuides = !this.showGuides;
        this.dirtySync();
    }

    public void toggleHelper() {
        this.showHelper = !this.showHelper;
        this.dirtySync();
    }

    public SkinProperties getSkinProps() {
        return this.skinProps;
    }

    public void setSkinProps(SkinProperties skinProps) {
        boolean updateBounds = false;
        if (this.skinType != null && this.skinType.getVanillaArmourSlotId() != -1) {
            updateBounds = this.skinType.haveBoundsChanged(this.skinProps, skinProps);
        }
        this.skinProps = skinProps;
        if (updateBounds) {
            this.removeBoundingBoxes();
            this.createBoundingBoxes();
        }
        this.dirtySync();
    }

    @Override
    public String func_70005_c_() {
        return "armourer";
    }

    public double func_145833_n() {
        return super.func_145833_n() * 10.0;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 5, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        this.writeCommonToNBT(compound);
        return compound;
    }

    public Packet getDescriptionPacket() {
        return this.func_189518_D_();
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        NBTTagCompound compound = packet.func_148857_g();
        PlayerTexture playerTexture = this.texture;
        this.readBaseFromNBT(compound);
        this.readCommonFromNBT(compound);
        if (!this.texture.equals(playerTexture)) {
            this.textureOld = playerTexture;
        }
        this.syncWithClients();
        this.loadedArmourItem = true;
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readCommonFromNBT(compound);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.writeCommonToNBT(compound);
        return compound;
    }

    @Override
    public void readCommonFromNBT(NBTTagCompound compound) {
        super.readCommonFromNBT(compound);
        this.direction = EnumFacing.func_82600_a((int)compound.func_74771_c(TAG_DIRECTION));
        this.skinType = SkinTypeRegistry.INSTANCE.getSkinTypeFromRegistryName(compound.func_74779_i(TAG_TYPE));
        this.showGuides = compound.func_74767_n(TAG_SHOW_GUIDES);
        if (compound.func_74764_b(TAG_SHOW_HELPER)) {
            this.showHelper = compound.func_74767_n(TAG_SHOW_HELPER);
        }
        this.skinProps = new SkinProperties();
        this.skinProps.readFromNBT(compound);
        if (compound.func_150297_b(TAG_TEXTURE, 10)) {
            this.texture = PlayerTexture.fromNBT(compound.func_74775_l(TAG_TEXTURE));
        }
        if (compound.func_74764_b(TAG_PAINT_DATA)) {
            this.paintData = compound.func_74759_k(TAG_PAINT_DATA);
        }
    }

    @Override
    public void writeCommonToNBT(NBTTagCompound compound) {
        super.writeCommonToNBT(compound);
        compound.func_74774_a(TAG_DIRECTION, (byte)this.direction.ordinal());
        if (this.skinType != null) {
            compound.func_74778_a(TAG_TYPE, this.skinType.getRegistryName());
        }
        compound.func_74757_a(TAG_SHOW_GUIDES, this.showGuides);
        compound.func_74757_a(TAG_SHOW_HELPER, this.showHelper);
        this.skinProps.writeToNBT(compound);
        NBTTagCompound textureCompound = new NBTTagCompound();
        this.texture.writeToNBT(textureCompound);
        compound.func_74782_a(TAG_TEXTURE, (NBTBase)textureCompound);
        compound.func_74783_a(TAG_PAINT_DATA, this.paintData);
    }

    @Override
    public Container getServerGuiElement(EntityPlayer player, World world, BlockPos pos) {
        return new ContainerArmourer(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getClientGuiElement(EntityPlayer player, World world, BlockPos pos) {
        return new GuiArmourer(player.field_71071_by, this);
    }
}

