/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import moe.plushie.armourers_workshop.ArmourersWorkshop;
import moe.plushie.armourers_workshop.api.common.skin.type.ISkinType;
import moe.plushie.armourers_workshop.common.exception.InvalidCubeTypeException;
import moe.plushie.armourers_workshop.common.exception.NewerFileVersionException;
import moe.plushie.armourers_workshop.common.library.LibraryFile;
import moe.plushie.armourers_workshop.common.skin.data.Skin;
import moe.plushie.armourers_workshop.common.skin.data.SkinProperties;
import moe.plushie.armourers_workshop.common.skin.data.serialize.SkinSerializer;
import moe.plushie.armourers_workshop.utils.ModLogger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.DimensionManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;

public final class SkinIOUtils {
    public static final String SKIN_FILE_EXTENSION = ".armour";

    public static boolean saveSkinFromFileName(String filePath, String fileName, Skin skin) {
        filePath = SkinIOUtils.makeFilePathValid(filePath);
        fileName = SkinIOUtils.makeFileNameValid(fileName);
        File file = new File(ArmourersWorkshop.getProxy().getSkinLibraryDirectory(), filePath + fileName);
        return SkinIOUtils.saveSkinToFile(file, skin);
    }

    public static boolean saveSkinToFile(File file, Skin skin) {
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(file);){
            SkinIOUtils.saveSkinToStream(fos, skin);
            fos.flush();
        }
        catch (FileNotFoundException e) {
            ModLogger.log(Level.WARN, "Skin file not found.");
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            ModLogger.log(Level.ERROR, "Skin file save failed.");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean saveSkinToStream(OutputStream outputStream, Skin skin) {
        try (BufferedOutputStream bos = new BufferedOutputStream(outputStream);
             DataOutputStream dos = new DataOutputStream(bos);){
            SkinSerializer.writeToStream(skin, dos);
            dos.flush();
            bos.flush();
        }
        catch (IOException e) {
            ModLogger.log(Level.ERROR, "Skin file save failed.");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static Skin loadSkinFromLibraryFile(LibraryFile libraryFile) {
        return SkinIOUtils.loadSkinFromFileName(libraryFile.getFullName() + SKIN_FILE_EXTENSION);
    }

    public static Skin loadSkinFromFileName(String fileName) {
        File file = new File(ArmourersWorkshop.getProxy().getSkinLibraryDirectory(), fileName);
        if (!SkinIOUtils.isInSubDirectory(ArmourersWorkshop.getProxy().getSkinLibraryDirectory(), file)) {
            ModLogger.log(Level.WARN, "Player tried to load a file in a invalid location.");
            ModLogger.log(Level.WARN, String.format("The file was: %s", file.getAbsolutePath().replace("%", "")));
            return null;
        }
        return SkinIOUtils.loadSkinFromFile(file);
    }

    public static Skin loadSkinFromFile(File file) {
        Skin skin = null;
        try (FileInputStream fis = new FileInputStream(file);){
            skin = SkinIOUtils.loadSkinFromStream(fis);
        }
        catch (FileNotFoundException e) {
            ModLogger.log(Level.WARN, "Skin file not found.");
            ModLogger.log(Level.WARN, file);
        }
        catch (IOException e) {
            ModLogger.log(Level.ERROR, "Skin file load failed.");
            e.printStackTrace();
        }
        catch (Exception e) {
            ModLogger.log(Level.ERROR, "Unable to load skin. Unknown error.");
            e.printStackTrace();
        }
        if (skin == null && (skin = SkinIOUtils.loadSkinRecovery(file)) != null) {
            ModLogger.log(Level.WARN, "Loaded skin with recovery system.");
        }
        return skin;
    }

    public static Skin loadSkinFromStream(InputStream inputStream) {
        Skin skin = null;
        try (BufferedInputStream bis = new BufferedInputStream(inputStream);
             DataInputStream dis = new DataInputStream(bis);){
            skin = SkinSerializer.readSkinFromStream(dis);
        }
        catch (IOException e) {
            ModLogger.log(Level.ERROR, "Skin file load failed.");
            e.printStackTrace();
        }
        catch (NewerFileVersionException e) {
            ModLogger.log(Level.ERROR, "Can not load skin file it was saved in newer version.");
            e.printStackTrace();
        }
        catch (InvalidCubeTypeException e) {
            ModLogger.log(Level.ERROR, "Unable to load skin. Unknown cube types found.");
            e.printStackTrace();
        }
        catch (Exception e) {
            ModLogger.log(Level.ERROR, "Unable to load skin. Unknown error.");
            e.printStackTrace();
        }
        return skin;
    }

    private static Skin loadSkinRecovery(File file) {
        Skin skin = null;
        try {
            byte[] fileBytes = Files.readAllBytes(file.toPath());
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            for (int i = 0; i < fileBytes.length; ++i) {
                if (fileBytes[i] != 10 || fileBytes[i - 1] == 0) continue;
                indexes.add(i - 1);
            }
            byte[] newFile = new byte[fileBytes.length - indexes.size()];
            int newFileIndex = 0;
            for (int i = 0; i < fileBytes.length; ++i) {
                if (SkinIOUtils.isInArrayList(i, indexes)) continue;
                newFile[newFileIndex] = fileBytes[i];
                ++newFileIndex;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(newFile);
            skin = SkinIOUtils.loadSkinFromStream(bais);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return skin;
    }

    private static boolean isInArrayList(int index, ArrayList<Integer> list) {
        for (int j = 0; j < list.size(); ++j) {
            if (index != list.get(j)) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public static ISkinType getSkinTypeNameFromFile(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void makeDatabaseDirectory() {
        File directory = SkinIOUtils.getSkinDatabaseDirectory();
        ModLogger.log("Loading skin database at: " + directory.getAbsolutePath());
        SkinIOUtils.copyGlobalDatabase();
        if (!directory.exists()) {
            directory.mkdir();
        }
    }

    public static void copyGlobalDatabase() {
        ArmourersWorkshop.getInstance();
        File dirGlobalDatabase = ArmourersWorkshop.getProxy().getGlobalSkinDatabaseDirectory();
        if (dirGlobalDatabase.exists()) {
            File dirWorldDatabase = SkinIOUtils.getSkinDatabaseDirectory();
            File[] globalFiles = dirGlobalDatabase.listFiles();
            for (int i = 0; i < globalFiles.length; ++i) {
                File globalFile = globalFiles[i];
                File worldFile = new File(dirWorldDatabase, globalFile.getName());
                if (!(!globalFile.getName().equals("readme.txt") & !worldFile.exists())) continue;
                try {
                    FileUtils.copyFile((File)globalFile, (File)worldFile);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        SkinIOUtils.createGlobalDatabaseReadme();
    }

    private static void createGlobalDatabaseReadme() {
        ArmourersWorkshop.getInstance();
        File globalDatabaseReadme = new File(ArmourersWorkshop.getProxy().getGlobalSkinDatabaseDirectory(), "readme.txt");
        ArmourersWorkshop.getInstance();
        if (!ArmourersWorkshop.getProxy().getGlobalSkinDatabaseDirectory().exists()) {
            ArmourersWorkshop.getInstance();
            ArmourersWorkshop.getProxy().getGlobalSkinDatabaseDirectory().mkdirs();
        }
        if (!globalDatabaseReadme.exists()) {
            DataOutputStream outputStream = null;
            try {
                String crlf = "\r\n";
                outputStream = new DataOutputStream(new FileOutputStream(globalDatabaseReadme));
                outputStream.writeBytes("Any files placed in this directory will be copied into the skin-database folder of any worlds that are loaded." + crlf);
                outputStream.writeBytes("Please read Info for Map & Mod Pack Makers on the main forum post if you want to know how to use this." + crlf);
                outputStream.writeBytes("http://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/wip-mods/2309193-wip-alpha-armourers-workshop-weapon-armour-skins");
                outputStream.flush();
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                IOUtils.closeQuietly(outputStream);
            }
        }
    }

    public static File getSkinDatabaseDirectory() {
        return new File(DimensionManager.getCurrentSaveRootDirectory(), "skin-database");
    }

    public static boolean createDirectory(File file) {
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    public static void recoverSkins(EntityPlayer player) {
        player.func_145747_a((ITextComponent)new TextComponentString("Starting skin recovery."));
        File skinDir = SkinIOUtils.getSkinDatabaseDirectory();
        if (skinDir.exists() & skinDir.isDirectory()) {
            File recoverDir = new File(System.getProperty("user.dir"), "recovered-skins");
            if (!recoverDir.exists()) {
                recoverDir.mkdirs();
            }
            File[] skinFiles = skinDir.listFiles();
            player.func_145747_a((ITextComponent)new TextComponentString(String.format("Found %d skins to be recovered.", skinFiles.length)));
            player.func_145747_a((ITextComponent)new TextComponentString("Working..."));
            int unnamedSkinCount = 0;
            int successCount = 0;
            int failCount = 0;
            for (int i = 0; i < skinFiles.length; ++i) {
                File skinFile = skinFiles[i];
                Skin skin = SkinIOUtils.loadSkinFromFile(skinFile);
                if (skin != null) {
                    int nameCount;
                    File newSkinFile;
                    String fileName = skin.getProperties().getPropertyString("fileName", null);
                    String customName = SkinProperties.PROP_ALL_CUSTOM_NAME.getValue(skin.getProperties());
                    if (!StringUtils.func_151246_b((String)fileName)) {
                        newSkinFile = new File(recoverDir, (fileName = SkinIOUtils.makeFileNameValid(fileName)) + SKIN_FILE_EXTENSION);
                        if (newSkinFile.exists()) {
                            nameCount = 0;
                            while ((newSkinFile = new File(recoverDir, fileName + "-" + ++nameCount + SKIN_FILE_EXTENSION)).exists()) {
                            }
                        }
                        SkinIOUtils.saveSkinToFile(newSkinFile, skin);
                        ++successCount;
                        continue;
                    }
                    if (!StringUtils.func_151246_b((String)customName)) {
                        newSkinFile = new File(recoverDir, (customName = SkinIOUtils.makeFileNameValid(customName)) + SKIN_FILE_EXTENSION);
                        if (newSkinFile.exists()) {
                            nameCount = 0;
                            while ((newSkinFile = new File(recoverDir, customName + "-" + ++nameCount + SKIN_FILE_EXTENSION)).exists()) {
                            }
                        }
                        SkinIOUtils.saveSkinToFile(newSkinFile, skin);
                        ++successCount;
                        continue;
                    }
                    SkinIOUtils.saveSkinToFile(new File(recoverDir, "unnamed-skin-" + ++unnamedSkinCount + SKIN_FILE_EXTENSION), skin);
                    ++successCount;
                    continue;
                }
                ++failCount;
            }
            player.func_145747_a((ITextComponent)new TextComponentString("Finished skin recovery."));
            player.func_145747_a((ITextComponent)new TextComponentString(String.format("%d skins were recovered and %d fail recovery.", successCount, failCount)));
        } else {
            player.func_145747_a((ITextComponent)new TextComponentString("No skins found to recover."));
        }
    }

    public static void updateSkins(EntityPlayer player) {
        File updateDir = new File(System.getProperty("user.dir"), "skin-update");
        if (!updateDir.exists() & updateDir.isDirectory()) {
            player.func_145747_a((ITextComponent)new TextComponentString("Directory skin-update not found."));
            return;
        }
        File outputDir = new File(updateDir, "updated");
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
        File[] skinFiles = updateDir.listFiles();
        player.func_145747_a((ITextComponent)new TextComponentString(String.format("Found %d skins to be updated.", skinFiles.length)));
        player.func_145747_a((ITextComponent)new TextComponentString("Working..."));
        int successCount = 0;
        int failCount = 0;
        for (int i = 0; i < skinFiles.length; ++i) {
            File skinFile = skinFiles[i];
            if (!skinFile.isFile()) continue;
            Skin skin = SkinIOUtils.loadSkinFromFile(skinFile);
            if (skin != null) {
                if (SkinIOUtils.saveSkinToFile(new File(outputDir, skinFile.getName()), skin)) {
                    ++successCount;
                    continue;
                }
                ModLogger.log(Level.ERROR, "Failed to update skin " + skinFile.getName());
                ++failCount;
                continue;
            }
            ModLogger.log(Level.ERROR, "Failed to update skin " + skinFile.getName());
            ++failCount;
        }
        player.func_145747_a((ITextComponent)new TextComponentString("Finished skin update."));
        player.func_145747_a((ITextComponent)new TextComponentString(String.format("%d skins were updated and %d failed.", successCount, failCount)));
    }

    public static boolean isInSubDirectory(File dir, File file) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            // empty if block
        }
        if (file.getParentFile().equals(dir)) {
            return true;
        }
        return SkinIOUtils.isInSubDirectory(dir, file.getParentFile());
    }

    public static String makeFileNameValid(String fileName) {
        fileName = fileName.replaceAll("[<>:\"/\\\\|?*]", "_");
        return fileName;
    }

    public static String makeFilePathValid(String filePath) {
        filePath = filePath.replace("\\", "/");
        filePath = filePath.replace("../", "_");
        filePath = filePath.replaceAll("[<>:\"|?*]", "_");
        return filePath;
    }

    public static boolean isInLibraryDir(File file) {
        return SkinIOUtils.isInSubDirectory(file, ArmourersWorkshop.getProxy().getSkinLibraryDirectory());
    }
}

