/*
 * Decompiled with CFR 0.152.
 */
package com.driga.jmodelloader.packet;

import com.driga.jmodelloader.JModelLoader;
import com.driga.jmodelloader.key.Key;
import com.driga.jmodelloader.obj.armor.ArmorRegistry;
import com.driga.jmodelloader.obj.armor.manager.CustomArmorManagerClient;
import io.netty.buffer.ByteBuf;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSendKey
implements IMessage {
    private String key;

    public PacketSendKey() {
        InputStream inputStream = JModelLoader.class.getResourceAsStream("/assets/jmodelloader/EncryptKey.txt");
        this.key = this.inputStreamToString(inputStream);
    }

    public void fromBytes(ByteBuf buf) {
        this.key = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.key);
    }

    private String inputStreamToString(InputStream inputStream) {
        String text = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
        return text;
    }

    public static class Handler
    implements IMessageHandler<PacketSendKey, IMessage> {
        public IMessage onMessage(PacketSendKey message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketSendKey message, MessageContext ctx) {
            Key.setKey(message.key);
            CustomArmorManagerClient.registerModels();
            ArmorRegistry.Instance.registerAllModels();
        }
    }
}

