/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.orecruncher.lib.ForgeUtils;
import org.orecruncher.lib.Localization;

public final class VersionChecker {
    private final String modId;
    private final String messageId;

    public VersionChecker(@Nonnull String id, @Nonnull String messageId) {
        this.modId = id;
        this.messageId = messageId;
    }

    private static boolean dontPrintMessage(@Nonnull ForgeVersion.CheckResult result) {
        return result == null || result.status == null || result.target == null || result.url == null || result.status == ForgeVersion.Status.UP_TO_DATE || result.status == ForgeVersion.Status.AHEAD || result.status == ForgeVersion.Status.PENDING || result.status == ForgeVersion.Status.FAILED;
    }

    @Nullable
    private String getUpdateMessage(@Nonnull String modId) {
        ModContainer mod = ForgeUtils.findModContainer(modId);
        if (mod == null) {
            return null;
        }
        ForgeVersion.CheckResult result = ForgeVersion.getResult((ModContainer)mod);
        if (VersionChecker.dontPrintMessage(result)) {
            return null;
        }
        String t = result.target.toString();
        String u = result.url.toString();
        return Localization.format(this.messageId, mod.getName(), t, u);
    }

    public void playerLogin(@Nonnull PlayerEvent.PlayerLoggedInEvent event) {
        String updateMessage;
        if (event.player instanceof EntityPlayer && (updateMessage = this.getUpdateMessage(this.modId)) != null) {
            try {
                ITextComponent component = ITextComponent.Serializer.func_150699_a((String)updateMessage);
                event.player.func_145747_a(component);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static void doCheck(@Nonnull PlayerEvent.PlayerLoggedInEvent event, @Nonnull String modId) {
        VersionChecker.doCheck(event, modId, modId + ".msg.NewVersion");
    }

    public static void doCheck(@Nonnull PlayerEvent.PlayerLoggedInEvent event, @Nonnull String modId, @Nonnull String msgId) {
        if (event.player instanceof EntityPlayer) {
            new VersionChecker(modId, msgId).playerLogin(event);
        }
    }
}

