/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import foxz.utils.Market;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.ServerEventsHandler;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.blocks.tiles.TileScripted;
import noppes.npcs.config.ConfigDebug;
import noppes.npcs.config.ConfigMain;
import noppes.npcs.config.ConfigScript;
import noppes.npcs.constants.EnumCompanionStage;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumJobType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.constants.EnumPlayerData;
import noppes.npcs.constants.EnumQuestCompletion;
import noppes.npcs.constants.EnumRoleType;
import noppes.npcs.containers.ContainerCustomGui;
import noppes.npcs.containers.ContainerMail;
import noppes.npcs.controllers.AnimationController;
import noppes.npcs.controllers.BankController;
import noppes.npcs.controllers.CustomGuiController;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.LinkedNpcController;
import noppes.npcs.controllers.PartyController;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.ServerTagMapController;
import noppes.npcs.controllers.SpawnController;
import noppes.npcs.controllers.TagController;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.data.Animation;
import noppes.npcs.controllers.data.Bank;
import noppes.npcs.controllers.data.DataScript;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.DialogCategory;
import noppes.npcs.controllers.data.DialogOption;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.ForgeDataScript;
import noppes.npcs.controllers.data.GlobalNPCDataScript;
import noppes.npcs.controllers.data.IScriptHandler;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.controllers.data.Party;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerDataScript;
import noppes.npcs.controllers.data.PlayerMail;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestCategory;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.controllers.data.RecipeCarpentry;
import noppes.npcs.controllers.data.SpawnData;
import noppes.npcs.controllers.data.Tag;
import noppes.npcs.controllers.data.TagMap;
import noppes.npcs.controllers.data.TransportLocation;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobSpawner;
import noppes.npcs.roles.RoleCompanion;
import noppes.npcs.roles.RoleTrader;
import noppes.npcs.roles.RoleTransporter;
import noppes.npcs.scripted.NpcAPI;
import noppes.npcs.scripted.event.PartyEvent;
import noppes.npcs.scripted.gui.ScriptGui;
import noppes.npcs.scripted.item.ScriptCustomItem;

public class PacketHandlerServer {
    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        if (ConfigMain.OpsOnly && !NoppesUtilServer.isOp((EntityPlayer)player)) {
            this.warn((EntityPlayer)player, "tried to use custom npcs without being an op");
            return;
        }
        ByteBuf buffer = event.packet.payload();
        EnumPacketServer type = null;
        try {
            type = EnumPacketServer.values()[buffer.readInt()];
            ItemStack item = player.field_71071_by.func_70448_g();
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            if (type == EnumPacketServer.IsGuiOpen) {
                this.isGuiOpenPacket(buffer, player);
                return;
            }
            if (type == EnumPacketServer.CustomGuiButton && player.field_71070_bA instanceof ContainerCustomGui) {
                ((ContainerCustomGui)player.field_71070_bA).customGui.fromNBT(Server.readNBT(buffer));
                EventHooks.onCustomGuiButton((IPlayer)NpcAPI.Instance().getIEntity((Entity)player), ((ContainerCustomGui)player.field_71070_bA).customGui, buffer.readInt());
                return;
            }
            if (type == EnumPacketServer.CustomGuiUnfocused && player.field_71070_bA instanceof ContainerCustomGui) {
                ((ContainerCustomGui)player.field_71070_bA).customGui.fromNBT(Server.readNBT(buffer));
                EventHooks.onCustomGuiUnfocused((IPlayer)NpcAPI.Instance().getIEntity((Entity)player), ((ContainerCustomGui)player.field_71070_bA).customGui, buffer.readInt());
                return;
            }
            if (type == EnumPacketServer.CustomGuiScrollClick && player.field_71070_bA instanceof ContainerCustomGui) {
                ((ContainerCustomGui)player.field_71070_bA).customGui.fromNBT(Server.readNBT(buffer));
                EventHooks.onCustomGuiScrollClick((IPlayer)NpcAPI.Instance().getIEntity((Entity)player), ((ContainerCustomGui)player.field_71070_bA).customGui, buffer.readInt(), buffer.readInt(), CustomGuiController.readScrollSelection(buffer), buffer.readBoolean());
                return;
            }
            if (type == EnumPacketServer.CustomGuiClose) {
                EventHooks.onCustomGuiClose((IPlayer)NpcAPI.Instance().getIEntity((Entity)player), new ScriptGui().fromNBT(Server.readNBT(buffer)));
                return;
            }
            if (type == EnumPacketServer.QuestLogToServer) {
                NoppesUtilPlayer.updateQuestLogData(buffer, player);
                return;
            }
            if (type == EnumPacketServer.PartyLogToServer) {
                NoppesUtilPlayer.updatePartyQuestLogData(buffer, player);
                return;
            }
            if (type == EnumPacketServer.UntrackQuest) {
                NoppesUtilPlayer.clearTrackQuest(player);
                return;
            }
            if (type == EnumPacketServer.DimensionsGet) {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                Integer[] integerArray = DimensionManager.getStaticDimensionIDs();
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int id = integerArray[i];
                    WorldProvider provider = DimensionManager.createProviderFor((int)id);
                    map.put(provider.func_80007_l(), id);
                }
                NoppesUtilServer.sendScrollData(player, map);
            } else if (type == EnumPacketServer.TagsGet) {
                NoppesUtilServer.sendTagDataAll(player);
            } else if (type == EnumPacketServer.NpcTagsGet) {
                NBTTagCompound compound = new NBTTagCompound();
                NBTTagList tagList = new NBTTagList();
                for (UUID uuid : npc.advanced.tagUUIDs) {
                    Tag tag = TagController.getInstance().getTagFromUUID(uuid);
                    if (tag == null) continue;
                    tagList.func_74742_a((NBTBase)new NBTTagString(tag.name));
                }
                compound.func_74782_a("TagNames", (NBTBase)tagList);
                Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
            } else {
                if (type == EnumPacketServer.CacheAnimation) {
                    PlayerDataController.Instance.getPlayerData((EntityPlayer)player).animationData.cacheAnimation(buffer.readInt());
                    return;
                }
                if (type == EnumPacketServer.GetPartyData || type == EnumPacketServer.CreateParty) {
                    if (!ConfigMain.PartiesEnabled) {
                        return;
                    }
                    if (type == EnumPacketServer.CreateParty) {
                        Party party = PartyController.Instance().createParty();
                        party.addPlayer((EntityPlayer)player);
                        party.setLeader((EntityPlayer)player);
                    }
                    PacketHandlerServer.sendPartyData(player);
                } else if (type == EnumPacketServer.DisbandParty) {
                    PlayerData playerData = PlayerDataController.Instance.getPlayerData((EntityPlayer)player);
                    if (playerData.partyUUID != null) {
                        PartyController.Instance().disbandParty(playerData.partyUUID);
                    }
                    NBTTagCompound compound = new NBTTagCompound();
                    compound.func_74757_a("Disband", true);
                    Server.sendData(player, EnumPacketClient.PARTY_DATA, compound);
                } else if (type == EnumPacketServer.KickPlayer) {
                    Party party;
                    String kickPlayerName = Server.readString(buffer);
                    EntityPlayer kickPlayer = NoppesUtilServer.getPlayerByName(kickPlayerName);
                    PlayerData playerData = null;
                    UUID playerUUID = null;
                    if (kickPlayer != null) {
                        playerData = PlayerDataController.Instance.getPlayerData((EntityPlayer)player);
                    } else {
                        String uuid = PlayerDataController.Instance.getPlayerUUIDFromName(kickPlayerName);
                        if (!uuid.isEmpty()) {
                            playerData = PlayerDataController.Instance.getPlayerDataCache(uuid);
                            playerUUID = UUID.fromString(uuid);
                        }
                    }
                    if (playerData != null && playerData.partyUUID != null && !(party = PartyController.Instance().getParty(playerData.partyUUID)).getIsLocked()) {
                        PartyEvent.PartyKickEvent partyEvent = new PartyEvent.PartyKickEvent(party, party.getQuest(), (IPlayer)NpcAPI.Instance().getIEntity((Entity)kickPlayer));
                        EventHooks.onPartyKick(partyEvent);
                        if (!partyEvent.isCancelled()) {
                            boolean successful = party.removePlayer(kickPlayer);
                            if (!successful) {
                                successful = party.removePlayer(playerUUID);
                            }
                            if (successful) {
                                if (kickPlayer != null) {
                                    PacketHandlerServer.sendInviteData((EntityPlayerMP)kickPlayer);
                                }
                                PartyController.Instance().pingPartyUpdate(party);
                                PartyController.Instance().sendKickMessages(party, kickPlayer, kickPlayerName);
                            }
                        }
                    }
                } else if (type == EnumPacketServer.LeavePlayer) {
                    EntityPlayer leavingPlayer = NoppesUtilServer.getPlayerByName(Server.readString(buffer));
                    if (leavingPlayer != null) {
                        Party party;
                        boolean successful;
                        PlayerData playerData = PlayerDataController.Instance.getPlayerData((EntityPlayer)player);
                        if (playerData.partyUUID != null && (successful = (party = PartyController.Instance().getParty(playerData.partyUUID)).removePlayer(leavingPlayer))) {
                            PartyEvent.PartyLeaveEvent partyEvent = new PartyEvent.PartyLeaveEvent(party, party.getQuest(), (IPlayer)NpcAPI.Instance().getIEntity((Entity)leavingPlayer));
                            EventHooks.onPartyLeave(partyEvent);
                            PacketHandlerServer.sendInviteData((EntityPlayerMP)leavingPlayer);
                            PartyController.Instance().pingPartyUpdate(party);
                            PartyController.Instance().sendLeavingMessages(party, leavingPlayer);
                        }
                    }
                } else if (type == EnumPacketServer.SavePartyData) {
                    PlayerData playerData = PlayerDataController.Instance.getPlayerData((EntityPlayer)player);
                    if (playerData.partyUUID != null) {
                        Party party = PartyController.Instance().getParty(playerData.partyUUID);
                        party.readClientNBT(Server.readNBT(buffer));
                    }
                } else if (type == EnumPacketServer.SetPartyLeader) {
                    Party party;
                    PlayerData playerData = PlayerDataController.Instance.getPlayerData((EntityPlayer)player);
                    if (playerData.partyUUID != null && !(party = PartyController.Instance().getParty(playerData.partyUUID)).getIsLocked()) {
                        party.setLeader(NoppesUtilServer.getPlayerByName(Server.readString(buffer)));
                        PartyController.Instance().pingPartyUpdate(party);
                    }
                } else if (type == EnumPacketServer.PartyInvite) {
                    EntityPlayer invitedPlayer = NoppesUtilServer.getPlayerByName(Server.readString(buffer));
                    if (invitedPlayer != null) {
                        Party party;
                        PlayerData senderData = PlayerDataController.Instance.getPlayerData((EntityPlayer)player);
                        PlayerData invitedData = PlayerDataController.Instance.getPlayerData(invitedPlayer);
                        if (senderData.partyUUID != null && invitedData.partyUUID == null && !(party = PartyController.Instance().getParty(senderData.partyUUID)).getIsLocked()) {
                            PartyEvent.PartyInviteEvent partyEvent = new PartyEvent.PartyInviteEvent(party, party.getQuest(), (IPlayer)NpcAPI.Instance().getIEntity((Entity)invitedPlayer));
                            EventHooks.onPartyInvite(partyEvent);
                            if (!partyEvent.isCancelled()) {
                                invitedData.inviteToParty(party);
                                PacketHandlerServer.sendInviteData((EntityPlayerMP)invitedPlayer);
                            }
                        }
                    }
                } else if (type == EnumPacketServer.GetPartyInviteList) {
                    PacketHandlerServer.sendInviteData(player);
                } else if (type == EnumPacketServer.AcceptInvite) {
                    PlayerData playerData = PlayerDataController.Instance.getPlayerData((EntityPlayer)player);
                    String uuidString = Server.readString(buffer);
                    if (uuidString != null) {
                        UUID uuid = UUID.fromString(uuidString);
                        playerData.acceptInvite(uuid);
                    }
                } else if (type == EnumPacketServer.IgnoreInvite) {
                    PlayerData playerData = PlayerDataController.Instance.getPlayerData((EntityPlayer)player);
                    String uuidString = Server.readString(buffer);
                    if (uuidString != null) {
                        UUID uuid = UUID.fromString(uuidString);
                        playerData.ignoreInvite(uuid);
                    }
                } else if (type == EnumPacketServer.SetPartyQuest) {
                    Party party;
                    PlayerData playerData = PlayerDataController.Instance.getPlayerData((EntityPlayer)player);
                    if (playerData.partyUUID != null && (party = PartyController.Instance().getParty(playerData.partyUUID)) != null && party.getLeaderUUID().equals(player.func_110124_au())) {
                        Quest foundQuest;
                        int questID = buffer.readInt();
                        party.setQuest(null);
                        if (questID != -1 && (foundQuest = QuestController.Instance.quests.get(questID)) != null && foundQuest.partyOptions.allowParty && party.validateQuest(questID, true)) {
                            PartyEvent.PartyQuestSetEvent partyEvent = new PartyEvent.PartyQuestSetEvent(party, foundQuest);
                            EventHooks.onPartyQuestSet(partyEvent);
                            if (!partyEvent.isCancelled()) {
                                if (playerData.questData.hasActiveQuest(questID)) {
                                    QuestData questdata = new QuestData(foundQuest);
                                    playerData.questData.activeQuests.put(questID, questdata);
                                }
                                party.setQuest(foundQuest);
                                PartyController.Instance().sendQuestChat(party, "party.setChat", " ", foundQuest.title);
                            }
                        }
                        PartyController.Instance().pingPartyUpdate(party);
                    }
                }
            }
            if (!(type.needsNpc && npc == null || type.hasPermission() && !CustomNpcsPermissions.hasPermission((EntityPlayer)player, type.permission))) {
                if (item == null && (type == EnumPacketServer.ScriptPlayerGet || type == EnumPacketServer.ScriptPlayerSave || type == EnumPacketServer.ScriptGlobalNPCGet || type == EnumPacketServer.ScriptGlobalNPCSave || type == EnumPacketServer.ScriptForgeGet || type == EnumPacketServer.ScriptForgeSave)) {
                    this.warn((EntityPlayer)player, "tried to use custom npcs without a tool in hand, probably a hacker");
                } else if (item != null) {
                    if (item.func_77973_b() == CustomItems.wand) {
                        this.wandPackets(type, buffer, player, npc);
                    } else if (item.func_77973_b() == CustomItems.moving) {
                        this.movingPackets(type, buffer, player, npc);
                    } else if (item.func_77973_b() == CustomItems.mount) {
                        this.mountPackets(type, buffer, player);
                    } else if (item.func_77973_b() == CustomItems.cloner) {
                        this.clonePackets(type, buffer, player);
                    } else if (item.func_77973_b() == CustomItems.teleporter) {
                        this.featherPackets(type, buffer, player);
                    } else if (item.func_77973_b() == Item.func_150898_a((Block)CustomItems.waypoint) || item.func_77973_b() == Item.func_150898_a((Block)CustomItems.border) || item.func_77973_b() == Item.func_150898_a((Block)CustomItems.redstoneBlock)) {
                        this.blockPackets(type, buffer, player);
                    } else if (ConfigScript.canScript((EntityPlayer)player, CustomNpcsPermissions.SCRIPT)) {
                        if (type == EnumPacketServer.EventScriptDataGet || type == EnumPacketServer.EventScriptDataSave) {
                            this.npcEventScriptPackets(type, buffer, player, npc);
                        } else if (type == EnumPacketServer.ScriptPlayerGet || type == EnumPacketServer.ScriptPlayerSave) {
                            this.playerScriptPackets(type, buffer, player);
                        } else if (type == EnumPacketServer.ScriptGlobalNPCGet || type == EnumPacketServer.ScriptGlobalNPCSave) {
                            this.npcGlobalScriptPackets(type, buffer, player);
                        } else if (type == EnumPacketServer.ScriptForgeGet || type == EnumPacketServer.ScriptForgeSave) {
                            this.forgeScriptPackets(type, buffer, player);
                        } else if (type == EnumPacketServer.ScriptItemDataGet || type == EnumPacketServer.ScriptItemDataSave) {
                            this.itemScriptPackets(type, buffer, player);
                        } else if (type == EnumPacketServer.ScriptBlockDataGet || type == EnumPacketServer.ScriptBlockDataSave) {
                            this.blockScriptPackets(type, buffer, player);
                        } else if (type == EnumPacketServer.ScriptGlobalGuiDataGet || type == EnumPacketServer.ScriptGlobalGuiDataSave) {
                            this.getScriptsEnabled(type, buffer, player);
                        } else if (item.func_77973_b() == CustomItems.scripter) {
                            this.scriptPackets(type, buffer, player, npc);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LogWriter.error("Error with EnumPacketServer." + (Object)((Object)type), e);
        }
    }

    public static void sendPartyData(EntityPlayerMP player) {
        PlayerData playerData = PlayerDataController.Instance.getPlayerData((EntityPlayer)player);
        if (playerData.partyUUID != null) {
            Party party = PartyController.Instance().getParty(playerData.partyUUID);
            NBTTagCompound compound = party.writeToNBT();
            if (party.getQuest() != null) {
                Quest quest = (Quest)party.getQuest();
                compound.func_74778_a("QuestName", quest.getCategory().getName() + ":" + quest.getName());
                Vector<String> vector = quest.questInterface.getPartyQuestLogStatus(party);
                NBTTagList list = new NBTTagList();
                for (String s : vector) {
                    list.func_74742_a((NBTBase)new NBTTagString(s));
                }
                compound.func_74782_a("QuestProgress", (NBTBase)list);
                if (quest.completion == EnumQuestCompletion.Npc && quest.questInterface.isPartyCompleted(party)) {
                    compound.func_74778_a("QuestCompleteWith", quest.completerNpc);
                }
            }
            Server.sendData(player, EnumPacketClient.PARTY_DATA, compound);
        } else {
            PacketHandlerServer.sendInviteData(player);
        }
    }

    public static void sendInviteData(EntityPlayerMP player) {
        PlayerData playerData = PlayerDataController.Instance.getPlayerData((EntityPlayer)player);
        if (playerData.partyUUID == null) {
            NBTTagCompound compound = new NBTTagCompound();
            NBTTagList list = new NBTTagList();
            HashSet<UUID> partyInvites = playerData.getPartyInvites();
            for (UUID uuid : partyInvites) {
                Party party = PartyController.Instance().getParty(uuid);
                NBTTagCompound partyCompound = new NBTTagCompound();
                partyCompound.func_74778_a("PartyLeader", party.getPartyLeaderName());
                partyCompound.func_74778_a("PartyUUID", party.getPartyUUID().toString());
                list.func_74742_a((NBTBase)partyCompound);
            }
            compound.func_74782_a("PartyInvites", (NBTBase)list);
            Server.sendData(player, EnumPacketClient.PARTY_DATA, compound);
        }
    }

    private void isGuiOpenPacket(ByteBuf buffer, EntityPlayerMP player) throws IOException {
        NoppesUtilServer.isGUIOpen(buffer, (EntityPlayer)player);
    }

    private void getScriptsEnabled(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player) throws IOException {
        if (type == EnumPacketServer.ScriptGlobalGuiDataGet) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("ScriptsEnabled", ConfigScript.ScriptingEnabled);
            compound.func_74757_a("PlayerScriptsEnabled", ConfigScript.GlobalPlayerScripts);
            compound.func_74757_a("GlobalNPCScriptsEnabled", ConfigScript.GlobalNPCScripts);
            compound.func_74757_a("ForgeScriptsEnabled", ConfigScript.GlobalForgeScripts);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.ScriptGlobalGuiDataSave) {
            NBTTagCompound compound = Server.readNBT(buffer);
            ConfigScript.ScriptingEnabled = compound.func_74767_n("ScriptsEnabled");
            ConfigScript.GlobalPlayerScripts = compound.func_74767_n("PlayerScriptsEnabled");
            ConfigScript.GlobalNPCScripts = compound.func_74767_n("GlobalNPCScriptsEnabled");
            ConfigScript.GlobalForgeScripts = compound.func_74767_n("ForgeScriptsEnabled");
        }
    }

    private void scriptPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player, EntityNPCInterface npc) throws Exception {
        if (type == EnumPacketServer.ScriptDataSave) {
            npc.script.readFromNBT(Server.readNBT(buffer));
            npc.updateAI = true;
            npc.script.hasInited = false;
            if (ConfigDebug.PlayerLogging && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                LogWriter.script(String.format("[%s] (Player) %s SAVED NPC %s (%s, %s, %s) [%s]", "SCRIPTER", player.func_70005_c_(), npc.display.getName(), (int)npc.field_70165_t, (int)npc.field_70163_u, (int)npc.field_70161_v, npc.field_70170_p.func_72912_H().func_76065_j()));
            }
        } else if (type == EnumPacketServer.ScriptDataGet) {
            NBTTagCompound compound = npc.script.writeToNBT(new NBTTagCompound());
            compound.func_74782_a("Languages", (NBTBase)ScriptController.Instance.nbtLanguages());
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        }
    }

    public static void getScripts(IScriptHandler data, ByteBuf buffer, EntityPlayerMP player) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74757_a("ScriptEnabled", data.getEnabled());
        compound.func_74778_a("ScriptLanguage", data.getLanguage());
        compound.func_74782_a("Languages", (NBTBase)ScriptController.Instance.nbtLanguages());
        compound.func_74782_a("ScriptConsole", (NBTBase)NBTTags.NBTLongStringMap(data.getConsoleText()));
        Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        List<ScriptContainer> containers = data.getScripts();
        for (int i = 0; i < containers.size(); ++i) {
            ScriptContainer container = containers.get(i);
            NBTTagCompound tabCompound = new NBTTagCompound();
            tabCompound.func_74768_a("Tab", i);
            tabCompound.func_74782_a("Script", (NBTBase)container.writeToNBT(new NBTTagCompound()));
            tabCompound.func_74768_a("TotalScripts", containers.size());
            Server.sendData(player, EnumPacketClient.GUI_DATA, tabCompound);
        }
    }

    public static void saveScripts(IScriptHandler data, ByteBuf buffer, EntityPlayerMP player) throws IOException {
        int tab = buffer.readInt();
        int totalScripts = buffer.readInt();
        if (totalScripts == 0) {
            data.getScripts().clear();
        }
        if (tab >= 0) {
            if (data.getScripts().size() > totalScripts) {
                data.setScripts(data.getScripts().subList(0, totalScripts));
            } else {
                while (data.getScripts().size() < totalScripts) {
                    data.getScripts().add(new ScriptContainer(data));
                }
            }
            NBTTagCompound tabCompound = Server.readNBT(buffer);
            ScriptContainer script = new ScriptContainer(data);
            script.readFromNBT(tabCompound);
            data.getScripts().set(tab, script);
        } else {
            NBTTagCompound compound = Server.readNBT(buffer);
            data.setLanguage(compound.func_74779_i("ScriptLanguage"));
            if (!ScriptController.Instance.languages.containsKey(data.getLanguage())) {
                if (!ScriptController.Instance.languages.isEmpty()) {
                    data.setLanguage((String)ScriptController.Instance.languages.keySet().toArray()[0]);
                } else {
                    data.setLanguage("ECMAScript");
                }
            }
            data.setEnabled(compound.func_74767_n("ScriptEnabled"));
        }
    }

    private void npcEventScriptPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player, EntityNPCInterface npc) throws Exception {
        DataScript data = npc.script;
        if (type == EnumPacketServer.EventScriptDataGet) {
            PacketHandlerServer.getScripts(data, buffer, player);
        } else if (type == EnumPacketServer.EventScriptDataSave) {
            PacketHandlerServer.saveScripts(data, buffer, player);
            npc.updateAI = true;
            npc.script.hasInited = false;
            if (ConfigDebug.PlayerLogging && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                LogWriter.script(String.format("[%s] (Player) %s SAVED NPC %s (%s, %s, %s) [%s]", "SCRIPTER", player.func_70005_c_(), npc.display.getName(), (int)npc.field_70165_t, (int)npc.field_70163_u, (int)npc.field_70161_v, npc.field_70170_p.func_72912_H().func_76065_j()));
            }
        }
    }

    private void playerScriptPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player) throws Exception {
        PlayerDataScript data = ScriptController.Instance.playerScripts;
        if (type == EnumPacketServer.ScriptPlayerGet) {
            PacketHandlerServer.getScripts(data, buffer, player);
        } else if (type == EnumPacketServer.ScriptPlayerSave) {
            PacketHandlerServer.saveScripts(data, buffer, player);
            ScriptController.Instance.lastPlayerUpdate = System.currentTimeMillis();
        }
    }

    private void forgeScriptPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player) throws Exception {
        ForgeDataScript data = ScriptController.Instance.forgeScripts;
        if (type == EnumPacketServer.ScriptForgeGet) {
            PacketHandlerServer.getScripts(data, buffer, player);
        } else if (type == EnumPacketServer.ScriptForgeSave) {
            PacketHandlerServer.saveScripts(data, buffer, player);
            ScriptController.Instance.lastForgeUpdate = System.currentTimeMillis();
        }
    }

    private void npcGlobalScriptPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player) throws Exception {
        GlobalNPCDataScript data = ScriptController.Instance.globalNpcScripts;
        if (type == EnumPacketServer.ScriptGlobalNPCGet) {
            PacketHandlerServer.getScripts(data, buffer, player);
        } else if (type == EnumPacketServer.ScriptGlobalNPCSave) {
            PacketHandlerServer.saveScripts(data, buffer, player);
            ScriptController.Instance.lastGlobalNpcUpdate = System.currentTimeMillis();
        }
    }

    private void itemScriptPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player) throws Exception {
        if (type == EnumPacketServer.ScriptItemDataGet) {
            ScriptCustomItem iw = (ScriptCustomItem)NpcAPI.Instance().getIItemStack(player.func_70694_bm());
            iw.loadScriptData();
            NBTTagCompound compound = iw.getMCNbt();
            compound.func_74782_a("Languages", (NBTBase)ScriptController.Instance.nbtLanguages());
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.ScriptItemDataSave) {
            if (!player.field_71075_bZ.field_75098_d) {
                return;
            }
            NBTTagCompound compound = Server.readNBT(buffer);
            ScriptCustomItem wrapper = (ScriptCustomItem)NpcAPI.Instance().getIItemStack(player.func_70694_bm());
            wrapper.setMCNbt(compound);
            wrapper.saveScriptData();
            wrapper.loaded = false;
            player.func_71120_a(player.field_71069_bz);
        }
    }

    private void blockScriptPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player) throws Exception {
        if (type == EnumPacketServer.ScriptBlockDataGet) {
            TileEntity tile = player.field_70170_p.func_147438_o(buffer.readInt(), buffer.readInt(), buffer.readInt());
            if (!(tile instanceof TileScripted)) {
                return;
            }
            NBTTagCompound compound = ((TileScripted)tile).getNBT(new NBTTagCompound());
            compound.func_74782_a("Languages", (NBTBase)ScriptController.Instance.nbtLanguages());
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.ScriptBlockDataSave) {
            if (!player.field_71075_bZ.field_75098_d) {
                return;
            }
            TileEntity tile = player.field_70170_p.func_147438_o(buffer.readInt(), buffer.readInt(), buffer.readInt());
            if (!(tile instanceof TileScripted)) {
                return;
            }
            TileScripted script = (TileScripted)tile;
            script.setNBT(Server.readNBT(buffer));
            script.lastInited = -1L;
        }
    }

    private void featherPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player) throws IOException {
        if (type == EnumPacketServer.DimensionTeleport) {
            int dimension = buffer.readInt();
            WorldServer world = MinecraftServer.func_71276_C().func_71218_a(dimension);
            ChunkCoordinates coords = world.func_73054_j();
            if (coords == null) {
                coords = world.func_72861_E();
                if (!world.func_147437_c(coords.field_71574_a, coords.field_71572_b, coords.field_71573_c)) {
                    coords.field_71572_b = world.func_72825_h(coords.field_71574_a, coords.field_71573_c);
                } else {
                    while (world.func_147437_c(coords.field_71574_a, coords.field_71572_b - 1, coords.field_71573_c) && coords.field_71572_b > 0) {
                        --coords.field_71572_b;
                    }
                    if (coords.field_71572_b == 0) {
                        coords.field_71572_b = world.func_72825_h(coords.field_71574_a, coords.field_71573_c);
                    }
                }
            }
            NoppesUtilPlayer.teleportPlayer(player, coords.field_71574_a, coords.field_71572_b, coords.field_71573_c, dimension);
        }
    }

    private void movingPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player, EntityNPCInterface npc) throws IOException {
        if (type == EnumPacketServer.MovingPathGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.ai.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MovingPathSave) {
            npc.ai.setMovingPath(NBTTags.getIntegerArraySet(Server.readNBT(buffer).func_150295_c("MovingPathNew", 10)));
        }
    }

    private void blockPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player) throws IOException {
        if (type == EnumPacketServer.SaveTileEntity) {
            NoppesUtilServer.saveTileEntity(player, Server.readNBT(buffer));
        } else if (type == EnumPacketServer.GetTileEntity) {
            TileEntity tile = player.field_70170_p.func_147438_o(buffer.readInt(), buffer.readInt(), buffer.readInt());
            NBTTagCompound compound = new NBTTagCompound();
            tile.func_145841_b(compound);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.DialogCategoriesGet) {
            NoppesUtilServer.sendScrollData(player, DialogController.Instance.getScroll());
        } else if (type == EnumPacketServer.DialogsGetFromDialog) {
            Dialog dialog = DialogController.Instance.dialogs.get(buffer.readInt());
            if (dialog == null) {
                return;
            }
            NoppesUtilServer.sendDialogData(player, dialog.category);
        } else if (type == EnumPacketServer.DialogsGet) {
            int catID = buffer.readInt();
            boolean sendGroup = buffer.readBoolean();
            if (sendGroup) {
                NoppesUtilServer.sendDialogGroup(player, DialogController.Instance.categories.get(catID));
            } else {
                NoppesUtilServer.sendDialogData(player, DialogController.Instance.categories.get(catID));
            }
        } else if (type == EnumPacketServer.QuestsGetFromQuest) {
            Quest quest = QuestController.Instance.quests.get(buffer.readInt());
            if (quest == null) {
                return;
            }
            NoppesUtilServer.sendQuestData(player, quest.category);
        } else if (type == EnumPacketServer.QuestCategoriesGet) {
            NoppesUtilServer.sendQuestCategoryData(player);
        } else if (type == EnumPacketServer.QuestsGet) {
            QuestCategory category = QuestController.Instance.categories.get(buffer.readInt());
            boolean sendGroup = buffer.readBoolean();
            if (sendGroup) {
                NoppesUtilServer.sendQuestGroup(player, category);
            } else {
                NoppesUtilServer.sendQuestData(player, category);
            }
        } else if (type == EnumPacketServer.FactionsGet) {
            NoppesUtilServer.sendFactionDataAll(player);
        } else if (type == EnumPacketServer.DialogGet) {
            Dialog dialog = DialogController.Instance.dialogs.get(buffer.readInt());
            if (dialog != null) {
                NBTTagCompound compound = dialog.writeToNBT(new NBTTagCompound());
                Quest quest = QuestController.Instance.quests.get(dialog.quest);
                if (quest != null) {
                    compound.func_74778_a("DialogQuestName", quest.title);
                }
                Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
            }
        } else if (type == EnumPacketServer.QuestGet) {
            Quest quest = QuestController.Instance.quests.get(buffer.readInt());
            if (quest != null) {
                NBTTagCompound compound = new NBTTagCompound();
                if (quest.hasNewQuest()) {
                    compound.func_74778_a("NextQuestTitle", quest.getNextQuest().title);
                }
                Server.sendData(player, EnumPacketClient.GUI_DATA, quest.writeToNBT(compound));
            }
        } else if (type == EnumPacketServer.FactionGet) {
            NBTTagCompound compound = new NBTTagCompound();
            Faction faction = FactionController.getInstance().get(buffer.readInt());
            faction.writeNBT(compound);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.TagGet) {
            NBTTagCompound compound = new NBTTagCompound();
            Tag tag = TagController.getInstance().get(buffer.readInt());
            tag.writeNBT(compound);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        }
    }

    private void wandPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player, EntityNPCInterface npc) throws IOException {
        if (type == EnumPacketServer.Delete) {
            if (ConfigDebug.PlayerLogging && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                LogWriter.script(String.format("[%s] (Player) %s DELETE NPC %s (%s, %s, %s) [%s]", "WAND", player.func_70005_c_(), npc.display.getName(), (int)npc.field_70165_t, (int)npc.field_70163_u, (int)npc.field_70161_v, npc.field_70170_p.func_72912_H().func_76065_j()));
            }
            npc.delete();
            NoppesUtilServer.deleteNpc(npc, (EntityPlayer)player);
        } else if (type == EnumPacketServer.LinkedAdd) {
            LinkedNpcController.Instance.addData(Server.readString(buffer));
            ArrayList<String> list = new ArrayList<String>();
            for (LinkedNpcController.LinkedData data : LinkedNpcController.Instance.list) {
                list.add(data.name);
            }
            Server.sendData(player, EnumPacketClient.SCROLL_LIST, list);
        } else if (type == EnumPacketServer.LinkedRemove) {
            LinkedNpcController.Instance.removeData(Server.readString(buffer));
            ArrayList<String> list = new ArrayList<String>();
            for (LinkedNpcController.LinkedData data : LinkedNpcController.Instance.list) {
                list.add(data.name);
            }
            Server.sendData(player, EnumPacketClient.SCROLL_LIST, list);
        } else if (type == EnumPacketServer.LinkedGetAll) {
            ArrayList<String> list = new ArrayList<String>();
            for (LinkedNpcController.LinkedData data : LinkedNpcController.Instance.list) {
                list.add(data.name);
            }
            Server.sendData(player, EnumPacketClient.SCROLL_LIST, list);
            if (npc != null) {
                Server.sendData(player, EnumPacketClient.SCROLL_SELECTED, npc.linkedName);
            }
        } else if (type == EnumPacketServer.LinkedSet) {
            npc.linkedName = Server.readString(buffer);
            LinkedNpcController.Instance.loadNpcData(npc);
        } else if (type == EnumPacketServer.NpcMenuClose) {
            npc.reset();
            if (npc.linkedData != null) {
                LinkedNpcController.Instance.saveNpcData(npc);
            }
            if (ConfigDebug.PlayerLogging && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                LogWriter.script(String.format("[%s] (Player) %s CLOSE NPC %s (%s, %s, %s) [%s]", "WAND", player.func_70005_c_(), npc.display.getName(), (int)npc.field_70165_t, (int)npc.field_70163_u, (int)npc.field_70161_v, npc.field_70170_p.func_72912_H().func_76065_j()));
            }
            NoppesUtilServer.setEditingNpc((EntityPlayer)player, null);
        } else if (type == EnumPacketServer.BanksGet) {
            NoppesUtilServer.sendBankDataAll(player);
        } else if (type == EnumPacketServer.BankGet) {
            Bank bank = BankController.getInstance().getBank(buffer.readInt());
            NoppesUtilServer.sendBank(player, bank);
        } else if (type == EnumPacketServer.BankSave) {
            Bank bank = new Bank();
            bank.readEntityFromNBT(Server.readNBT(buffer));
            BankController.getInstance().saveBank(bank);
            NoppesUtilServer.sendBankDataAll(player);
            NoppesUtilServer.sendBank(player, bank);
        } else if (type == EnumPacketServer.BankRemove) {
            BankController.getInstance().removeBank(buffer.readInt());
            NoppesUtilServer.sendBankDataAll(player);
            NoppesUtilServer.sendBank(player, new Bank());
        } else if (type == EnumPacketServer.RemoteMainMenu) {
            Entity entity = player.field_70170_p.func_73045_a(buffer.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            NoppesUtilServer.sendOpenGui((EntityPlayer)player, EnumGuiType.MainMenuDisplay, (EntityNPCInterface)entity);
            if (ConfigDebug.PlayerLogging && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                LogWriter.script(String.format("[%s] (Player) %s OPEN NPC %s (%s, %s, %s) [%s]", "WAND", player.func_70005_c_(), ((EntityNPCInterface)entity).display.getName(), entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70170_p.func_72912_H().func_76065_j()));
            }
        } else if (type == EnumPacketServer.RemoteGlobalMenu) {
            NoppesUtilServer.sendOpenGui((EntityPlayer)player, EnumGuiType.GlobalRemote, null);
            if (ConfigDebug.PlayerLogging && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                LogWriter.script(String.format("[%s] (Player) %s OPEN GLOBAL MENU", "WAND", player.func_70005_c_()));
            }
        } else if (type == EnumPacketServer.RemoteDelete) {
            Entity entity = player.field_70170_p.func_73045_a(buffer.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            npc = (EntityNPCInterface)entity;
            if (ConfigDebug.PlayerLogging && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                LogWriter.script(String.format("[%s] (Player) %s DELETE NPC %s (%s, %s, %s) [%s]", "WAND", player.func_70005_c_(), npc.display.getName(), (int)npc.field_70165_t, (int)npc.field_70163_u, (int)npc.field_70161_v, npc.field_70170_p.func_72912_H().func_76065_j()));
            }
            npc.delete();
            NoppesUtilServer.deleteNpc(npc, (EntityPlayer)player);
            NoppesUtilServer.sendNearbyNpcs(player);
        } else if (type == EnumPacketServer.RemoteNpcsGet) {
            NoppesUtilServer.sendNearbyNpcs(player);
        } else if (type == EnumPacketServer.RemoteFreeze) {
            CustomNpcs.FreezeNPCs = !CustomNpcs.FreezeNPCs;
            Server.sendData(player, EnumPacketClient.SCROLL_SELECTED, CustomNpcs.FreezeNPCs ? "Unfreeze NPCs" : "Freeze NPCs");
        } else if (type == EnumPacketServer.RemoteFreezeGet) {
            Server.sendData(player, EnumPacketClient.SCROLL_SELECTED, CustomNpcs.FreezeNPCs ? "Unfreeze NPCs" : "Freeze NPCs");
        } else if (type == EnumPacketServer.RemoteReset) {
            Entity entity = player.field_70170_p.func_73045_a(buffer.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            npc = (EntityNPCInterface)entity;
            npc.reset();
        } else if (type == EnumPacketServer.RemoteTpToNpc) {
            Entity entity = player.field_70170_p.func_73045_a(buffer.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            npc = (EntityNPCInterface)entity;
            player.field_71135_a.func_147364_a(npc.field_70165_t, npc.field_70163_u, npc.field_70161_v, 0.0f, 0.0f);
        } else if (type == EnumPacketServer.Gui) {
            EnumGuiType gui = EnumGuiType.values()[buffer.readInt()];
            int i = buffer.readInt();
            int j = buffer.readInt();
            int k = buffer.readInt();
            NoppesUtilServer.sendOpenGui((EntityPlayer)player, gui, npc, i, j, k);
        } else if (type == EnumPacketServer.RecipesGet) {
            NoppesUtilServer.sendRecipeData(player, buffer.readInt());
        } else if (type == EnumPacketServer.RecipeGet) {
            RecipeCarpentry recipe = RecipeController.Instance.getRecipe(buffer.readInt());
            NoppesUtilServer.setRecipeGui(player, recipe);
        } else if (type == EnumPacketServer.RecipeRemove) {
            RecipeCarpentry recipe = RecipeController.Instance.delete(buffer.readInt());
            NoppesUtilServer.sendRecipeData(player, recipe.isGlobal ? 3 : 4);
            NoppesUtilServer.setRecipeGui(player, new RecipeCarpentry(""));
        } else if (type == EnumPacketServer.RecipeSave) {
            RecipeCarpentry recipe = RecipeController.Instance.saveRecipe(Server.readNBT(buffer));
            NoppesUtilServer.sendRecipeData(player, recipe.isGlobal ? 3 : 4);
            NoppesUtilServer.setRecipeGui(player, recipe);
        } else if (type == EnumPacketServer.NaturalSpawnGetAll) {
            NoppesUtilServer.sendScrollData(player, SpawnController.Instance.getScroll());
        } else if (type == EnumPacketServer.NaturalSpawnGet) {
            SpawnData spawn = SpawnController.Instance.getSpawnData(buffer.readInt());
            if (spawn != null) {
                Server.sendData(player, EnumPacketClient.GUI_DATA, spawn.writeNBT(new NBTTagCompound()));
            }
        } else if (type == EnumPacketServer.NaturalSpawnSave) {
            SpawnData data = new SpawnData();
            data.readNBT(Server.readNBT(buffer));
            SpawnController.Instance.saveSpawnData(data);
            NoppesUtilServer.sendScrollData(player, SpawnController.Instance.getScroll());
        } else if (type == EnumPacketServer.NaturalSpawnRemove) {
            SpawnController.Instance.removeSpawnData(buffer.readInt());
            NoppesUtilServer.sendScrollData(player, SpawnController.Instance.getScroll());
        } else if (type == EnumPacketServer.DialogCategorySave) {
            DialogCategory category = new DialogCategory();
            category.readNBT(Server.readNBT(buffer));
            DialogController.Instance.saveCategory(category);
            NoppesUtilServer.sendScrollData(player, DialogController.Instance.getScroll());
        } else if (type == EnumPacketServer.DialogCategoryRemove) {
            DialogController.Instance.removeCategory(buffer.readInt());
            NoppesUtilServer.sendScrollData(player, DialogController.Instance.getScroll());
        } else if (type == EnumPacketServer.DialogCategoryGet) {
            DialogCategory category = DialogController.Instance.categories.get(buffer.readInt());
            if (category != null) {
                NBTTagCompound comp = category.writeNBT(new NBTTagCompound());
                comp.func_82580_o("Dialogs");
                Server.sendData(player, EnumPacketClient.GUI_DATA, comp);
            }
        } else if (type == EnumPacketServer.DialogSave) {
            int category = buffer.readInt();
            Dialog dialog = new Dialog();
            dialog.readNBT(Server.readNBT(buffer));
            boolean sendGroup = buffer.readBoolean();
            DialogController.Instance.saveDialog(category, dialog);
            if (dialog.category != null) {
                if (sendGroup) {
                    NoppesUtilServer.sendDialogGroup(player, dialog.category);
                } else {
                    NoppesUtilServer.sendDialogData(player, dialog.category);
                }
            }
        } else if (type == EnumPacketServer.QuestOpenGui) {
            Quest quest = new Quest();
            int gui = buffer.readInt();
            quest.readNBT(Server.readNBT(buffer));
            NoppesUtilServer.setEditingQuest((EntityPlayer)player, quest);
            player.openGui((Object)CustomNpcs.instance, gui, player.field_70170_p, 0, 0, 0);
        } else if (type == EnumPacketServer.DialogRemove) {
            int diagId = buffer.readInt();
            boolean sendGroup = buffer.readBoolean();
            Dialog dialog = DialogController.Instance.dialogs.get(diagId);
            if (dialog != null && dialog.category != null) {
                DialogController.Instance.removeDialog(dialog);
                if (sendGroup) {
                    NoppesUtilServer.sendDialogGroup(player, dialog.category);
                } else {
                    NoppesUtilServer.sendDialogData(player, dialog.category);
                }
            }
        } else if (type == EnumPacketServer.DialogNpcGet) {
            NoppesUtilServer.sendNpcDialogs((EntityPlayer)player);
        } else if (type == EnumPacketServer.DialogNpcSet) {
            int dialog;
            int slot = buffer.readInt();
            DialogOption option = NoppesUtilServer.setNpcDialog(slot, dialog = buffer.readInt(), (EntityPlayer)player);
            if (option != null && option.hasDialog()) {
                NBTTagCompound compound = option.writeNBT();
                compound.func_74768_a("Position", slot);
                Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
            }
        } else if (type == EnumPacketServer.DialogNpcRemove) {
            npc.dialogs.remove(buffer.readInt());
        } else if (type == EnumPacketServer.QuestCategoryGet) {
            QuestCategory category = QuestController.Instance.categories.get(buffer.readInt());
            if (category != null) {
                NBTTagCompound comp = category.writeNBT(new NBTTagCompound());
                comp.func_82580_o("Dialogs");
                Server.sendData(player, EnumPacketClient.GUI_DATA, comp);
            }
        } else if (type == EnumPacketServer.QuestCategorySave) {
            QuestCategory category = new QuestCategory();
            category.readNBT(Server.readNBT(buffer));
            QuestController.Instance.saveCategory(category);
            NoppesUtilServer.sendQuestCategoryData(player);
        } else if (type == EnumPacketServer.QuestCategoryRemove) {
            QuestController.Instance.removeCategory(buffer.readInt());
            NoppesUtilServer.sendQuestCategoryData(player);
        } else if (type == EnumPacketServer.QuestSave) {
            int category = buffer.readInt();
            Quest quest = new Quest();
            quest.readNBT(Server.readNBT(buffer));
            boolean sendGroup = buffer.readBoolean();
            QuestController.Instance.saveQuest(category, quest);
            if (quest.category != null) {
                if (sendGroup) {
                    NoppesUtilServer.sendQuestGroup(player, quest.category);
                } else {
                    NoppesUtilServer.sendQuestData(player, quest.category);
                }
            }
        } else if (type == EnumPacketServer.QuestDialogGetTitle) {
            Dialog quest = DialogController.Instance.dialogs.get(buffer.readInt());
            Dialog quest2 = DialogController.Instance.dialogs.get(buffer.readInt());
            Dialog quest3 = DialogController.Instance.dialogs.get(buffer.readInt());
            NBTTagCompound compound = new NBTTagCompound();
            if (quest != null) {
                compound.func_74778_a("1", quest.title);
            }
            if (quest2 != null) {
                compound.func_74778_a("2", quest2.title);
            }
            if (quest3 != null) {
                compound.func_74778_a("3", quest3.title);
            }
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.QuestRemove) {
            Quest quest = QuestController.Instance.quests.get(buffer.readInt());
            boolean sendGroup = buffer.readBoolean();
            if (quest != null) {
                QuestController.Instance.removeQuest(quest);
                if (sendGroup) {
                    NoppesUtilServer.sendQuestGroup(player, quest.category);
                } else {
                    NoppesUtilServer.sendQuestData(player, quest.category);
                }
            }
        } else if (type == EnumPacketServer.TransportCategoriesGet) {
            NoppesUtilServer.sendTransportCategoryData(player);
        } else if (type == EnumPacketServer.TransportCategorySave) {
            TransportController.getInstance().saveCategory(Server.readString(buffer), buffer.readInt());
        } else if (type == EnumPacketServer.TransportCategoryRemove) {
            TransportController.getInstance().removeCategory(buffer.readInt());
            NoppesUtilServer.sendTransportCategoryData(player);
        } else if (type == EnumPacketServer.TransportRemove) {
            int id = buffer.readInt();
            TransportLocation loc = TransportController.getInstance().removeLocation(id);
            if (loc != null) {
                NoppesUtilServer.sendTransportData(player, loc.category.id);
            }
        } else if (type == EnumPacketServer.TransportsGet) {
            NoppesUtilServer.sendTransportData(player, buffer.readInt());
        } else if (type == EnumPacketServer.TransportSave) {
            int cat = buffer.readInt();
            TransportLocation location = TransportController.getInstance().saveLocation(cat, Server.readNBT(buffer), npc);
            if (location != null) {
                if (npc.advanced.role != EnumRoleType.Transporter) {
                    return;
                }
                RoleTransporter role = (RoleTransporter)npc.roleInterface;
                role.setTransport(location);
            }
        } else if (type == EnumPacketServer.TransportGetLocation) {
            if (npc.advanced.role != EnumRoleType.Transporter) {
                return;
            }
            RoleTransporter role = (RoleTransporter)npc.roleInterface;
            if (role.hasTransport()) {
                Server.sendData(player, EnumPacketClient.GUI_DATA, role.getLocation().writeNBT());
                Server.sendData(player, EnumPacketClient.SCROLL_SELECTED, role.getLocation().category.title);
            }
        } else if (type == EnumPacketServer.FactionSet) {
            npc.setFaction(buffer.readInt());
        } else if (type == EnumPacketServer.FactionSave) {
            Faction faction = new Faction();
            faction.readNBT(Server.readNBT(buffer));
            FactionController.getInstance().saveFaction(faction);
            NoppesUtilServer.sendFactionDataAll(player);
            NBTTagCompound compound = new NBTTagCompound();
            faction.writeNBT(compound);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.FactionRemove) {
            FactionController.getInstance().delete(buffer.readInt());
            NoppesUtilServer.sendFactionDataAll(player);
            NBTTagCompound compound = new NBTTagCompound();
            new Faction().writeNBT(compound);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.TagSet) {
            this.setTags(npc, buffer);
        } else if (type == EnumPacketServer.TagSave) {
            Tag tag = new Tag();
            tag.readNBT(Server.readNBT(buffer));
            TagController.getInstance().saveTag(tag);
            NoppesUtilServer.sendTagDataAll(player);
            NBTTagCompound compound = new NBTTagCompound();
            tag.writeNBT(compound);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.TagRemove) {
            TagController.getInstance().delete(buffer.readInt());
            NoppesUtilServer.sendTagDataAll(player);
            NBTTagCompound compound = new NBTTagCompound();
            new Tag().writeNBT(compound);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.PlayerDataGet) {
            int id = buffer.readInt();
            if (EnumPlayerData.values().length <= id) {
                return;
            }
            String name = null;
            EnumPlayerData datatype = EnumPlayerData.values()[id];
            if (datatype != EnumPlayerData.Players) {
                name = Server.readString(buffer);
            }
            NoppesUtilServer.sendPlayerData(datatype, player, name);
        } else if (type == EnumPacketServer.PlayerDataRemove) {
            NoppesUtilServer.removePlayerData(buffer, player);
        } else if (type == EnumPacketServer.PlayerDataMapRegen) {
            NoppesUtilServer.regenPlayerData(player);
        } else if (type == EnumPacketServer.MainmenuDisplayGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.display.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuDisplaySave) {
            npc.display.readToNBT(Server.readNBT(buffer));
            npc.updateClient = true;
        } else if (type == EnumPacketServer.MainmenuStatsGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.stats.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuStatsSave) {
            npc.stats.readToNBT(Server.readNBT(buffer));
            npc.updateClient = true;
        } else if (type == EnumPacketServer.MainmenuInvGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.inventory.writeEntityToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuInvSave) {
            npc.inventory.readEntityFromNBT(Server.readNBT(buffer));
            npc.updateAI = true;
            npc.updateClient = true;
        } else if (type == EnumPacketServer.MainmenuAIGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.ai.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuAISave) {
            npc.ai.readToNBT(Server.readNBT(buffer));
            npc.func_70606_j(npc.func_110138_aP());
            npc.updateAI = true;
            npc.updateClient = true;
        } else if (type == EnumPacketServer.MainmenuAdvancedGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.advanced.writeToNBT(new NBTTagCompound()));
        } else if (type == EnumPacketServer.MainmenuAdvancedSave) {
            npc.advanced.readToNBT(Server.readNBT(buffer));
            npc.updateAI = true;
            npc.updateClient = true;
        } else if (type == EnumPacketServer.MainmenuAdvancedMarkData) {
            MarkData data = MarkData.get(npc);
            data.setNBT(Server.readNBT(buffer));
            data.syncClients();
        } else if (type == EnumPacketServer.JobSave) {
            NBTTagCompound original = npc.jobInterface.writeToNBT(new NBTTagCompound());
            NBTTagCompound compound = Server.readNBT(buffer);
            Set names = compound.func_150296_c();
            for (String name : names) {
                original.func_74782_a(name, compound.func_74781_a(name));
            }
            npc.jobInterface.readFromNBT(original);
            npc.updateClient = true;
        } else if (type == EnumPacketServer.JobGet) {
            if (npc.jobInterface == null) {
                return;
            }
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("JobData", true);
            npc.jobInterface.writeToNBT(compound);
            if (npc.advanced.job == EnumJobType.Spawner) {
                ((JobSpawner)npc.jobInterface).cleanCompound(compound);
            }
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
            if (npc.advanced.job == EnumJobType.Spawner) {
                Server.sendData(player, EnumPacketClient.GUI_DATA, ((JobSpawner)npc.jobInterface).getTitles());
            }
        } else if (type == EnumPacketServer.JobSpawnerAdd) {
            if (npc.advanced.job != EnumJobType.Spawner) {
                return;
            }
            JobSpawner job = (JobSpawner)npc.jobInterface;
            if (buffer.readBoolean()) {
                NBTTagCompound compound = ServerCloneController.Instance.getCloneData(null, Server.readString(buffer), buffer.readInt());
                job.setJobCompound(buffer.readInt(), compound);
            } else {
                job.setJobCompound(buffer.readInt(), Server.readNBT(buffer));
            }
            Server.sendData(player, EnumPacketClient.GUI_DATA, job.getTitles());
        } else if (type == EnumPacketServer.RoleCompanionUpdate) {
            if (npc.advanced.role != EnumRoleType.Companion) {
                return;
            }
            ((RoleCompanion)npc.roleInterface).matureTo(EnumCompanionStage.values()[buffer.readInt()]);
            npc.updateClient = true;
        } else if (type == EnumPacketServer.JobSpawnerRemove) {
            if (npc.advanced.job != EnumJobType.Spawner) {
                return;
            }
            JobSpawner job = (JobSpawner)npc.jobInterface;
            job.setJobCompound(buffer.readInt(), null);
            Server.sendData(player, EnumPacketClient.GUI_DATA, job.getTitles());
        } else if (type == EnumPacketServer.RoleSave) {
            npc.roleInterface.readFromNBT(Server.readNBT(buffer));
            npc.updateClient = true;
        } else if (type == EnumPacketServer.RoleGet) {
            if (npc.roleInterface == null) {
                return;
            }
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("RoleData", true);
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.roleInterface.writeToNBT(compound));
        } else if (type == EnumPacketServer.MerchantUpdate) {
            Entity entity = player.field_70170_p.func_73045_a(buffer.readInt());
            if (entity == null || !(entity instanceof EntityVillager)) {
                return;
            }
            MerchantRecipeList list = MerchantRecipeList.func_151390_b((PacketBuffer)new PacketBuffer(buffer));
            ((EntityVillager)entity).func_70930_a(list);
        } else if (type == EnumPacketServer.ModelDataSave) {
            if (npc instanceof EntityCustomNpc) {
                ((EntityCustomNpc)npc).modelData.readFromNBT(Server.readNBT(buffer));
            }
        } else if (type == EnumPacketServer.MailOpenSetup) {
            PlayerMail mail = new PlayerMail();
            mail.readNBT(Server.readNBT(buffer));
            ContainerMail.staticmail = mail;
            player.openGui((Object)CustomNpcs.instance, EnumGuiType.PlayerMailman.ordinal(), player.field_70170_p, 1, 0, 0);
        } else if (type == EnumPacketServer.TransformSave) {
            boolean isValid = npc.transform.isValid();
            npc.transform.readOptions(Server.readNBT(buffer));
            if (isValid != npc.transform.isValid()) {
                npc.updateAI = true;
            }
        } else if (type == EnumPacketServer.TransformGet) {
            Server.sendData(player, EnumPacketClient.GUI_DATA, npc.transform.writeOptions(new NBTTagCompound()));
        } else if (type == EnumPacketServer.TransformLoad) {
            if (npc.transform.isValid()) {
                npc.transform.transform(buffer.readBoolean());
            }
        } else if (type == EnumPacketServer.TraderMarketSave) {
            String market = Server.readString(buffer);
            if (market == null) {
                return;
            }
            boolean bo = buffer.readBoolean();
            if (npc.roleInterface instanceof RoleTrader) {
                if (bo) {
                    Market.setMarket(npc, market);
                } else {
                    Market.save((RoleTrader)npc.roleInterface, market);
                }
            }
        } else if (type == EnumPacketServer.AnimationsGet) {
            NoppesUtilServer.sendAnimationDataAll(player);
        } else if (type == EnumPacketServer.AnimationGet) {
            Animation animation = (Animation)AnimationController.getInstance().get(buffer.readInt());
            NBTTagCompound compound = animation.writeToNBT();
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.AnimationRemove) {
            AnimationController.getInstance().delete(buffer.readInt());
            NoppesUtilServer.sendAnimationDataAll(player);
            NBTTagCompound compound = new Animation().writeToNBT();
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.AnimationSave) {
            Animation animation = new Animation();
            animation.readFromNBT(Server.readNBT(buffer));
            AnimationController.getInstance().saveAnimation(animation);
            NoppesUtilServer.sendAnimationDataAll(player);
            Server.sendData(player, EnumPacketClient.GUI_DATA, animation.writeToNBT());
        } else {
            this.blockPackets(type, buffer, player);
        }
    }

    private void mountPackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player) throws IOException {
        if (type == EnumPacketServer.SpawnRider) {
            Entity entity = EntityList.func_75615_a((NBTTagCompound)Server.readNBT(buffer), (World)player.field_70170_p);
            player.field_70170_p.func_72838_d(entity);
            entity.func_70078_a(ServerEventsHandler.mounted);
        } else if (type == EnumPacketServer.PlayerRider) {
            player.func_70078_a(ServerEventsHandler.mounted);
        } else if (type == EnumPacketServer.CloneList) {
            NBTTagList list = new NBTTagList();
            int tab = buffer.readInt();
            for (String string : ServerCloneController.Instance.getClones(tab)) {
                list.func_74742_a((NBTBase)new NBTTagString(string));
            }
            NBTTagList listDate = new NBTTagList();
            for (String name : ServerCloneController.Instance.getClonesDate(tab)) {
                listDate.func_74742_a((NBTBase)new NBTTagString(name));
            }
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74782_a("List", (NBTBase)list);
            nBTTagCompound.func_74782_a("ListDate", (NBTBase)listDate);
            Server.sendData(player, EnumPacketClient.GUI_DATA, nBTTagCompound);
        } else {
            this.warn((EntityPlayer)player, "WE 1 tried todo something with the wrong tool, probably a hacker");
        }
    }

    private void clonePackets(EnumPacketServer type, ByteBuf buffer, EntityPlayerMP player) throws IOException {
        if (type == EnumPacketServer.SpawnMob) {
            boolean server = buffer.readBoolean();
            int x = buffer.readInt();
            int y = buffer.readInt();
            int n = buffer.readInt();
            NBTTagCompound compound = server ? ServerCloneController.Instance.getCloneData((ICommandSender)player, Server.readString(buffer), buffer.readInt()) : Server.readNBT(buffer);
            if (compound == null) {
                return;
            }
            Entity entity = NoppesUtilServer.spawnClone(compound, x, y, n, player.field_70170_p);
            if (entity == null) {
                player.func_145747_a((IChatComponent)new ChatComponentText("Failed to create an entity out of your clone"));
                return;
            }
            if (ConfigDebug.PlayerLogging && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                LogWriter.script(String.format("[%s] (Player) %s SPAWNED ENTITY %s", "CLONER", player.func_70005_c_(), entity));
            }
        } else if (type == EnumPacketServer.MobSpawner) {
            boolean server = buffer.readBoolean();
            int x = buffer.readInt();
            int y = buffer.readInt();
            int n = buffer.readInt();
            NBTTagCompound compound = server ? ServerCloneController.Instance.getCloneData((ICommandSender)player, Server.readString(buffer), buffer.readInt()) : Server.readNBT(buffer);
            if (compound != null) {
                NoppesUtilServer.createMobSpawner(x, y, n, compound, (EntityPlayer)player);
            }
        } else if (type == EnumPacketServer.ClonePreSave) {
            boolean bo = ServerCloneController.Instance.getCloneData(null, Server.readString(buffer), buffer.readInt()) != null;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74757_a("NameExists", bo);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.CloneSave) {
            PlayerData data = PlayerDataController.Instance.getPlayerData((EntityPlayer)player);
            if (data.cloned == null) {
                return;
            }
            String name = Server.readString(buffer);
            int tab = buffer.readInt();
            NBTTagCompound nBTTagCompound = Server.readNBT(buffer);
            ServerCloneController.Instance.addClone(data.cloned, name, tab, nBTTagCompound);
        } else if (type == EnumPacketServer.CloneRemove) {
            int tab = buffer.readInt();
            ServerCloneController.Instance.removeClone(Server.readString(buffer), tab);
            NBTTagList list = new NBTTagList();
            for (String string : ServerCloneController.Instance.getClones(tab)) {
                list.func_74742_a((NBTBase)new NBTTagString(string));
            }
            NBTTagList listDate = new NBTTagList();
            for (String name : ServerCloneController.Instance.getClonesDate(tab)) {
                listDate.func_74742_a((NBTBase)new NBTTagString(name));
            }
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74782_a("List", (NBTBase)list);
            nBTTagCompound.func_74782_a("ListDate", (NBTBase)listDate);
            Server.sendData(player, EnumPacketClient.GUI_DATA, nBTTagCompound);
        } else if (type == EnumPacketServer.CloneList) {
            NBTTagList list = new NBTTagList();
            int tab = buffer.readInt();
            for (String string : ServerCloneController.Instance.getClones(tab)) {
                list.func_74742_a((NBTBase)new NBTTagString(string));
            }
            NBTTagList listDate = new NBTTagList();
            for (String name : ServerCloneController.Instance.getClonesDate(tab)) {
                listDate.func_74742_a((NBTBase)new NBTTagString(name));
            }
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74782_a("List", (NBTBase)list);
            nBTTagCompound.func_74782_a("ListDate", (NBTBase)listDate);
            Server.sendData(player, EnumPacketClient.GUI_DATA, nBTTagCompound);
        } else if (type == EnumPacketServer.CloneTagList) {
            int tab = buffer.readInt();
            TagMap tagMap = ServerTagMapController.Instance.getTagMap(tab);
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("CloneTags", (NBTBase)tagMap.writeNBT());
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.CloneAllTags) {
            NBTTagCompound compound = new NBTTagCompound();
            HashSet<Tag> validTags = TagController.getInstance().getAllTags();
            NBTTagList validTagList = new NBTTagList();
            for (Tag tag : validTags) {
                NBTTagCompound tagCompound = new NBTTagCompound();
                tag.writeNBT(tagCompound);
                validTagList.func_74742_a((NBTBase)tagCompound);
            }
            compound.func_74782_a("AllTags", (NBTBase)validTagList);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.CloneAllTagsShort) {
            NBTTagCompound compound = new NBTTagCompound();
            HashSet<Tag> validTags = TagController.getInstance().getAllTags();
            NBTTagList validTagList = new NBTTagList();
            for (Tag tag : validTags) {
                NBTTagCompound tagCompound = new NBTTagCompound();
                tag.writeShortNBT(tagCompound);
                validTagList.func_74742_a((NBTBase)tagCompound);
            }
            compound.func_74782_a("ShortTags", (NBTBase)validTagList);
            Server.sendData(player, EnumPacketClient.GUI_DATA, compound);
        } else if (type == EnumPacketServer.TagSet) {
            EntityNPCInterface npc = NoppesUtilServer.getEditingNpc((EntityPlayer)player);
            this.setTags(npc, buffer);
        } else if (type != EnumPacketServer.NpcTagsGet && type != EnumPacketServer.TagsGet) {
            this.warn((EntityPlayer)player, "WE 2 tried todo something with the wrong tool, probably a hacker");
        }
    }

    private void setTags(EntityNPCInterface npc, ByteBuf buffer) throws IOException {
        npc.advanced.tagUUIDs.removeIf(uuid -> TagController.getInstance().getTagFromUUID((UUID)uuid) != null);
        NBTTagCompound compound = Server.readNBT(buffer);
        NBTTagList list = compound.func_150295_c("TagNames", 8);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            String tagName = list.func_150307_f(i);
            npc.advanced.tagUUIDs.add(TagController.getInstance().getTagFromName((String)tagName).uuid);
        }
    }

    private void warn(EntityPlayer player, String warning) {
        MinecraftServer.func_71276_C().func_71236_h(player.func_70005_c_() + ": " + warning);
    }
}

