/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomNpcsPermissions;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.NPCSpawning;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.blocks.tiles.TileBanner;
import noppes.npcs.config.ConfigDebug;
import noppes.npcs.config.ConfigMain;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPartyObjectives;
import noppes.npcs.constants.EnumQuestType;
import noppes.npcs.constants.EnumRoleType;
import noppes.npcs.controllers.PartyController;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.RecipeController;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.data.Line;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.controllers.data.Party;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.Quest;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.controllers.data.RecipeCarpentry;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.items.ItemExcalibur;
import noppes.npcs.items.ItemShield;
import noppes.npcs.items.ItemSoulstoneEmpty;
import noppes.npcs.quests.QuestItem;
import noppes.npcs.quests.QuestKill;
import noppes.npcs.roles.RoleFollower;

public class ServerEventsHandler {
    public static EntityVillager Merchant;
    public static Entity mounted;

    @SubscribeEvent
    public void invoke(EntityInteractEvent event) {
        ItemStack item = event.entityPlayer.func_71045_bC();
        if (item == null) {
            return;
        }
        boolean isRemote = event.entityPlayer.field_70170_p.field_72995_K;
        boolean npcInteracted = event.target instanceof EntityNPCInterface;
        if (!isRemote && ConfigMain.OpsOnly && !MinecraftServer.func_71276_C().func_71203_ab().func_152596_g(event.entityPlayer.func_146103_bH())) {
            return;
        }
        if (!isRemote && item.func_77973_b() == CustomItems.soulstoneEmpty && npcInteracted) {
            ((ItemSoulstoneEmpty)item.func_77973_b()).store((EntityLivingBase)event.target, item, event.entityPlayer);
            if (ConfigDebug.PlayerLogging && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                LogWriter.script(String.format("[%s] (Player) %s PICKED ENTITY %s", "SOULSTONE", event.entityPlayer.func_70005_c_(), event.target));
            }
        }
        if (item.func_77973_b() == CustomItems.wand && npcInteracted && !isRemote) {
            if (!CustomNpcsPermissions.hasPermission(event.entityPlayer, CustomNpcsPermissions.NPC_GUI)) {
                return;
            }
            event.setCanceled(true);
            NoppesUtilServer.sendOpenGui(event.entityPlayer, EnumGuiType.MainMenuDisplay, (EntityNPCInterface)event.target);
            if (ConfigDebug.PlayerLogging && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                LogWriter.script(String.format("[%s] (Player) %s OPEN NPC %s (%s, %s, %s) [%s]", "WAND", event.entityPlayer.func_70005_c_(), ((EntityNPCInterface)event.target).display.getName(), (int)event.target.field_70165_t, (int)event.target.field_70163_u, (int)event.target.field_70161_v, event.target.field_70170_p.func_72912_H().func_76065_j()));
            }
        } else if (item.func_77973_b() == CustomItems.cloner && !isRemote && !(event.target instanceof EntityPlayer)) {
            if (!CustomNpcsPermissions.hasPermission(event.entityPlayer, CustomNpcsPermissions.TOOL_CLONER)) {
                return;
            }
            NBTTagCompound compound = new NBTTagCompound();
            if (!event.target.func_70039_c(compound)) {
                return;
            }
            PlayerData data = PlayerDataController.Instance.getPlayerData(event.entityPlayer);
            ServerCloneController.Instance.cleanTags(compound);
            if (!Server.sendDataChecked((EntityPlayerMP)event.entityPlayer, EnumPacketClient.CLONE, compound)) {
                event.entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("Entity too big to clone"));
            }
            data.cloned = compound;
            if (event.target instanceof EntityNPCInterface) {
                NoppesUtilServer.setEditingNpc(event.entityPlayer, (EntityNPCInterface)event.target);
            }
            event.setCanceled(true);
        } else if (item.func_77973_b() == CustomItems.scripter && !isRemote && npcInteracted) {
            if (!CustomNpcsPermissions.hasPermission(event.entityPlayer, CustomNpcsPermissions.TOOL_SCRIPTER)) {
                return;
            }
            NoppesUtilServer.setEditingNpc(event.entityPlayer, (EntityNPCInterface)event.target);
            event.setCanceled(true);
            Server.sendData((EntityPlayerMP)event.entityPlayer, EnumPacketClient.GUI, EnumGuiType.Script.ordinal());
            if (ConfigDebug.PlayerLogging && FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
                LogWriter.script(String.format("[%s] (Player) %s OPEN NPC %s (%s, %s, %s) [%s]", "SCRIPTER", event.entityPlayer.func_70005_c_(), ((EntityNPCInterface)event.target).display.getName(), (int)event.target.field_70165_t, (int)event.target.field_70163_u, (int)event.target.field_70161_v, event.target.field_70170_p.func_72912_H().func_76065_j()));
            }
        } else if (item.func_77973_b() == CustomItems.mount) {
            if (!CustomNpcsPermissions.hasPermission(event.entityPlayer, CustomNpcsPermissions.TOOL_MOUNTER)) {
                return;
            }
            event.setCanceled(true);
            mounted = event.target;
            if (isRemote) {
                CustomNpcs.proxy.openGui(MathHelper.func_76128_c((double)ServerEventsHandler.mounted.field_70165_t), MathHelper.func_76128_c((double)ServerEventsHandler.mounted.field_70163_u), MathHelper.func_76128_c((double)ServerEventsHandler.mounted.field_70161_v), EnumGuiType.MobSpawnerMounter, event.entityPlayer);
            }
        } else if (item.func_77973_b() == CustomItems.wand && !isRemote && event.target instanceof EntityVillager) {
            if (!CustomNpcsPermissions.hasPermission(event.entityPlayer, CustomNpcsPermissions.EDIT_VILLAGER)) {
                return;
            }
            event.setCanceled(true);
            Merchant = (EntityVillager)event.target;
            if (!isRemote) {
                EntityPlayerMP player = (EntityPlayerMP)event.entityPlayer;
                player.openGui((Object)CustomNpcs.instance, EnumGuiType.MerchantAdd.ordinal(), player.field_70170_p, 0, 0, 0);
                MerchantRecipeList merchantrecipelist = Merchant.func_70934_b((EntityPlayer)player);
                if (merchantrecipelist != null) {
                    Server.sendData(player, EnumPacketClient.VILLAGER_LIST, merchantrecipelist);
                }
            }
        }
    }

    @SubscribeEvent
    public void invoke(LivingAttackEvent event) {
        if (event.source == null || !(event.source.func_76346_g() instanceof EntityPlayer) || !(event.entityLiving instanceof EntityPlayer) || FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        if (ConfigMain.PartyFriendlyFireEnabled) {
            Party party;
            EntityPlayer sourcePlayer = (EntityPlayer)event.source.func_76346_g();
            PlayerData playerData = PlayerDataController.Instance.getPlayerData(sourcePlayer);
            PlayerData targetData = PlayerDataController.Instance.getPlayerData((EntityPlayer)event.entityLiving);
            if (playerData.partyUUID != null && playerData.partyUUID.equals(targetData.partyUUID) && (party = PartyController.Instance().getParty(playerData.partyUUID)) != null && !party.friendlyFire()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void invoke(LivingHurtEvent event) {
        if (!(event.entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.entityLiving;
        if (event.source.func_76363_c() || event.source.func_76347_k()) {
            return;
        }
        if (!player.func_70632_aY()) {
            return;
        }
        ItemStack item = player.func_71045_bC();
        if (item == null || !(item.func_77973_b() instanceof ItemShield)) {
            return;
        }
        if (((ItemShield)item.func_77973_b()).material.getDamageVsEntity() < player.func_70681_au().nextInt(9)) {
            return;
        }
        float damage = (float)item.func_77960_j() + event.ammount;
        item.func_77972_a((int)event.ammount, (EntityLivingBase)player);
        if (damage > (float)item.func_77958_k()) {
            event.ammount = damage - (float)item.func_77958_k();
        } else {
            event.ammount = 0.0f;
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void invoke(PlayerInteractEvent event) {
        NBTTagCompound compound;
        NBTTagCompound compound2;
        int i;
        NBTTagList list;
        RecipeController controller;
        EntityPlayer player = event.entityPlayer;
        Block block = player.field_70170_p.func_147439_a(event.x, event.y, event.z);
        if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == CustomItems.teleporter) {
            event.setCanceled(true);
        }
        if (block == Blocks.field_150462_ai && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && !player.field_70170_p.field_72995_K) {
            controller = RecipeController.Instance;
            list = new NBTTagList();
            i = 0;
            for (RecipeCarpentry recipe : controller.globalRecipes.values()) {
                list.func_74742_a((NBTBase)recipe.writeNBT());
                if (++i % 10 != 0) continue;
                compound2 = new NBTTagCompound();
                compound2.func_74782_a("recipes", (NBTBase)list);
                Server.sendData((EntityPlayerMP)player, EnumPacketClient.SYNCRECIPES_ADD, compound2);
                list = new NBTTagList();
            }
            if (i % 10 != 0) {
                compound = new NBTTagCompound();
                compound.func_74782_a("recipes", (NBTBase)list);
                Server.sendData((EntityPlayerMP)player, EnumPacketClient.SYNCRECIPES_ADD, compound);
            }
            Server.sendData((EntityPlayerMP)player, EnumPacketClient.SYNCRECIPES_WORKBENCH, new Object[0]);
        }
        if (block == CustomItems.carpentyBench && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && !player.field_70170_p.field_72995_K) {
            controller = RecipeController.Instance;
            list = new NBTTagList();
            i = 0;
            for (RecipeCarpentry recipe : controller.anvilRecipes.values()) {
                list.func_74742_a((NBTBase)recipe.writeNBT());
                if (++i % 10 != 0) continue;
                compound2 = new NBTTagCompound();
                compound2.func_74782_a("recipes", (NBTBase)list);
                Server.sendData((EntityPlayerMP)player, EnumPacketClient.SYNCRECIPES_ADD, compound2);
                list = new NBTTagList();
            }
            if (i % 10 != 0) {
                compound = new NBTTagCompound();
                compound.func_74782_a("recipes", (NBTBase)list);
                Server.sendData((EntityPlayerMP)player, EnumPacketClient.SYNCRECIPES_ADD, compound);
            }
            Server.sendData((EntityPlayerMP)player, EnumPacketClient.SYNCRECIPES_CARPENTRYBENCH, new Object[0]);
        }
        if ((block == CustomItems.banner || block == CustomItems.wallBanner || block == CustomItems.sign) && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            TileBanner tile;
            ItemStack item = player.field_71071_by.func_70448_g();
            if (item == null || item.func_77973_b() == null) {
                return;
            }
            int y = event.y;
            int meta = player.field_70170_p.func_72805_g(event.x, event.y, event.z);
            if (meta >= 7) {
                --y;
            }
            if (!(tile = (TileBanner)player.field_70170_p.func_147438_o(event.x, y, event.z)).canEdit()) {
                if (item.func_77973_b() == CustomItems.wand && CustomNpcsPermissions.hasPermission(player, CustomNpcsPermissions.EDIT_BLOCKS)) {
                    tile.time = System.currentTimeMillis();
                    if (player.field_70170_p.field_72995_K) {
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation("availability.editIcon", new Object[0]));
                    }
                }
                return;
            }
            if (!player.field_70170_p.field_72995_K) {
                tile.icon = item.func_77946_l();
                player.field_70170_p.func_147471_g(event.x, y, event.z);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void invoke(LivingDeathEvent event) {
        if (event.entityLiving.field_70170_p.field_72995_K) {
            return;
        }
        if (event.source.func_76346_g() != null) {
            if (event.source.func_76346_g() instanceof EntityPlayer) {
                this.doExcalibur((EntityPlayer)event.source.func_76346_g(), event.entityLiving);
            }
            if (event.source.func_76346_g() instanceof EntityNPCInterface) {
                EntityNPCInterface npc = (EntityNPCInterface)event.source.func_76346_g();
                Line line = npc.advanced.getKillLine();
                if (line != null) {
                    npc.saySurrounding(line.formatTarget(event.entityLiving));
                }
                EventHooks.onNPCKilledEntity(npc, event.entityLiving);
            }
            EntityPlayer player = null;
            if (event.source.func_76346_g() instanceof EntityPlayer) {
                player = (EntityPlayer)event.source.func_76346_g();
            } else if (event.source.func_76346_g() instanceof EntityNPCInterface && ((EntityNPCInterface)event.source.func_76346_g()).advanced.role == EnumRoleType.Follower) {
                player = ((RoleFollower)((EntityNPCInterface)event.source.func_76346_g()).roleInterface).owner;
            }
            if (player != null) {
                this.doQuest(player, event.entityLiving, true);
                if (event.entityLiving instanceof EntityNPCInterface) {
                    this.doFactionPoints(player, (EntityNPCInterface)event.entityLiving);
                }
            }
        }
        if (event.entityLiving instanceof EntityPlayer) {
            PlayerData data = PlayerDataController.Instance.getPlayerData((EntityPlayer)event.entityLiving);
            data.save();
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (event.entity.field_70170_p.field_72995_K) {
            return;
        }
        NBTTagCompound storedData = event.original.getEntityData().func_74775_l("CNPCStoredData");
        if (!storedData.func_82582_d()) {
            event.entityPlayer.getEntityData().func_74782_a("CNPCStoredData", (NBTBase)storedData);
        }
    }

    private void doExcalibur(EntityPlayer player, EntityLivingBase entity) {
        ItemStack item = player.func_71045_bC();
        if (item == null || item.func_77973_b() != CustomItems.excalibur) {
            return;
        }
        Server.sendData((EntityPlayerMP)player, EnumPacketClient.PLAY_MUSIC, "customnpcs:songs.excalibur");
        player.func_145747_a((IChatComponent)new ChatComponentTranslation("<" + StatCollector.func_74838_a((String)(item.func_77973_b().func_77658_a() + ".name")) + "> " + ItemExcalibur.quotes[player.func_70681_au().nextInt(ItemExcalibur.quotes.length)], new Object[0]));
    }

    private void doFactionPoints(EntityPlayer player, EntityNPCInterface npc) {
        npc.advanced.factions.addPoints(player);
    }

    private void doQuest(EntityPlayer player, EntityLivingBase entity, boolean all) {
        PlayerData playerData = PlayerData.get(player);
        PlayerQuestData questData = playerData.questData;
        boolean checkCompletion = false;
        String entityName = EntityList.func_75621_b((Entity)entity);
        Party party = playerData.getPlayerParty();
        Quest partyQuest = null;
        if (party != null && party.getQuestData() != null) {
            partyQuest = party.getQuestData().quest;
            if (partyQuest != null && (partyQuest.type == EnumQuestType.Kill || partyQuest.type == EnumQuestType.AreaKill)) {
                this.doPartyQuest(player, party, entity);
            } else {
                partyQuest = null;
            }
        }
        ArrayList<QuestData> activeQuestValues = new ArrayList<QuestData>(questData.activeQuests.values());
        for (QuestData data : activeQuestValues) {
            if (data.quest.type != EnumQuestType.Kill && data.quest.type != EnumQuestType.AreaKill || partyQuest != null && partyQuest.getId() == data.quest.getId() || data.quest.partyOptions.allowParty && data.quest.partyOptions.onlyParty) continue;
            if (data.quest.type == EnumQuestType.AreaKill && all) {
                List list = player.field_70170_p.func_72872_a(EntityPlayer.class, entity.field_70121_D.func_72314_b(10.0, 10.0, 10.0));
                for (EntityPlayer pl : list) {
                    if (pl == player) continue;
                    this.doQuest(pl, entity, false);
                }
            }
            String name = entityName;
            QuestKill quest = (QuestKill)data.quest.questInterface;
            Class entityType = EntityNPCInterface.class;
            if (quest.targetType == 2) {
                try {
                    entityType = Class.forName(quest.customTargetType);
                }
                catch (ClassNotFoundException notFoundException) {
                    continue;
                }
            }
            if (quest.targetType > 0 && !entityType.isInstance(entity)) continue;
            if (quest.targets.containsKey(entity.func_70005_c_())) {
                name = entity.func_70005_c_();
            } else if (!quest.targets.containsKey(name)) continue;
            checkCompletion = true;
            HashMap<String, Integer> killed = quest.getKilled(data);
            if (!killed.containsKey(name)) {
                killed.put(name, 1);
            } else if (killed.get(name) < quest.targets.get(name)) {
                int amount = killed.get(name);
                killed.put(name, amount + 1);
            }
            quest.setKilled(data, killed);
            playerData.updateClient = true;
        }
        if (!checkCompletion) {
            return;
        }
        questData.checkQuestCompletion(playerData, EnumQuestType.Kill);
    }

    private void doPartyQuest(EntityPlayer player, Party party, EntityLivingBase entity) {
        PlayerData pdata = PlayerData.get(player);
        QuestData data = party.getQuestData();
        if (data == null) {
            return;
        }
        if (pdata == null) {
            return;
        }
        if (data.quest.type != EnumQuestType.Kill && data.quest.type != EnumQuestType.AreaKill) {
            return;
        }
        String name = EntityList.func_75621_b((Entity)entity);
        QuestKill quest = (QuestKill)data.quest.questInterface;
        if (data.quest.partyOptions.objectiveRequirement == EnumPartyObjectives.Leader && !party.getLeaderUUID().equals(player.func_110124_au())) {
            return;
        }
        Class entityType = EntityNPCInterface.class;
        if (quest.targetType == 2) {
            try {
                entityType = Class.forName(quest.customTargetType);
            }
            catch (ClassNotFoundException notFoundException) {
                return;
            }
        }
        if (quest.targetType > 0 && !entityType.isInstance(entity)) {
            return;
        }
        if (quest.targets.containsKey(entity.func_70005_c_())) {
            name = entity.func_70005_c_();
        } else if (!quest.targets.containsKey(name)) {
            return;
        }
        if (data.quest.partyOptions.objectiveRequirement == EnumPartyObjectives.All) {
            HashMap<String, Integer> killed = quest.getPlayerKilled(data, player.func_70005_c_());
            if (!killed.containsKey(name)) {
                killed.put(name, 1);
            } else if (killed.get(name) < quest.targets.get(name)) {
                int amount = killed.get(name);
                killed.put(name, amount + 1);
            }
            quest.setPlayerKilled(data, killed, player.func_70005_c_());
        } else {
            HashMap<String, Integer> killed = quest.getKilled(data);
            if (!killed.containsKey(name)) {
                killed.put(name, 1);
            } else if (killed.get(name) < quest.targets.get(name)) {
                int amount = killed.get(name);
                killed.put(name, amount + 1);
            }
            quest.setKilled(data, killed);
            pdata.updateClient = true;
        }
        PartyController.Instance().pingPartyQuestObjectiveUpdate(party);
        PartyController.Instance().checkQuestCompletion(party, EnumQuestType.Kill);
    }

    @SubscribeEvent
    public void pickUp(EntityItemPickupEvent event) {
        if (event.entityPlayer.field_70170_p.field_72995_K || event.entityPlayer instanceof FakePlayer) {
            return;
        }
        PlayerData playerData = PlayerDataController.Instance.getPlayerData(event.entityPlayer);
        PlayerQuestData questData = playerData.questData;
        QuestItem.pickedUp = event.item.func_92059_d();
        Party playerParty = playerData.getPlayerParty();
        if (playerParty != null) {
            QuestItem.pickedUpParty = event.item.func_92059_d();
            QuestItem.pickedUpPlayer = event.entityPlayer;
            PartyController.Instance().checkQuestCompletion(playerParty, EnumQuestType.Item);
        }
        questData.checkQuestCompletion(playerData, EnumQuestType.Item);
    }

    @SubscribeEvent
    public void world(PlayerEvent.SaveToFile event) {
        PlayerData data = PlayerDataController.Instance.getPlayerData((EntityPlayer)event.entity);
        data.save();
    }

    @SubscribeEvent
    public void world(EntityJoinWorldEvent event) {
        if (event.world.field_72995_K || !(event.entity instanceof EntityPlayer)) {
            return;
        }
        PlayerData data = PlayerDataController.Instance.getPlayerData((EntityPlayer)event.entity);
        data.updateCompanion(event.world);
    }

    @SubscribeEvent
    public void populateChunk(PopulateChunkEvent.Post event) {
        NPCSpawning.performWorldGenSpawning(event.world, event.chunkX, event.chunkZ, event.rand);
    }

    @SubscribeEvent
    public void playerTracking(PlayerEvent.StartTracking event) {
        if (!(event.target instanceof EntityNPCInterface) || event.target.field_70170_p.field_72995_K) {
            return;
        }
        MarkData data = MarkData.get((EntityNPCInterface)event.target);
        if (data.marks.isEmpty()) {
            return;
        }
        Server.sendData((EntityPlayerMP)event.entityPlayer, EnumPacketClient.MARK_DATA, event.target.func_145782_y(), data.getNBT());
    }
}

