/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import noppes.npcs.client.ClientCacheHandler;
import noppes.npcs.client.gui.customoverlay.OverlayCustom;
import noppes.npcs.client.renderer.MarkRenderer;
import noppes.npcs.client.renderer.RenderCNPCPlayer;
import noppes.npcs.constants.EnumAnimationPart;
import noppes.npcs.controllers.data.Animation;
import noppes.npcs.controllers.data.AnimationData;
import noppes.npcs.controllers.data.FramePart;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.entity.EntityNPCInterface;

public class ClientEventHandler {
    public static final RenderCNPCPlayer renderCNPCPlayer = new RenderCNPCPlayer();
    public static HashMap<Integer, Long> disabledButtonTimes = new HashMap();
    public static float partialHandTicks;
    public static boolean firstPersonAnimation;
    public static float partialRenderTick;
    public static RendererLivingEntity renderer;
    public static EntityNPCInterface renderingNpc;
    public static EntityPlayer renderingPlayer;
    public static HashMap<EnumAnimationPart, String[]> partNames;
    public static HashMap<Class<?>, Field[]> declaredFieldCache;
    public static HashMap<ModelRenderer, FramePart> originalValues;
    public static ModelBase playerModel;

    @SubscribeEvent
    public void onMouse(MouseEvent event) {
        if (Minecraft.func_71410_x().field_71462_r != null) {
            return;
        }
        ArrayList<Integer> removeList = new ArrayList<Integer>();
        for (Map.Entry<Integer, Long> entry : disabledButtonTimes.entrySet()) {
            if (entry.getValue() > 0L) {
                if (entry.getKey() == event.button || entry.getKey() == -1) {
                    event.setCanceled(true);
                }
                disabledButtonTimes.put(entry.getKey(), entry.getValue() - 1L);
                continue;
            }
            removeList.add(entry.getKey());
        }
        Iterator<Map.Entry<Integer, Long>> iterator = removeList.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)((Object)iterator.next());
            disabledButtonTimes.remove(i);
        }
    }

    @SubscribeEvent
    public void onOverlayRender(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.ALL) {
            for (OverlayCustom overlayCustom : ClientCacheHandler.customOverlays.values()) {
                overlayCustom.renderGameOverlay(event.partialTicks);
            }
            if (ClientCacheHandler.questTrackingOverlay != null) {
                ClientCacheHandler.questTrackingOverlay.renderGameOverlay(event.partialTicks);
            }
        }
    }

    @SubscribeEvent
    public void onRenderEntity(RenderLivingEvent.Pre event) {
        if (event.entity instanceof EntityNPCInterface) {
            renderingNpc = (EntityNPCInterface)event.entity;
        }
        renderer = event.renderer;
        partialRenderTick = Minecraft.func_71410_x().field_71428_T.field_74281_c;
    }

    @SubscribeEvent
    public void onRenderEntity(RenderLivingEvent.Post event) {
        AnimationData data = null;
        if (event.entity instanceof EntityNPCInterface) {
            data = ClientEventHandler.renderingNpc.display.animationData;
            MarkData markData = MarkData.get((EntityNPCInterface)event.entity);
            EntityClientPlayerMP entityClientPlayerMP = Minecraft.func_71410_x().field_71439_g;
            if (PlayerData.get((EntityPlayer)entityClientPlayerMP) != null) {
                for (MarkData.Mark m : markData.marks) {
                    if (m.getType() == 0 || !m.availability.isAvailable((EntityPlayer)entityClientPlayerMP)) continue;
                    MarkRenderer.render(event.entity, event.x, event.y, event.z, m);
                    break;
                }
            }
        } else if (event.entity instanceof EntityPlayer) {
            if (ClientCacheHandler.playerAnimations.containsKey(event.entity.func_110124_au())) {
                data = ClientCacheHandler.playerAnimations.get(event.entity.func_110124_au());
            }
            for (Map.Entry entry : originalValues.entrySet()) {
                ModelRenderer renderer = (ModelRenderer)entry.getKey();
                FramePart part = (FramePart)entry.getValue();
                renderer.field_78795_f = part.rotation[0];
                renderer.field_78796_g = part.rotation[1];
                renderer.field_78808_h = part.rotation[2];
                renderer.field_78800_c = part.pivot[0];
                renderer.field_78797_d = part.pivot[1];
                renderer.field_78798_e = part.pivot[2];
            }
            playerModel = null;
        }
        if (data != null && data.isActive() && !Minecraft.func_71410_x().func_147113_T()) {
            Animation animation = data.animation;
            if (data.isActive() && animation.currentFrame().useRenderTicks()) {
                animation.increaseTime();
            }
        }
        renderingNpc = null;
    }

    @SubscribeEvent
    public void onUpdateEntity(LivingEvent.LivingUpdateEvent event) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            AnimationData data = null;
            if (event.entity instanceof EntityNPCInterface) {
                data = ((EntityNPCInterface)event.entity).display.animationData;
            } else if (event.entity instanceof EntityPlayer && ClientCacheHandler.playerAnimations.containsKey(event.entity.func_110124_au())) {
                data = ClientCacheHandler.playerAnimations.get(event.entity.func_110124_au());
            }
            if (data != null && data.isActive()) {
                Animation animation = data.animation;
                if (data.isActive() && !animation.currentFrame().useRenderTicks()) {
                    animation.increaseTime();
                }
            }
        }
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Pre event) {
        renderingPlayer = event.entityPlayer;
    }

    @SubscribeEvent
    public void onRenderPlayer(RenderPlayerEvent.Post event) {
        EntityPlayer player = event.entityPlayer;
        renderingPlayer = null;
        if (ClientEventHandler.hasOverlays(player)) {
            try {
                Class<?> renderPlayerJBRA = Class.forName("JinRyuu.JBRA.RenderPlayerJBRA");
                if (renderPlayerJBRA.isInstance(event.renderer)) {
                    return;
                }
            }
            catch (ClassNotFoundException renderPlayerJBRA) {
                // empty catch block
            }
            if (!(event.renderer instanceof RenderCNPCPlayer)) {
                ClientEventHandler.renderCNPCPlayer.tempRenderPartialTicks = event.partialRenderTick;
                double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.partialRenderTick - RenderManager.field_78725_b;
                double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.partialRenderTick - RenderManager.field_78726_c;
                double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.partialRenderTick - RenderManager.field_78723_d;
                float f1 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * event.partialRenderTick;
                if (Minecraft.func_71410_x().field_71439_g.equals((Object)player)) {
                    d0 = 0.0;
                    d1 = 0.0;
                    d2 = 0.0;
                }
                renderCNPCPlayer.func_76986_a((EntityLivingBase)player, d0, d1, d2, f1, event.partialRenderTick);
            }
        }
    }

    @SubscribeEvent
    public void cancelSpecials(RenderPlayerEvent.Specials.Pre event) {
        if (event.renderer instanceof RenderCNPCPlayer) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void tryRenderDBC(RenderPlayerEvent.Specials.Post event) {
        if (ClientEventHandler.hasOverlays(event.entityPlayer)) {
            try {
                Class<?> renderPlayerJBRA = Class.forName("JinRyuu.JBRA.RenderPlayerJBRA");
                if (!renderPlayerJBRA.isInstance(event.renderer)) {
                    return;
                }
            }
            catch (ClassNotFoundException ignored) {
                return;
            }
            renderCNPCPlayer.renderDBCModel(event);
        }
    }

    public static boolean hasOverlays(EntityPlayer player) {
        return ClientCacheHandler.skinOverlays.containsKey(player.func_110124_au()) && ClientCacheHandler.skinOverlays.get(player.func_110124_au()).values().size() > 0;
    }

    static {
        partNames = new HashMap();
        declaredFieldCache = new HashMap();
        originalValues = new HashMap();
    }
}

